-------------------------------------------------------
-- sine table 8bit + select
-- 2006/8/22
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sinetable8bitsel is
	port(
		clk		:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		sin0	:out std_logic;
		sin1	:out std_logic;
		sin2	:out std_logic;
		sin3	:out std_logic;
		sin4	:out std_logic;
		sin5	:out std_logic;
		sin6	:out std_logic;
		sin7	:out std_logic
	);
end sinetable8bitsel;

architecture rtl of sinetable8bitsel is
	signal rom_adrs	:std_logic_vector(7 downto 0);
	signal rom_latch:std_logic_vector(7 downto 0);
	
	subtype sine_wave is std_logic_vector(7 downto 0);
	type rom is array (0 to 255) of sine_wave;
	constant sine : rom := (
	"10000000","10000011","10000110","10001001","10001100","10001111","10010010","10010101",
	"10011000","10011100","10011111","10100010","10100101","10101000","10101011","10101110",
	"10110000","10110011","10110110","10111001","10111100","10111111","11000001","11000100",
	"11000111","11001001","11001100","11001110","11010001","11010011","11010101","11011000",
	"11011010","11011100","11011110","11100000","11100010","11100100","11100110","11101000",
	"11101010","11101100","11101101","11101111","11110000","11110010","11110011","11110101",
	"11110110","11110111","11111000","11111001","11111010","11111011","11111100","11111100",
	"11111101","11111110","11111110","11111111","11111111","11111111","11111111","11111111",
	"11111111","11111111","11111111","11111111","11111111","11111111","11111110","11111110",
	"11111101","11111100","11111100","11111011","11111010","11111001","11111000","11110111",
	"11110110","11110101","11110011","11110010","11110000","11101111","11101101","11101100",
	"11101010","11101000","11100110","11100100","11100010","11100000","11011110","11011100",
	"11011010","11011000","11010101","11010011","11010001","11001110","11001100","11001001",
	"11000111","11000100","11000001","10111111","10111100","10111001","10110110","10110011",
	"10110000","10101110","10101011","10101000","10100101","10100010","10011111","10011100",
	"10011000","10010101","10010010","10001111","10001100","10001001","10000110","10000011",
	"10000000","01111100","01111001","01110110","01110011","01110000","01101101","01101010",
	"01100111","01100011","01100000","01011101","01011010","01010111","01010100","01010001",
	"01001111","01001100","01001001","01000110","01000011","01000000","00111110","00111011",
	"00111000","00110110","00110011","00110001","00101110","00101100","00101010","00100111",
	"00100101","00100011","00100001","00011111","00011101","00011011","00011001","00010111",
	"00010101","00010011","00010010","00010000","00001111","00001101","00001100","00001010",
	"00001001","00001000","00000111","00000110","00000101","00000100","00000011","00000011",
	"00000010","00000001","00000001","00000000","00000000","00000000","00000000","00000000",
	"00000000","00000000","00000000","00000000","00000000","00000000","00000001","00000001",
	"00000010","00000011","00000011","00000100","00000101","00000110","00000111","00001000",
	"00001001","00001010","00001100","00001101","00001111","00010000","00010010","00010011",
	"00010101","00010111","00011001","00011011","00011101","00011111","00100001","00100011",
	"00100101","00100111","00101010","00101100","00101110","00110001","00110011","00110110",
	"00111000","00111011","00111110","01000000","01000011","01000110","01001001","01001100",
	"01001111","01010001","01010100","01010111","01011010","01011101","01100000","01100011",
	"01100111","01101010","01101101","01110000","01110011","01110110","01111001","01111100");

begin
	process(clk)
	begin
		if(clk' event and clk='1') then
			if(sel1 ='1' and sel2 ='1') then
				rom_adrs <= rom_adrs + 1;
			end if;
			if(sel1 ='0' and sel2 ='1') then
				rom_adrs <= rom_adrs + 2;
			end if;
			if(sel1 ='0' and sel2 ='0') then
				rom_adrs <= rom_adrs + 4; 
			end if;
		end if;
	end process;
	
	process(clk)
	begin
		if(clk' event and clk='0') then
			rom_latch <= sine(conv_integer (rom_adrs));
		end if;
		sin0 <= rom_latch(0);
		sin1 <= rom_latch(1);
		sin2 <= rom_latch(2);
		sin3 <= rom_latch(3);
		sin4 <= rom_latch(4);
		sin5 <= rom_latch(5);
		sin6 <= rom_latch(6);
		sin7 <= rom_latch(7);
	end process;
end rtl;