-------------------------------------------------------
-- 24bit shift with latch
-- 2006/8/3
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity shift24bitlatch is
	port(
		data		:in std_logic;
		clock		:in std_logic;
		latch		:in std_logic;
		reset		:in std_logic;
		data_out0	:out std_logic;
		data_out1	:out std_logic;
		data_out2	:out std_logic;
		data_out3	:out std_logic;
		data_out4	:out std_logic;
		data_out5	:out std_logic;
		data_out6	:out std_logic;
		data_out7	:out std_logic;
		data_out8	:out std_logic;
		data_out9	:out std_logic;
		data_out10	:out std_logic;
		data_out11	:out std_logic;
		data_out12	:out std_logic;
		data_out13	:out std_logic;
		data_out14	:out std_logic;
		data_out15	:out std_logic;
		data_out16	:out std_logic;
		data_out17	:out std_logic;
		data_out18	:out std_logic;
		data_out19	:out std_logic;
		data_out20	:out std_logic;
		data_out21	:out std_logic;
		data_out22	:out std_logic;
		data_out23	:out std_logic
		);
end shift24bitlatch;

architecture rtl of shift24bitlatch is
	signal output_table	:std_logic_vector(23 downto 0);
	signal output_buff	:std_logic_vector(23 downto 0);
	
begin
	process (clock,reset)
	begin
		if(reset= '0') then
			output_buff <= (others => '0');
		elsif (clock' event and clock ='1') then
			output_table(0) <= data;
			output_table(1) <= output_table(0);
			output_table(2) <= output_table(1);
			output_table(3) <= output_table(2);
			output_table(4) <= output_table(3);
			output_table(5) <= output_table(4);
			output_table(6) <= output_table(5);
			output_table(7) <= output_table(6);
			output_table(8) <= output_table(7);
			output_table(9) <= output_table(8);
			output_table(10) <= output_table(9);
			output_table(11) <= output_table(10);
			output_table(12) <= output_table(11);
			output_table(13) <= output_table(12);
			output_table(14) <= output_table(13);
			output_table(15) <= output_table(14);
			output_table(16) <= output_table(15);
			output_table(17) <= output_table(16);
			output_table(18) <= output_table(17);
			output_table(19) <= output_table(18);
			output_table(20) <= output_table(19);
			output_table(21) <= output_table(20);
			output_table(22) <= output_table(21);
			output_table(23) <= output_table(22);
		end if;
	end process;
	
	process (latch)
	begin
		if(latch' event and latch ='1') then
			output_buff(0) <= output_table(0);
			output_buff(1) <= output_table(1);
			output_buff(2) <= output_table(2);
			output_buff(3) <= output_table(3);
			output_buff(4) <= output_table(4);
			output_buff(5) <= output_table(5);
			output_buff(6) <= output_table(6);
			output_buff(7) <= output_table(7);
			output_buff(8) <= output_table(8);
			output_buff(9) <= output_table(9);
			output_buff(10) <= output_table(10);
			output_buff(11) <= output_table(11);
			output_buff(12) <= output_table(12);
			output_buff(13) <= output_table(13);
			output_buff(14) <= output_table(14);
			output_buff(15) <= output_table(15);
			output_buff(16) <= output_table(16);
			output_buff(17) <= output_table(17);
			output_buff(18) <= output_table(18);
			output_buff(19) <= output_table(19);
			output_buff(20) <= output_table(20);
			output_buff(21) <= output_table(21);
			output_buff(22) <= output_table(22);
			output_buff(23) <= output_table(23);
		end if;
	end process;

		data_out0 <= output_buff(0);
		data_out1 <= output_buff(1);
		data_out2 <= output_buff(2);
		data_out3 <= output_buff(3);
		data_out4 <= output_buff(4);
		data_out5 <= output_buff(5);
		data_out6 <= output_buff(6);
		data_out7 <= output_buff(7);
		data_out8 <= output_buff(8);
		data_out9 <= output_buff(9);
		data_out10 <= output_buff(10);
		data_out11 <= output_buff(11);
		data_out12 <= output_buff(12);
		data_out13 <= output_buff(13);
		data_out14 <= output_buff(14);
		data_out15 <= output_buff(15);
		data_out16 <= output_buff(16);
		data_out17 <= output_buff(17);
		data_out18 <= output_buff(18);
		data_out19 <= output_buff(19);
		data_out20 <= output_buff(20);
		data_out21 <= output_buff(21);
		data_out22 <= output_buff(22);
		data_out23 <= output_buff(23);

end rtl;	
		