-------------------------------------------------------
-- 16bit shift
-- 2006/9/10
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity shift16bit is
	port(
		data		:in std_logic;
		clock		:in std_logic;
		reset		:in std_logic;
		data_out0	:out std_logic;
		data_out1	:out std_logic;
		data_out2	:out std_logic;
		data_out3	:out std_logic;
		data_out4	:out std_logic;
		data_out5	:out std_logic;
		data_out6	:out std_logic;
		data_out7	:out std_logic;
		data_out8	:out std_logic;
		data_out9	:out std_logic;
		data_out10	:out std_logic;
		data_out11	:out std_logic;
		data_out12	:out std_logic;
		data_out13	:out std_logic;
		data_out14	:out std_logic;
		data_out15	:out std_logic
		);
end shift16bit;

architecture rtl of shift16bit is
	signal output_table	:std_logic_vector(15 downto 0);
	
begin
	process (clock,reset)
	begin
		if(reset= '0') then
			output_table <= (others => '0');
		elsif (clock' event and clock ='1') then
			output_table(0) <= data;
			output_table(1) <= output_table(0);
			output_table(2) <= output_table(1);
			output_table(3) <= output_table(2);
			output_table(4) <= output_table(3);
			output_table(5) <= output_table(4);
			output_table(6) <= output_table(5);
			output_table(7) <= output_table(6);
			output_table(8) <= output_table(7);
			output_table(9) <= output_table(8);
			output_table(10) <= output_table(9);
			output_table(11) <= output_table(10);
			output_table(12) <= output_table(11);
			output_table(13) <= output_table(12);
			output_table(14) <= output_table(13);
			output_table(15) <= output_table(14);
		end if;
	end process;

		data_out0 <= output_table(0);
		data_out1 <= output_table(1);
		data_out2 <= output_table(2);
		data_out3 <= output_table(3);
		data_out4 <= output_table(4);
		data_out5 <= output_table(5);
		data_out6 <= output_table(6);
		data_out7 <= output_table(7);
		data_out8 <= output_table(8);
		data_out9 <= output_table(9);
		data_out10 <= output_table(10);
		data_out11 <= output_table(11);
		data_out12 <= output_table(12);
		data_out13 <= output_table(13);
		data_out14 <= output_table(14);
		data_out15 <= output_table(15);

end rtl;	
		