-------------------------------------------------------
-- select clock
-- 2007/1/6
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity selclock3 is
	port(
		clk1	:in std_logic;
		clk2	:in std_logic;
		clk3	:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		clkout	:out std_logic
		);
end selclock3;

architecture rtl of selclock3 is

	signal input_sel	:std_logic_vector(1 downto 0);

begin

	input_sel <= sel2 & sel1;
	
	with input_sel select
		clkout <= clk3 	when "11",	-- normal
				  clk2	when "10",	-- fast1
				  clk1	when "01",	-- fast2
				  clk3	when others;
end rtl;	
		