-------------------------------------------------------
--key chata cut
-- 2006/6/5
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity keychatacut is
	port(
		keyin	:in std_logic;
		clkin	:in std_logic;
		keyout	:out std_logic
	);
end keychatacut;

architecture rtl of keychatacut is
	signal keylevel	:std_logic;
	signal T		:std_logic_vector(7 downto 0) :=(others => '0');
	
begin
	keylevel <= not keyin;
	
	process(clkin)
	begin
		if(clkin' event and clkin ='1') then
			if keylevel = T(7) then
				T(7) <= T(7);
				T(6 downto 0) <= (others => '0');
			else
				T <= T+1;
			end if;
		end if;
	end process;
	
	keyout <= T(7);
end rtl;