-------------------------------------------------------
-- decode 24sin
-- 2007/1/1
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity decode24sin is
	port(
		a		:in std_logic;
		b		:in std_logic;
		c		:in std_logic;
		d		:in std_logic;
		e		:in std_logic;
		a2		:out std_logic;
		b2		:out std_logic;
		a1		:out std_logic;
		b1		:out std_logic;
		c1		:out std_logic;
		d1		:out std_logic
		);
end decode24sin;

architecture rtl of decode24sin is
	signal input_table	:std_logic_vector(4 downto 0);
	signal output_table	:std_logic_vector(5 downto 0);
	
begin
	input_table <= e & d & c & b & a;
	with input_table select
		output_table <= "000000" when "00000",	-- 0
						"000001" when "00001",	-- 1
						"000010" when "00010",	-- 2
						"000011" when "00011",	-- 3
						"000100" when "00100",	-- 4
						"000101" when "00101",	-- 5
						"000110" when "00110",	-- 6
						"000111" when "00111",	-- 7
						"001000" when "01000",	-- 8
						"001001" when "01001",	-- 9
						"010000" when "01010",	-- 10
						"010001" when "01011",	-- 11
						"010010" when "01100",	-- 12
						"010011" when "01101",	-- 13						
						"010100" when "01110",	-- 14						
						"010101" when "01111",	-- 15					
						"010110" when "10000",	-- 16
						"010111" when "10001",	-- 17
						"011000" when "10010",	-- 18
						"011001" when "10011",	-- 19
						"100000" when "10100",	-- 20
						"100001" when "10101",	-- 21
						"100010" when "10110",	-- 22
						"100011" when "10111",	-- 23												
						"000000" when others;
						
	a1 <= output_table(0);
	b1 <= output_table(1);
	c1 <= output_table(2);
	d1 <= output_table(3);
	a2 <= output_table(4);
	b2 <= output_table(5);

end rtl;	
		