-------------------------------------------------------
-- 8bit counter
-- 2006/8/21
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity counter8bit is
	port(
		clk		:in std_logic;
		clear	:in std_logic;
		qa		:out std_logic;
		qb		:out std_logic;
		qc		:out std_logic;
		qd		:out std_logic;
		qe		:out std_logic;
		qf		:out std_logic;
		qg		:out std_logic;
		qh		:out std_logic
	);
end counter8bit;

architecture rtl of counter8bit is
	signal incounter	:std_logic_vector(7 downto 0);

begin
	process(clk,clear)
	begin
		if(clear ='1') then
			incounter <= "00000000";
			elsif(clk' event and clk='1') then
				incounter <= incounter + 1;
		end if;
	end process;
	
	qa <= incounter(0);
	qb <= incounter(1);
	qc <= incounter(2);
	qd <= incounter(3);
	qe <= incounter(4);
	qf <= incounter(5);
	qg <= incounter(6);
	qh <= incounter(7);

end rtl;