-------------------------------------------------------
-- counter 6sin
-- 2007/1/1
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity counter6sin is
	port(
		clk		:in std_logic;
		clear	:in std_logic;
		carryin	:in std_logic;
		qa		:out std_logic;
		qb		:out std_logic;
		qc		:out std_logic;
		qd		:out std_logic;
		carryout:out std_logic
	);
end counter6sin;

architecture rtl of counter6sin is
	signal incounter	:std_logic_vector(3 downto 0);

begin
	process(clk,clear,carryin)
	begin
		if(clear ='1') then
			incounter <= "0000";
			elsif(clk' event and clk='1' and carryin ='1') then
				if(incounter = "0101") then
					incounter <= "0000";
				else
					incounter <= incounter + 1;
				end if;
		end if;
	end process;
	
	process(incounter,carryin)
	begin
		if(incounter = "0101" and carryin ='1')then
			carryout <= '1';
		else
			carryout <= '0';
		end if;
	end process;
	
	qa <= incounter(0);
	qb <= incounter(1);
	qc <= incounter(2);
	qd <= incounter(3);

end rtl;