-------------------------------------------------------
--clock gate reset
-- 2006/6/17
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity clkgate is
	port(
		sg_in		:in std_logic;
		clkin		:in std_logic;
		reset		:in std_logic;
		gateout		:out std_logic;
		cnt_clear	:out std_logic;
		latch		:out std_logic
	);
end clkgate;

architecture rtl of clkgate is
	signal	ff2		:std_logic;
begin

	process (reset,clkin)
	begin
		if(reset= '1') then
			ff2 <= '0';
		elsif (clkin' event and clkin = '1') then
			ff2 <= not ff2;
		end if;
	end process;

	process (sg_in)
	begin	
		gateout <= ff2 and sg_in;
	end process;

	cnt_clear <= (not ff2) and (not clkin);
	latch <= not ff2;
	
end rtl;