-------------------------------------------------------
--bunshu latch2 1/10
-- 2006/12/13
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshulatch2 is
	port(
		latchin		:in std_logic;
		latchout	:out std_logic
	);
end bunshulatch2;

architecture rtl of bunshulatch2 is
	signal incounter	:std_logic_vector(3 downto 0);
	
	constant osc_clock	:std_logic_vector(3 downto 0)
		:= conv_std_logic_vector(10-1,4);

begin

	process(latchin)
	begin
		if(latchin' event and latchin ='1') then
			if(incounter = osc_clock) then
				incounter <= (others => '0');
				latchout <= '1';
			else
				incounter <= incounter + 1;
				latchout <= '0';
			end if;
		end if;
	end process;

end rtl;