-------------------------------------------------------
--bunshu counter 1/20
-- 2006/6/5
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshu20 is
	port(
		clkin	:in std_logic;
		clkout	:out std_logic
	);
end bunshu20;

architecture rtl of bunshu20 is
	signal incounter	:std_logic_vector(4 downto 0);
	
	constant osc_clock	:std_logic_vector(4 downto 0)
		:= conv_std_logic_vector(20-1,5);

begin

	process(clkin)
	begin
		if(clkin' event and clkin ='1') then
			if(incounter = osc_clock) then
				incounter <= (others => '0');
				clkout <= '1';
			else
				incounter <= incounter + 1;
				clkout <= '0';
			end if;
		end if;
	end process;
end rtl;