-------------------------------------------------------
--bunshu counter 1/100 or 1/1 sel
-- 2007/1/3
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshu100sel is
	port(
		clkin	:in std_logic;
		clksel	:in	std_logic;
		clkout	:out std_logic
	);
end bunshu100sel;

architecture rtl of bunshu100sel is
	signal incounter	:std_logic_vector(6 downto 0);
	
	constant osc_clock	:std_logic_vector(6 downto 0)
		:= conv_std_logic_vector(100-1,7);

begin

	process(clkin)
	begin
		if(clksel='1') then
			if(clkin' event and clkin ='1') then
				if(incounter >= osc_clock) then
					incounter <= (others => '0');
					clkout <= '1';
				else
					incounter <= incounter + 1;
					clkout <= '0';
				end if;
			end if;
		else
			clkout <= clkin;		
		end if;
	end process;
end rtl;