-------------------------------------------------------
-- bcd 5 dec
-- 2006/6/21
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity bcd5dec is
	port(
		a0		:in std_logic;
		a1		:in std_logic;
		a2		:in std_logic;
		a3		:in std_logic;
		br_in	:in std_logic;
		s0		:out std_logic;
		s1		:out std_logic;
		s2		:out std_logic;
		s3		:out std_logic;
		br_out	:out std_logic
	);
end bcd5dec;

architecture rtl of bcd5dec is
	signal input_data	:std_logic_vector(4 downto 0);
	signal output_data	:std_logic_vector(4 downto 0);

begin
	input_data <= br_in & a3 & a2 & a1 & a0;
	with input_data select
		output_data <= 	"10100" when "10000",
						"10101" when "10001",
						"10110" when "10010",
						"10111" when "10011",
						"11000" when "10100",
						"11001" when "10101",
						"00000" when "10110",
						"00001" when "10111",
						"00010" when "11000",
						"00011" when "11001",
						"10101" when "00000",
						"10110" when "00001",
						"10111" when "00010",
						"11000" when "00011",
						"11001" when "00100",
						"00000" when "00101",
						"00001" when "00110",
						"00010" when "00111",
						"00011" when "01000",
						"00100" when "01001",
						"00000" when others;
							
	s0 <= output_data(0);
	s1 <= output_data(1);
	s2 <= output_data(2);
	s3 <= output_data(3);
	br_out <= output_data(4);

end rtl;