/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define u32 unsigned long
#define u16 unsigned int
#define u8  unsigned char
#define i8  char

#define     LCD_RST     GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS      GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR      GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC      GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD      GPIO_PIN_RB2      //RB2 //2

#define     SW1         GPIO_PIN_RB15
#define     SW2         GPIO_PIN_RB14
#define     RSTB        GPIO_PIN_RC14

#define     I2C_RADIO_ADDR  0x11

#define     SENSOR_LEVEL            500
#define     SENSOR_COUNT_LOOP       20

#define     TIME_DOWN_INIT  150
#define     NEXT_COUNT_INIT 40

#define		FREQ_MIN				522
#define		FREQ_MAX				1620
#define		MUTE_RSSI				20

#define		VOL_COUNT_SET			10
#define		RQST_RSSI_INIT			500
#define 	FREQ_MANUAL_DIV			8
#define		FREQ_MANUAL_DIV_CNT		80

#define     VOLUME_SET_DATA         54
/*
//==================================================================
// General Commands
//==================================================================
*/

/* STATUS bits - Used by all methods */
#define STCINT  0x01
#define ASQINT  0x02
#define RDSINT  0x04
#define RSQINT  0x08
#define ERR     0x40
#define CTS     0x80

/* POWER_UP*/
#define POWER_UP                      0x01
/*
#define POWER_UP_IN_FUNC_FMRX         0x00
*/
#define POWER_UP_IN_FUNC_AMRX         0x01
/*
#define POWER_UP_IN_FUNC_FMTX         0x02
#define POWER_UP_IN_FUNC_WBRX         0x03
#define POWER_UP_IN_FUNC_QUERY        0x0F
#define POWER_UP_IN_PATCH             0x20
#define POWER_UP_IN_GPO2OEN           0x40
#define POWER_UP_IN_CTSIEN            0x80
*/
#define POWER_UP_IN_OPMODE_RX_ANALOG  0x05
/*
#define POWER_UP_IN_OPMODE_TX_ANALOG  0x50
*/
#define POWER_UP_IN_XOSCEN			  0x10

/* GET_REV */
#define GET_REV 0x10

/* POWER_DOWN */
#define POWER_DOWN 0x11

/* SET_PROPERTY */
#define SET_PROPERTY 0x12

/* GET_PROPERTY */
#define GET_PROPERTY 0x13

/* GET_INT_STATUS */
#define GET_INT_STATUS 0x14

/*
//==================================================================
// AM Receive Commands
//==================================================================
*/
/* AM_TUNE_FREQ */
#define AM_TUNE_FREQ 0x40

/* AM_TUNE_STATUS */
#define AM_TUNE_STATUS           0x42
#define AM_TUNE_STATUS_IN_INTACK 0x01
#define AM_TUNE_STATUS_IN_CANCEL 0x02
#define AM_TUNE_STATUS_OUT_VALID 0x01
#define AM_TUNE_STATUS_OUT_AFCRL 0x02
#define AM_TUNE_STATUS_OUT_BTLF  0x80

#define	AM_RSQ_STATUS			0x43
/*
//==================================================================
// AM Receive Properties
//==================================================================
*/
/* AM_DEEMPHASIS */
#define AM_DEEMPHASIS      0x3100
#define AM_DEEMPHASIS_MASK 0x0001
#define AM_DEEMPHASIS_SHFT 0

/* AM_CHANNEL_FILTER*/
#define AM_CHANNEL_FILTER      0x3102
#define AM_CHANNEL_FILTER_MASK 0x0007
#define AM_CHANNEL_FILTER_SHFT 0

/* AM_SOFT_MUTE_RATE */
#define AM_SOFT_MUTE_RATE 0x3300

/* AM_SOFT_MUTE_SLOPE */
#define AM_SOFT_MUTE_SLOPE 0x3301
#define AM_SOFT_MUTE_SLOPE_MASK 0x000F
#define AM_SOFT_MUTE_SLOPE_SHFT 0

/* AM_SOFT_MUTE_MAX_ATTENUATION */
#define AM_SOFT_MUTE_MAX_ATTENUATION 0x3302
#define AM_SOFT_MUTE_MAX_ATTENUATION_MASK 0x003F
#define AM_SOFT_MUTE_MAX_ATTENUATION_SHFT 0

/* AM_SOFT_MUTE_SNR_THRESHOLD */
#define AM_SOFT_MUTE_SNR_THRESHOLD 0x3303
#define AM_SOFT_MUTE_SNR_THRESHOLD_MASK 0x003F
#define AM_SOFT_MUTE_SNR_THRESHOLD_SHFT 0

/* AM_SEEK_BAND_BOTTOM */
#define AM_SEEK_BAND_BOTTOM 0x3400

/* AM_SEEK_BAND_TOP */
#define AM_SEEK_BAND_TOP 0x3401

/* AM_SEEK_FREQ_SPACING */
#define AM_SEEK_FREQ_SPACING      0x3402
#define AM_SEEK_FREQ_SPACING_MASK 0x000F
#define AM_SEEK_FREQ_SPACING_SHFT 0

/* AM_SEEK_TUNE_SNR_THRESHOLD */
#define AM_SEEK_TUNE_SNR_THRESHOLD      0x3403
#define AM_SEEK_TUNE_SNR_THRESHOLD_MASK 0x003F
#define AM_SEEK_TUNE_SNR_THRESHOLD_SHFT 0

/* AM_SEEK_TUNE_RSSI_THRESHOLD */
#define AM_SEEK_TUNE_RSSI_THRESHOLD      0x3404
#define AM_SEEK_TUNE_RSSI_THRESHOLD_MASK 0x003F
#define AM_SEEK_TUNE_RSSI_THRESHOLD_SHFT 0
/*
//==================================================================
// General Receive Properties
//==================================================================
*/
/* RX_VOLUME */
#define RX_VOLUME      0x4000
#define RX_VOLUME_MASK 0x003F
#define RX_VOLUME_SHFT 0

/* RX_HARD_MUTE */
#define RX_HARD_MUTE 0x4001
#define RX_HARD_MUTE_RMUTE_MASK 0x0001
#define RX_HARD_MUTE_LMUTE_MASK 0x0002
#define RX_HARD_MUTE_RMUTE_SHFT 0
#define RX_HARD_MUTE_LMUTE_SHFT 1
/*
//==================================================================
// Bit Definitions for Properties
//==================================================================
*/
/* AM_CHANNEL_FILTER_BW */
#define AM_CHANNEL_FILTER_BW_6KHZ 0
#define AM_CHANNEL_FILTER_BW_4KHZ 1
#define AM_CHANNEL_FILTER_BW_3KHZ 2
#define AM_CHANNEL_FILTER_BW_2KHZ 3
#define AM_CHANNEL_FILTER_BW_1KHZ 4

/*
//-----------------------------------------------------------------------------
// Defines
//-----------------------------------------------------------------------------
*/
#define READ    1
#define WRITE   0

#define POWERUP_TIME 110    /* Powerup delay in milliseconds*/
#define GPO_IEN				 0x0001
#define GPO_IEN_STCIEN_MASK  0x0001



// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
struct {
	unsigned int PoweredUp : 1;
}Bit;

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;

unsigned char   pal_no;

unsigned char   cmd[8];
unsigned char   rsp[15];
unsigned char   RSSI;
unsigned char   STC;
unsigned char   BLTF;
unsigned char   AFCRL;
unsigned char   Valid;
unsigned int    Freq;
unsigned char   ASNR;
unsigned int    AntCap;

unsigned char   partNumber;
char 			fwMajor;
char 			fwMinor;
unsigned int    patchID;
char			cmpMajor;
char			cmpMinor;
char			chipRev;

unsigned int	khz_no;
unsigned int	khz_no_m;
unsigned char	mode;
unsigned char	width;

unsigned int	preset[13]={864,954,1008,1026,1053,1134,1143,1179,1242,1314,1332,1512,1557};
//unsigned int    stereo_mono[12]={0,0,0,0,0,0,1,1,1,1,1,1};
//unsigned int    stm;

unsigned int	cnt_no;
unsigned int	cnt_khz;

unsigned char	tun_flg;

unsigned int	vol_count;

//uint32_t        adc_data;
unsigned short	vol_level;
unsigned short	vol_level_m;

unsigned short  batt_level;

unsigned char   vram[6400];

unsigned char color_data1_init[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2_init[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char   pal_color[8][16]={
{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},
{7,15,9,14,4,3,6,0,5,9,10,12,1,13,14,15},
{0,2,1,9,4,11,6,4,13,9,10,3,12,13,14,15},
{7,13,2,14,4,9,6,12,8,9,10,15,1,13,14,15},
{0,9,2,14,4,3,6,8,11,9,10,1,12,13,14,15},
{0,12,2,9,4,1,6,6,8,9,10,3,11,13,14,15},
{0,7,7,7,4,7,6,0,7,9,10,7,7,13,14,15},
{0,0,0,0,4,0,6,7,0,9,10,0,0,13,14,15},
};

const   unsigned char   font_moji_p1[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,34,119,119,7,34,119,119,0,34,119,119,32,34,119,119,32,34,119,119,32,34,119,7,32,34,119,7,34,34,119,7,34,34,119,7,34,34,119,7,34,34,119,0,34,34,119,32,34,34,119,32,34,34,119,32,34,34,7,32,34,34,7,34,34,34,7,34,34,34,7,34,34,34,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,0,0,34,34,112,119,34,2,112,7,34,2,119,0,34,2,0,32,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,0,0,0,34,112,119,119,34,112,119,119,2,112,119,119,2,119,119,119,0,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,34,34,34,0,34,34,34,2,34,34,34,2,34,34,34,2,34,34,34,2,32,34,34,2,32,34,34,2,32,34,34,2,34,34,34,2,34,34,34,0,34,34,34,112,34,34,34,112,34,34,2,112,34,34,0,119,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_r1[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,34,119,119,32,34,119,119,32,34,119,119,32,34,119,7,32,34,119,7,34,34,119,7,34,34,119,7,34,34,119,7,34,34,119,0,34,34,119,32,34,34,119,32,34,34,119,32,34,34,119,32,34,34,7,32,34,34,7,34,34,34,7,34,34,34,7,34,34,34,7,34,34,34,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,2,0,32,34,2,119,32,34,0,7,32,34,112,7,34,34,0,0,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,2,0,34,34,2,7,34,34,2,7,34,34,0,7,32,34,112,119,32,34,112,119,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,119,34,34,0,119,34,34,2,112,34,34,34,112,34,34,34,112,34,34,34,112,34,34,34,112,34,34,34,112,34,34,2,112,34,34,2,119,34,34,0,119,34,2,112,119,34,0,119,119,0,112,119,119,2,112,119,119,34,112,119,119,34,0,119,119,34,2,112,119,34,34,0,119,34,34,2,119,0,0,0,119,119,119,119,119,},
};
const   unsigned char   font_moji_m2[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,17,119,119,0,17,119,119,16,17,119,119,16,17,119,119,16,17,119,119,16,17,119,7,16,17,119,7,17,17,119,7,17,17,119,7,17,17,119,0,17,17,119,16,17,17,119,16,17,17,119,16,17,17,119,16,17,17,7,16,17,17,7,17,17,17,7,17,17,1,7,17,17,1,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,7,17,17,1,7,17,17,1,0,17,17,1,16,17,17,1,16,17,17,1,16,17,17,1,17,17,17,1,17,17,17,1,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,17,17,1,1,17,17,1,0,17,17,1,0,17,17,16,0,17,17,16,0,17,1,16,7,17,1,16,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,0,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,1,112,17,17,1,119,17,17,1,119,17,17,0,119,17,17,112,119,17,17,112,119,17,17,112,119,0,0,112,119,119,119,119,119,},
};
const   unsigned char   font_moji_a2[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,16,119,119,7,16,119,119,7,17,119,119,7,17,119,119,0,17,119,119,16,17,119,7,16,17,119,7,17,17,119,0,17,17,119,16,17,17,7,16,17,17,7,17,17,17,7,17,17,17,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,7,0,0,0,7,17,17,17,0,17,17,17,16,17,17,17,16,17,17,17,17,17,17,17,17,17,17,16,17,17,1,16,17,17,1,16,17,17,0,16,17,17,112,16,17,17,0,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,16,17,112,119,16,1,112,119,16,0,119,119,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,17,17,1,119,0,0,0,119,119,119,119,119,},
};
const   unsigned char   font_moji_s3[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,96,119,119,0,102,119,119,96,102,119,7,96,102,119,7,102,102,119,7,102,102,119,7,102,102,119,7,102,102,119,7,102,102,119,7,102,102,119,7,96,102,119,119,0,0,119,0,0,119,7,96,6,0,7,102,102,102,7,102,102,102,7,102,102,102,7,102,102,102,7,0,102,102,119,7,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,6,0,102,102,0,119,102,102,0,0,102,102,102,102,102,102,102,102,102,102,102,102,0,0,96,102,119,7,96,102,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,102,102,102,112,102,102,102,112,102,102,102,112,102,102,102,112,102,102,6,112,0,0,0,119,119,119,119,119,0,0,119,119,102,6,112,119,102,102,112,119,102,102,112,119,102,102,112,119,102,102,112,119,102,102,112,119,102,102,112,119,102,6,112,119,102,6,119,119,102,0,119,119,0,112,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_t3[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,102,119,119,0,102,119,119,96,102,119,119,96,102,119,119,96,102,119,119,96,102,119,119,0,0,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,96,119,119,119,96,119,119,7,96,119,119,7,102,119,119,7,102,119,119,7,102,119,119,7,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,96,102,102,102,96,102,102,102,96,102,102,102,102,102,102,102,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,0,102,102,102,112,102,102,102,112,102,102,102,112,102,102,102,112,0,0,0,112,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,102,102,102,112,102,102,102,112,102,102,102,112,102,102,6,112,102,102,0,119,102,102,112,119,0,0,112,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_m4[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,0,51,51,119,48,51,51,119,48,51,51,119,48,51,51,119,48,51,51,7,48,51,51,7,51,51,51,7,51,51,3,7,51,51,3,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,7,51,51,3,7,51,51,3,0,51,51,3,48,51,51,3,48,51,51,3,48,51,51,3,51,51,51,3,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,3,3,51,51,3,0,51,51,3,0,51,51,48,0,51,51,48,0,51,3,48,7,51,3,48,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,0,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,3,112,51,51,3,119,51,51,3,119,51,51,0,119,51,51,112,119,51,51,112,119,51,51,112,119,0,0,112,119,119,119,119,119,},
};
const   unsigned char   font_moji_o4[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,48,119,119,0,51,119,7,48,51,119,7,51,51,119,0,51,51,119,48,51,51,119,48,51,51,7,48,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,48,51,51,119,0,51,51,119,7,0,51,119,119,7,0,119,119,119,119,},
{119,119,119,119,7,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,0,51,51,0,7,48,3,112,119,48,3,119,119,48,3,119,7,48,3,119,7,51,3,112,0,51,51,0,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,0,0,0,0,119,119,119,119,},
{119,119,119,119,0,119,119,119,3,0,112,119,51,51,0,119,51,51,3,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,3,112,51,51,3,119,51,51,3,119,51,51,0,119,51,51,112,119,51,3,112,119,51,0,119,119,0,112,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_s5[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,128,119,119,0,136,119,119,128,136,119,7,128,136,119,7,136,136,119,7,136,136,119,7,136,136,119,7,136,136,119,7,136,136,119,7,136,136,119,7,128,136,119,119,0,0,119,0,0,119,7,128,8,0,7,136,136,136,7,136,136,136,7,136,136,136,7,136,136,136,7,0,136,136,119,7,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,8,0,136,136,0,119,136,136,0,0,136,136,136,136,136,136,136,136,136,136,136,136,0,0,128,136,119,7,128,136,0,0,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,136,136,136,112,136,136,136,112,136,136,136,112,136,136,136,112,136,136,8,112,0,0,0,119,119,119,119,119,0,0,119,119,136,8,112,119,136,136,112,119,136,136,112,119,136,136,112,119,136,136,112,119,136,136,112,119,136,136,112,119,136,8,112,119,136,8,119,119,136,0,119,119,0,112,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_b6[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,204,119,119,0,204,119,119,192,204,119,119,192,204,119,119,192,204,119,7,192,204,119,7,204,204,119,7,204,204,119,7,204,204,119,7,204,204,119,0,204,204,119,192,204,204,119,192,204,204,119,192,204,204,119,192,204,204,7,192,204,204,7,204,204,204,7,204,204,204,7,204,204,204,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,0,192,204,12,119,192,204,12,119,192,204,12,0,192,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,204,204,112,7,204,204,112,7,204,204,0,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,119,204,204,0,119,204,204,12,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,12,112,204,204,12,119,204,204,0,119,204,0,112,119,204,204,0,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,0,119,204,204,112,119,204,12,112,119,204,0,119,119,0,112,119,119,119,119,119,119,},    
};
const   unsigned char   font_moji_a6[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,192,119,119,7,192,119,119,7,204,119,119,7,204,119,119,0,204,119,119,192,204,119,7,192,204,119,7,204,204,119,0,204,204,119,192,204,204,7,192,204,204,7,204,204,204,7,204,204,204,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,7,0,0,0,7,204,204,204,0,204,204,204,192,204,204,204,192,204,204,204,204,204,204,204,204,204,204,192,204,204,12,192,204,204,12,192,204,204,0,192,204,204,112,192,204,204,0,192,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,192,204,112,119,192,12,112,119,192,0,119,119,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,0,0,0,119,119,119,119,119,},
};
const   unsigned char   font_moji_t6[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,204,119,119,0,204,119,119,192,204,119,119,192,204,119,119,192,204,119,119,192,204,119,119,0,0,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,192,119,119,119,192,119,119,7,192,119,119,7,204,119,119,7,204,119,119,7,204,119,119,7,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,192,204,204,204,192,204,204,204,192,204,204,204,204,204,204,204,204,204,204,12,204,204,204,12,204,204,204,12,204,204,204,12,204,204,204,0,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,0,0,0,112,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,12,112,204,204,0,119,204,204,112,119,0,0,112,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_dot[2][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,0,51,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,3,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,3,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_sp[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},    
};

const   unsigned char   font_moji_kh[4][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,48,119,119,119,48,119,119,119,48,119,119,119,48,119,119,119,48,119,119,119,48,119,119,7,48,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,0,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,0,51,51,51,48,51,51,51,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,0,48,51,51,112,48,51,51,112,48,51,51,112,0,51,51,112,7,0,0,112,7,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,112,0,0,0,112,48,51,51,0,48,51,51,0,51,51,51,0,51,51,51,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,51,0,51,51,51,112,51,51,3,112,51,51,3,119,51,51,0,119,51,51,3,119,51,51,3,119,51,51,3,112,51,51,51,112,51,51,51,112,51,51,51,0,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,51,3,119,119,51,3,119,119,51,0,119,119,3,112,119,119,3,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,},
};

const   unsigned char   font_moji_par[4][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,48,119,119,0,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,48,51,119,119,0,48,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,51,51,3,112,51,51,51,0,51,51,51,3,51,51,51,3,51,51,51,3,0,51,51,3,0,51,51,3,0,51,51,0,0,51,51,48,51,51,3,48,51,51,3,51,51,51,3,51,51,51,48,51,51,3,48,51,0,0,51,51,119,0,51,51,119,48,51,51,7,48,51,51,7,51,51,3,0,51,51,3,48,51,51,0,48,51,51,112,51,51,3,112,51,51,3,119,51,51,0,119,0,0,112,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,0,119,0,51,51,7,48,51,51,7,51,51,3,0,51,51,3,48,51,51,0,48,51,51,112,51,51,3,112,51,51,3,119,51,51,0,119,51,51,112,119,51,3,0,0,51,3,0,51,51,0,51,51,51,48,51,51,3,48,51,51,3,51,51,51,0,51,51,0,48,51,51,0,48,51,3,0,48,51,3,48,48,51,3,48,48,51,51,51,48,51,51,51,0,51,51,51,7,48,51,51,119,0,0,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,112,119,119,51,0,119,119,51,3,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,3,112,119,51,3,119,119,51,0,119,119,3,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,},
};

//const   unsigned char   font_moji_mh1[3][96]={
//{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,153,119,119,0,153,119,119,144,153,119,119,144,153,119,119,144,153,119,119,144,153,119,7,144,153,119,7,153,153,119,7,153,153,119,7,153,153,119,0,153,153,119,144,153,153,119,144,153,153,119,144,153,153,119,144,153,153,7,144,153,153,7,153,153,153,7,153,153,9,7,153,153,9,7,0,0,0,119,119,119,119,},
//{119,119,119,119,119,119,119,119,0,0,0,7,153,153,9,7,153,153,9,0,153,153,9,144,153,153,9,144,153,153,9,144,153,153,9,153,153,153,9,153,153,153,9,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,9,153,153,9,9,153,153,9,0,153,153,9,0,153,153,144,0,153,153,144,0,153,9,144,7,153,9,144,7,0,0,0,119,119,119,119,},
//{119,119,119,119,119,119,119,119,0,0,0,0,153,153,153,9,153,153,153,9,153,153,153,9,153,153,153,9,153,153,153,9,153,153,153,0,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,0,153,153,9,0,153,153,9,7,153,153,9,7,153,153,0,7,153,153,112,0,153,153,112,144,153,153,112,144,0,0,112,0,119,119,119,119,},
//};
//const   unsigned char   font_moji_mh2[3][96]={
//{119,119,119,119,119,119,119,119,119,0,0,0,119,144,153,153,119,144,153,153,119,144,153,153,7,144,153,153,7,153,153,153,7,153,153,153,7,153,153,153,0,153,153,153,144,153,153,153,144,153,153,153,144,153,153,153,144,153,153,153,153,153,153,153,153,153,153,153,153,153,153,9,153,153,153,9,153,153,153,9,153,153,153,9,153,153,153,0,0,0,0,112,119,119,119,119,},
//{119,119,119,119,119,119,119,119,0,0,7,0,153,9,7,153,153,9,7,153,153,0,7,153,153,112,0,153,153,112,144,153,9,112,144,153,9,0,144,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,144,153,153,112,144,153,153,112,144,153,153,7,144,153,153,7,153,153,153,7,153,153,153,7,153,153,153,7,0,0,0,119,119,119,119,},
//{119,119,119,119,119,119,119,119,0,0,0,119,153,153,9,119,153,153,9,119,153,153,9,0,153,153,9,144,153,153,9,144,153,153,0,153,153,153,0,153,153,153,0,153,153,153,0,153,153,9,0,0,153,9,119,7,153,9,119,0,153,9,7,144,153,0,0,153,153,0,153,153,153,0,153,153,153,0,153,153,9,0,153,153,9,7,153,153,0,7,0,0,119,119,119,119,},
//};
//const   unsigned char   font_moji_mh3[2][96]={
//{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,153,153,153,144,153,153,153,153,153,153,153,153,153,153,9,153,153,153,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,0,0,0,119,119,119,119,},
//{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,0,119,153,9,112,119,153,0,119,119,0,112,119,119,112,119,119,119,0,0,119,119,153,9,119,119,153,9,119,119,153,9,119,119,153,0,119,119,153,112,119,119,0,112,119,119,119,119,119,119,},
//};

const   unsigned char   font_suji_0[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,5,112,85,85,0,119,85,85,112,119,85,5,112,119,5,0,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_1[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_2[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,7,0,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,5,0,119,85,0,119,119,85,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_3[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,7,0,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,0,0,0,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_4[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_5[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,0,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,80,119,119,119,0,119,119,119,7,119,119,119,119,0,119,119,119,5,112,119,7,85,112,119,7,85,0,112,0,85,85,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,0,0,0,0,119,119,119,112,119,119,119,0,0,0,119,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,85,0,112,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_6[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,5,0,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,0,0,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,0,119,119,5,112,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_7[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,0,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_8[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,0,80,85,85,119,80,85,85,0,80,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,0,112,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_9[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,0,0,80,119,119,0,85,119,119,80,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,112,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_space[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_bar[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};

const   unsigned char   font_suji_0s[2][64]={
{119,119,119,119,119,119,0,0,119,0,176,187,119,176,187,187,119,176,187,187,7,176,187,187,7,187,187,11,7,187,187,0,7,187,187,112,7,187,187,0,7,187,187,0,7,187,187,187,7,187,187,187,7,187,187,187,7,0,187,187,119,7,0,0,},
{119,119,119,119,0,0,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,176,187,11,119,176,187,11,119,176,187,11,119,176,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,11,112,119,11,0,119,119,0,119,119,119,},
};
const   unsigned char   font_suji_1s[2][64]={
{119,119,119,119,119,119,7,0,119,119,0,187,119,119,176,187,119,7,176,187,119,0,187,187,119,176,187,187,119,176,11,187,119,0,0,187,119,119,176,187,119,119,176,187,119,119,176,187,119,7,176,187,119,7,187,187,119,7,187,187,119,7,0,0,},
{119,119,119,119,0,0,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,11,112,119,187,11,119,119,187,11,119,119,187,11,119,119,187,11,119,119,187,0,119,119,187,112,119,119,187,112,119,119,187,112,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_2s[2][64]={
{119,119,119,119,119,119,7,0,119,119,0,187,119,119,176,187,119,7,187,187,119,0,187,187,119,176,187,11,119,176,187,11,119,0,0,0,119,119,0,176,119,0,176,187,7,176,187,187,7,187,187,187,7,187,187,187,7,187,187,187,7,0,0,0,},
{119,119,119,119,0,0,0,119,187,187,11,112,187,187,187,112,187,187,187,112,187,187,187,112,0,187,187,112,176,187,187,112,187,187,11,112,187,187,0,119,187,0,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,0,0,112,119,},
};
const   unsigned char   font_suji_3s[2][64]={
{119,119,119,119,119,7,0,0,119,7,187,187,119,0,187,187,119,176,187,187,119,0,0,0,119,119,0,176,119,7,176,187,119,7,187,187,119,7,0,0,7,0,112,0,7,187,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,187,112,187,187,11,112,187,11,0,119,187,0,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,0,112,119,0,112,119,119,},
};
const   unsigned char   font_suji_4s[2][64]={
{119,119,119,119,119,119,119,0,119,119,7,176,119,119,0,187,119,119,176,187,119,7,176,187,119,0,187,187,119,176,187,11,7,176,187,0,7,187,187,0,7,187,187,187,7,187,187,187,7,187,187,187,7,0,0,176,119,119,119,176,119,119,119,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,176,187,11,119,176,187,11,119,187,187,0,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,11,0,119,187,11,119,119,0,0,119,119,},
};
const   unsigned char   font_suji_5s[2][64]={
{119,119,119,119,119,7,0,0,119,7,187,187,119,7,187,187,119,0,187,187,119,176,187,187,119,176,187,11,119,176,187,187,119,176,187,187,119,0,0,176,7,0,112,0,7,187,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,0,0,0,119,187,11,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_6s[2][64]={
{119,119,119,119,119,119,0,0,119,7,176,187,119,0,187,187,119,176,187,187,119,176,187,187,7,176,187,11,7,187,187,187,7,187,187,187,7,187,187,0,7,187,187,0,7,187,187,0,7,187,187,187,7,176,187,187,119,0,187,187,119,7,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,0,187,11,119,0,0,0,119,187,187,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_7s[2][64]={
{119,119,119,119,119,0,0,0,119,176,187,187,7,176,187,187,7,187,187,187,7,187,187,187,7,0,0,176,119,119,7,187,119,119,0,187,119,7,176,187,119,7,187,187,119,0,187,187,7,176,187,187,7,187,187,187,7,187,187,11,7,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,187,187,11,119,187,187,0,119,187,11,112,119,187,11,119,119,187,0,119,119,11,112,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_suji_8s[2][64]={
{119,119,119,119,119,119,0,0,119,7,176,187,119,0,187,187,119,176,187,187,119,176,187,187,119,176,187,11,119,0,187,187,119,0,176,187,7,176,187,187,7,187,187,11,7,187,187,0,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,119,187,187,11,112,187,187,187,112,187,187,187,112,0,187,187,112,176,187,187,112,187,187,11,112,187,11,0,119,187,187,11,119,176,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,187,0,112,119,0,0,119,119,},
};
const   unsigned char   font_suji_9s[2][64]={
{119,119,119,119,119,119,0,0,119,0,176,187,119,176,187,187,119,176,187,187,7,176,187,11,7,187,187,11,7,187,187,11,7,187,187,187,7,176,187,187,119,0,187,11,7,0,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,112,119,187,187,0,119,187,187,11,119,187,187,11,112,176,187,187,112,176,187,187,112,176,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,187,187,11,119,187,187,0,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};

const unsigned char font_suji_8_dot1[32]={7,0,0,112,0,34,34,0,32,34,34,2,32,34,34,2,32,34,34,2,32,34,34,2,0,34,34,0,7,0,0,112,};
const unsigned char font_suji_8_dot2[32]={7,0,0,112,0,17,17,0,16,17,17,1,16,17,17,1,16,17,17,1,16,17,17,1,0,17,17,0,7,0,0,112,};
const unsigned char font_suji_8_dot3[32]={7,0,0,112,0,102,102,0,96,102,102,6,96,102,102,6,96,102,102,6,96,102,102,6,0,102,102,0,7,0,0,112,};
const unsigned char font_suji_8_dot4[32]={7,0,0,112,0,51,51,0,48,51,51,3,48,51,51,3,48,51,51,3,48,51,51,3,0,51,51,0,7,0,0,112,};
const unsigned char font_suji_8_dot5[32]={7,0,0,112,0,85,85,0,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,5,0,85,85,0,7,0,0,112,};



//unsigned char test_moji1[20]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
//unsigned char test_moji2[26]={10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35};

// delay
#define CCLK		(800000L)//	(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_us(10);    
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);
    
    send_cmd(0x3a);
    send_data(0x05);    
    
    send_cmd(0xb1);
    send_data(0x05);
    send_data(0x3c);    
    send_data(0x3c);      

    send_cmd(0xb2);
    send_data(0x05);
    send_data(0x3c);  
    send_data(0x3c);      
    
    send_cmd(0xb3);
    send_data(0x05);
    send_data(0x3c); 
    send_data(0x3c); 

    send_cmd(0xb4);
    send_data(0x03);    
    
    send_cmd(0xc0);
    send_data(0xe0);
    send_data(0x00);
    send_data(0x84);    

    send_cmd(0xc1);
    send_data(0x05);
    
    send_cmd(0xc2);
    send_data(0x0d);
    send_data(0x00);   

    send_cmd(0xc3);
    send_data(0x8d);
    send_data(0xea);   

    send_cmd(0xc4);
    send_data(0x8d);
    send_data(0xee);
    
    send_cmd(0xc5);
    send_data(0x03);    
    
    send_cmd(0xc7);
    send_data(0x0a);  

    send_cmd(0x36);
    send_data(0x68);        //c8

    send_cmd(0xe0);
    send_data(0x1b);
    send_data(0x1a);
    send_data(0x10);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x2a);
    send_data(0x2a);
    send_data(0x2c);
    send_data(0x27);
    send_data(0x2e);
    send_data(0x39);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0xe1);
    send_data(0x1a);
    send_data(0x1a);
    send_data(0x0f);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x25);
    send_data(0x2b);
    send_data(0x26);
    send_data(0x26);
    send_data(0x2f);
    send_data(0x3a);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0x11);
    delay_ms(130);    

    send_cmd(0x29);
    delay_ms(100);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
    
    send_cmd(0x2b);
    send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0x9f  
}

void    disp_main2(void)
{
    unsigned int    i;
    unsigned char   data1,data2;

            GPIO_PinWrite(GPIO_PIN_RE5,1);
            send_cmd(0x2a);
            send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
            send_cmd(0x2b);
            send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0xa0 
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
            
            for (i=0;i<6400;i++){
                data2=vram[i] >> 4;
                data1=vram[i] & 0x0f;
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
            }
            GPIO_PinWrite(GPIO_PIN_RE5,0);                
}
//void    test_vram(void)
//{
//    unsigned int    i;
    
//    for(i=0;i<6400/2;i++){
//        vram[i*2]=0x13;
//        vram[i*2+1]=0x45;
//    }
//}

void    vram_clear(unsigned char color)
{
    unsigned int i;
    unsigned char data;
    
    data=(color << 4) | color;
    
    for(i=0;i<6400;i++){
        vram[i]=data;
    }
}
void    vram_set_8_dot1(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j;
    
    for(j=0;j<8;j++){
        for(i=0;i<4;i++){
            data=font_suji_8_dot1[j*4+i];
            vram[xx+i+(yy*2+j)*80]=data;
        }
    }
}
void    vram_set_8_dot2(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j;
    
    for(j=0;j<8;j++){
        for(i=0;i<4;i++){
            data=font_suji_8_dot2[j*4+i];
            vram[xx+i+(yy*2+j)*80]=data;
        }
    }
}
//void    vram_set_8_dot3(unsigned int xx,unsigned int yy)
//{
//    unsigned char   data;
//    unsigned int    i,j;
    
//    for(j=0;j<8;j++){
//        for(i=0;i<4;i++){
//            data=font_suji_8_dot3[j*4+i];
//            vram[xx+i+(yy*2+j)*80]=data;
//        }
//    }
//}
//void    vram_set_8_dot4(unsigned int xx,unsigned int yy)
//{
//    unsigned char   data;
//    unsigned int    i,j;
    
//    for(j=0;j<8;j++){
//        for(i=0;i<4;i++){
//            data=font_suji_8_dot4[j*4+i];
//            vram[xx+i+(yy*2+j)*80]=data;
//        }
//    }
//}
//void    vram_set_8_dot5(unsigned int xx,unsigned int yy)
//{
//    unsigned char   data;
//    unsigned int    i,j;
    
//    for(j=0;j<8;j++){
//        for(i=0;i<4;i++){
//            data=font_suji_8_dot5[j*4+i];
//            vram[xx+i+(yy*2+j)*80]=data;
//        }
//    }
//}
void    vram_set_pr(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset,offsety;

    offset=0;
    offsety=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_p1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_r1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    offsety=offsety+8;
    vram_set_8_dot1(xx+offset,yy+offsety);
}
void    vram_set_ma(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset,offsety;

    offset=0;
    offsety=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_m2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_a2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    } 
    offset=offset+12;
    offsety=offsety+8;
    vram_set_8_dot2(xx+offset,yy+offsety);
}
void    vram_set_batt(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_b6[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_a6[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_t6[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_t6[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}
//void    vram_set_st(unsigned int xx,unsigned int yy)
//{
//    unsigned char   data;
//    unsigned int    i,j,k;
//    unsigned int    offset,offsety;

//    offset=0;
//    offsety=0;
//    for(k=0;k<3;k++){
//        for(j=0;j<24;j++){
//            for(i=0;i<4;i++){
//                data=font_moji_s3[k][j*4+i];
//                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
//                }
//            }
//    }
//    offset=offset+12;
//    for(k=0;k<3;k++){
//        for(j=0;j<24;j++){
//            for(i=0;i<4;i++){
//                data=font_moji_t3[k][j*4+i];
//                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
//                }
//            }
//    } 
//    offset=offset+12;
//    offsety=offsety+8;
//    vram_set_8_dot3(xx+offset,yy+offsety);
//}
//void    vram_set_mo(unsigned int xx,unsigned int yy)
//{
//    unsigned char   data;
//    unsigned int    i,j,k;
//    unsigned int    offset,offsety;

//    offset=0;
//    offsety=0;
//    for(k=0;k<3;k++){
//        for(j=0;j<24;j++){
//            for(i=0;i<4;i++){
//                data=font_moji_m4[k][j*4+i];
//                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
//                }
//            }
//    }
//    offset=offset+12;
//    for(k=0;k<3;k++){
//        for(j=0;j<24;j++){
//            for(i=0;i<4;i++){
//                data=font_moji_o4[k][j*4+i];
//                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
//                }
//            }
//    } 
//    offset=offset+12;
//    offsety=offsety+8;
//    vram_set_8_dot4(xx+offset,yy+offsety);
//}
void    vram_set_s(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_s5[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}
void    vram_set_b(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_b6[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}
void    vram_set_khz(unsigned  int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<4;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=font_moji_kh[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}
void    vram_set_par(unsigned  int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<4;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=font_moji_par[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}
void    vram_set_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 10:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_space[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 11:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_bar[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;            
    }
}
void    vram_set_suji_s(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 9:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
    }
}
void    pal_color_set(void)
{
    unsigned int i;
    
    for (i=0;i<16;i++){
        color_data1[i]=color_data1_init[pal_color[pal_no][i]];
        color_data2[i]=color_data2_init[pal_color[pal_no][i]];
    }
}
void	vram_set_suji_khz(unsigned int xx,unsigned int yy,unsigned int hz)
{
    unsigned char n0,n1,n2,n3;
    unsigned int count;
    
    count=hz;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);count=(count-n1)/10;
	n2=(unsigned char)(count%10);count=(count-n2)/10;
	n3=(unsigned char)(count%10);
	
    if(n3==0){
        vram_set_suji(xx,yy,10);
    }
    else{
        vram_set_suji(xx,yy,n3);
    }
    vram_set_suji(xx+16,yy,n2);
    vram_set_suji(xx+32,yy,n1);
    vram_set_suji(xx+48,yy,n0);
}
void    vram_set_s_meter(unsigned int xx,unsigned int yy,unsigned int ss)
{
    unsigned int    count;
    unsigned char   n0,n1;

    vram_set_s(xx,yy);
    
    count=ss;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);
    vram_set_suji_s(xx+12,yy+4,n1);
    vram_set_suji_s(xx+20,yy+4,n0);
};
void    vram_set_band_width(unsigned int xx,unsigned int yy)
{
    vram_set_b(xx,yy);
    
    switch(width){
        case 0:
            vram_set_suji_s(xx+12,yy+4,6);
            break;
        case 1:
            vram_set_suji_s(xx+12,yy+4,4);
            break;
        case 2:
            vram_set_suji_s(xx+12,yy+4,3);
            break;
        case 3:
            vram_set_suji_s(xx+12,yy+4,2);
            break;
        case 4:
            vram_set_suji_s(xx+12,yy+4,1);
            break;
    }                
};
void	vram_set_suji_par(unsigned int xx,unsigned int yy,unsigned int par)
{
    unsigned char n0,n1;
    unsigned int count;
    
    count=par;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);
	
    if(n1==0){
        vram_set_suji(xx,yy,10);
    }
    else{
        vram_set_suji(xx,yy,n1);
    }
    vram_set_suji(xx+16,yy,n0);
}
///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}

uint32_t    adc_read_an12(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN12, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}

unsigned int	vol_yomi(void)
{
unsigned short	sa;

	vol_level=adc_read_an13();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=5){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}
	vol_level=vol_level/FREQ_MANUAL_DIV;
	vol_level=vol_level*9+FREQ_MIN;

	return vol_level;
}
unsigned int	vol_yomi_cnt(void)
{
unsigned short	sa;

	vol_level=adc_read_an13();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=5){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}
	vol_level=vol_level/FREQ_MANUAL_DIV_CNT;
	
	return vol_level;
}

unsigned int	batt_yomi(void)
{

	batt_level=adc_read_an12();
    batt_level=(batt_level-620)/3;
    if(batt_level>=99){
        batt_level=99;
    }

	return batt_level;
}
//***************************************************************
//I2C
//***************************************************************
/*
void    eeprom_set_palet(void)
{
    unsigned char   wdata[5];
    
    wdata[0]=0x00;
    wdata[1]=0x50;
    wdata[2]=pal_no;
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);
}
*/

void	i2c_radio_write(unsigned char number_bytes,unsigned char *data)
{
    //unsigned char	i;

	//I2CStart();
	//I2CSend(i2c_radio_addr);
	//for(i=0;i<number_bytes;i++){
	//	I2CSend(*data);
	//	data++;
	//}
	//I2CStop();
    
    I2C1_Write(I2C_RADIO_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);  
}

void	i2c_radio_read(unsigned char number_bytes,unsigned char *data)
{
    //unsigned char	i;

	//I2CStart();
	//I2CSend(i2c_radio_addr | 0x01);
	//for(i=number_bytes;i>0;i--){
	//	*data=I2CRead();
	//	data++;
	//	if(i-1) I2CAck();else I2CNak();
	//}
	//I2CStop();
    
    I2C1_Read(I2C_RADIO_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);
}

//***************************************************************
//Si47xx
//***************************************************************
unsigned char si47xx_readStatus()
{
    unsigned char status;
   
 	i2c_radio_read(1,&status);
	delay_us(500);
    return status;
}

void si47xx_waitForCTS()
{
    unsigned int i=1000;

    while (--i && !(si47xx_readStatus() & CTS))
    {
		delay_us(500);
    }
}

void si47xx_command(unsigned char cmd_size, unsigned char *cmd, unsigned char reply_size, unsigned char *reply)
{
    si47xx_waitForCTS();
    i2c_radio_write(cmd_size, cmd);
	delay_us(500);
    si47xx_waitForCTS();
    if(reply_size)
    {
		i2c_radio_read(reply_size, reply);
		delay_us(500);
    }
}

unsigned char getIntStatus(void)
{
    unsigned char  cmd[1] = {0};
    unsigned char  rsp[1] = {0};

    cmd[0] = GET_INT_STATUS;
	si47xx_command(1, cmd, 1, rsp);
	return rsp[0];
}

void si47xx_set_property(unsigned int propNumber, unsigned int propValue)
{
    cmd[0] = SET_PROPERTY;
    cmd[1] = 0;
    cmd[2] = (unsigned char)(propNumber >> 8);
	cmd[3] = (unsigned char)(propNumber & 0x00FF);
    cmd[4] = (unsigned char)(propValue >> 8);
    cmd[5] = (unsigned char)(propValue & 0x00FF);
	si47xx_command(6, cmd, 0,  0);
}

void si47xx_getPartInformation(void)
{

	cmd[0] = GET_REV;

	si47xx_command(1, cmd, 9, rsp);

	partNumber = rsp[1];
	fwMajor  = (char)rsp[2];
	fwMinor  = (char)rsp[3];
	patchID  = (unsigned int)(rsp[4] << 8) | (unsigned int)rsp[5];
	cmpMajor = (char)rsp[6];
	cmpMinor = (char)rsp[7];
	chipRev  = (char)rsp[8]; 
	
}

//void si47xxFMRX_initialize(void)
//{
//	Bit.PoweredUp = 0;
    //RSTB = 0;
//    GPIO_PinWrite(RSTB,0);
//	delay_us(100);
    //RSTB = 1;
//    GPIO_PinWrite(RSTB,1);
//	delay_us(30);
//    if (Bit.PoweredUp) {
//    } else {
//		cmd[0] = POWER_UP;
//        cmd[1] = (POWER_UP_IN_FUNC_FMRX | 0x10) ;
//        cmd[2] = POWER_UP_IN_OPMODE_RX_ANALOG;
//		si47xx_command(3, cmd, 8, rsp);
//		delay_ms(POWERUP_TIME);
//		Bit.PoweredUp = 1;
//    }
//   	si47xx_set_property(GPO_IEN, GPO_IEN_STCIEN_MASK);/* chack */
//	si47xx_set_property(FM_RDS_CONFIG, 0);              
//	si47xx_set_property(FM_DEEMPHASIS, FM_DEEMPH_50US);
//}
void si47xxAMSWLWRX_initialize(void)
{
	Bit.PoweredUp = 0;
    //RSTB = 0;
    GPIO_PinWrite(RSTB,0);
	delay_us(100);
    //RSTB = 1;
    GPIO_PinWrite(RSTB,1);
	delay_us(30);
    if (Bit.PoweredUp) {
    } else {
		cmd[0] = POWER_UP;
        cmd[1] = (POWER_UP_IN_FUNC_AMRX | 0x10) ;
        cmd[2] = POWER_UP_IN_OPMODE_RX_ANALOG;
		si47xx_command(3, cmd, 8, rsp);
		delay_ms(POWERUP_TIME);
		Bit.PoweredUp = 1;
    }
   	si47xx_set_property(GPO_IEN, GPO_IEN_STCIEN_MASK);/* chack */
	/*
    si47xx_set_property(AM_SEEK_TUNE_SNR_THRESHOLD, 5);
    si47xx_set_property(AM_SEEK_TUNE_RSSI_THRESHOLD, 25);
	*/
	/*
	si47xx_set_property(AM_SEEK_FREQ_SPACING, 9);     
	si47xx_set_property(AM_SEEK_BAND_TOP, 1620);        
	si47xx_set_property(AM_SEEK_BAND_BOTTOM, 522);
	*/
	si47xx_set_property(AM_CHANNEL_FILTER, AM_CHANNEL_FILTER_BW_4KHZ);
}
//static void fmTuneFreq(unsigned int frequency)
//{
//    cmd[0] = FM_TUNE_FREQ;
//    cmd[1] = 0;
//    cmd[2] = (unsigned char)(frequency >> 8);
//	cmd[3] = (unsigned char)(frequency & 0x00FF);
//    cmd[4] = (unsigned char)0;
//	si47xx_command(5, cmd, 1, rsp);
//}

static void amTuneFreq(u16 frequency)
{
    cmd[0] = AM_TUNE_FREQ;
    cmd[1] = 0;
    cmd[2] = (u8)(frequency >> 8);
	cmd[3] = (u8)(frequency & 0x00FF);
    cmd[4] = (u8)0;
	cmd[5] = (u8)0;
	si47xx_command(6, cmd, 1, rsp);
}
//static void fmTuneStatus(unsigned char cancel, unsigned char intack)
//{
//    cmd[0] = FM_TUNE_STATUS;

//	cmd[1] = 0;
//    if(cancel) cmd[1] |= FM_TUNE_STATUS_IN_CANCEL;
//	if(intack) cmd[1] |= FM_TUNE_STATUS_IN_INTACK;

//	si47xx_command(2, cmd, 8, rsp);

//   STC    = !!(rsp[0] & STCINT);
//    BLTF   = !!(rsp[1] & FM_TUNE_STATUS_OUT_BTLF);
//    AFCRL  = !!(rsp[1] & FM_TUNE_STATUS_OUT_AFCRL);
//    Valid  = !!(rsp[1] & FM_TUNE_STATUS_OUT_VALID);
//    Freq   = ((unsigned int)rsp[2] << 8) | (unsigned int)rsp[3];
//    RSSI   = rsp[4];
//    ASNR   = rsp[5];
//    AntCap = rsp[7];   
//}

static void amTuneStatus(u8 cancel, u8 intack)
{
    cmd[0] = AM_TUNE_STATUS;

	cmd[1] = 0;
    if(cancel) cmd[1] |= AM_TUNE_STATUS_IN_CANCEL;
	if(intack) cmd[1] |= AM_TUNE_STATUS_IN_INTACK;

	si47xx_command(2, cmd, 8, rsp);

    STC    = !!(rsp[0] & STCINT);
    BLTF   = !!(rsp[1] & AM_TUNE_STATUS_OUT_BTLF);
    AFCRL  = !!(rsp[1] & AM_TUNE_STATUS_OUT_AFCRL);
    Valid  = !!(rsp[1] & AM_TUNE_STATUS_OUT_VALID);
    Freq   = ((u16)rsp[2] << 8) | (u16)rsp[3];
    RSSI   = rsp[4];
    ASNR   = rsp[5];
    AntCap = ((u16)rsp[6] << 8) | (u16)rsp[7];   
}
//static void fmRsqStatus(void)
//{
//    cmd[0] = FM_RSQ_STATUS;

//	cmd[1] = 0;

//	si47xx_command(2, cmd, 8, rsp);

//    RSSI   = rsp[4];
//    ASNR   = rsp[5];
//}

static void amRsqStatus(void)
{
    cmd[0] = AM_RSQ_STATUS;

	cmd[1] = 1;

	si47xx_command(2, cmd, 8, rsp);

    RSSI   = rsp[4];
    ASNR   = rsp[5];
}
//void	tune_sub(unsigned int fm_mhz)
//{
//    fmTuneFreq(fm_mhz);
//    while (!(getIntStatus() & STCINT));
//    fmTuneStatus(0, 1);
//    if(RSSI>99){RSSI=99;}
//    if(ASNR>99){ASNR=99;}
//	if(RSSI>=MUTE_RSSI){
//    	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
//	}
//}
void	tune_sub(unsigned int am_khz)
{
    amTuneFreq(am_khz);
    while (!(getIntStatus() & STCINT));
    amTuneStatus(0, 1);
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (u16)VOLUME_SET_DATA & RX_VOLUME_MASK);
	}
}

void    tune_status(void)
{
    amRsqStatus();
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (unsigned int)VOLUME_SET_DATA & RX_VOLUME_MASK);
	}    
}

//void    st_mono_sub(unsigned int data)
//{
//    switch(data){
//        case 0:
//            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x0031);
//            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x001e);
//            break;
//        case 1:
//            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x007f);
//            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x007f);            
//            break;
//    }
//}

// *****************************************************************************

// *****************************************************************************
int main ( void )
{

    /* Initialize all modules */
    SYS_Initialize ( NULL );

    set_up();

    vram_clear(7);

    disp_main2();

    delay_ms(1000);    

    pal_no=1;
    pal_color_set();
    
    //adc_data=0;
    
    mode=1;
	khz_no=FREQ_MIN;
	cnt_khz=FREQ_MIN;
	vol_count=0;
	cnt_no=0;
	khz_no_m=FREQ_MAX;    
    width=2;    
    
    vram_clear(7);
    
    batt_yomi();
    vram_set_suji_par(16,14,batt_level);
    vram_set_par(48,22);
    vram_set_batt(16,0);
    disp_main2();
    delay_ms(1000);
    
    vram_clear(7);
    
    si47xxAMSWLWRX_initialize();
    si47xx_getPartInformation();
    si47xx_set_property(RX_HARD_MUTE, 0);
  	si47xx_set_property(RX_VOLUME, (unsigned int)VOLUME_SET_DATA & RX_VOLUME_MASK);   
    si47xx_set_property(AM_CHANNEL_FILTER, width);
    
    //delay_ms(1000);

    vram_set_suji_khz(0,14,khz_no);
    vram_set_khz(64,22);
    
    if (GPIO_PinRead(SW1)==0){
        mode=1;
        vram_set_ma(0,0); 
    }
    else{
        mode=0;
        vram_set_pr(0,0);
    }

	khz_no=vol_yomi();
	if(khz_no>FREQ_MAX){khz_no=FREQ_MAX;}    
    vram_set_suji_khz(0,14,khz_no);
    tune_sub(khz_no);
	////khz_no_m=khz_no;
    tune_status();
    vram_set_s_meter(52,0,RSSI);
    vram_set_band_width(30,0);
    disp_main2();
	
    //stm=0;    
    
    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        //SYS_Tasks ( );
        /* key scan 1 */
		if (GPIO_PinRead(SW1)==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if (GPIO_PinRead(SW2)==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/        
        
        
        vram_set_suji_khz(0,14,khz_no);
        //disp_main2();

        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/        
		if ((GPIO_PinRead(SW2)==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/ 
        
        /* key action */  
		if((sw1_key==0)&&(sw1_rep==0)){
			if(mode!=1){
                mode=1;
                vram_set_ma(0,0); 
                disp_main2();
            }
		}
		else{
            if(mode!=0){
                mode=0;
                vram_set_pr(0,0);
                disp_main2();
            }
    	}
        /*------------------*/
		if((sw2_key==0)&&(sw2_rep==0)){
            sw2_rep=1;
            switch(mode){
                case 0:
                    pal_no++;
                    if(pal_no>7){
                        pal_no=0;
                    }
                    pal_color_set();
                    disp_main2();
                    break;
                case 1:
                    width++;
                    if(width>=5){
                        width=0;
                    }
                    si47xx_set_property(AM_CHANNEL_FILTER, width);
                    vram_set_band_width(30,0);
                    disp_main2();
                    break;
            }
		}
        /*------------------*/
        
		//**************************
		if(mode==1){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				khz_no=vol_yomi();
				if(khz_no>FREQ_MAX){khz_no=FREQ_MAX;}				

				if(khz_no_m!=khz_no){
                    //stm=0;
                    //vram_set_st(48,0);

                    //st_mono_sub(stm);
					vram_set_suji_khz(0,14,khz_no);

					tune_sub(khz_no);
					khz_no_m=khz_no;
                    tune_status();
                    vram_set_s_meter(52,0,RSSI); 
                    disp_main2();
				}
                //tune_status();
                //vram_set_s_meter(52,0,RSSI); 
				vol_count=VOL_COUNT_SET;
                
			}
		}
		/*------------------ */
		if(mode==0){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				cnt_no=vol_yomi_cnt();
				if(cnt_no>12){cnt_no=12;}
				cnt_khz=preset[cnt_no];
				if(cnt_khz!=0){khz_no=cnt_khz;}
				if(khz_no>FREQ_MAX){khz_no=FREQ_MAX;}				
				if(khz_no_m!=khz_no){
                    //stm=stereo_mono[cnt_no];
                    //if(stm==0){
                        //vram_set_st(48,0);
                    //}
                    //else{
                        //vram_set_mo(48,0);
                    //}                    
                    //stm=1;
					vram_set_suji_khz(0,14,khz_no);
                    //st_mono_sub(stm);                    
					tune_sub(khz_no);
					khz_no_m=khz_no;
                    tune_status();
                    vram_set_s_meter(52,0,RSSI);
                    disp_main2();
				}
                //tune_status();
                //vram_set_s_meter(52,0,RSSI); 
				vol_count=VOL_COUNT_SET;
			}
        }
        /*------------------*/        
        /* Execution should not come here during normal operation */
    }
    //return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

