#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "pwm.h"
#include "eeprom.h"
#include "wait_time.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

//unsigned long	hz_no;
unsigned char	pwm_data;
unsigned char	power_flg;
unsigned char   on_init_count;

unsigned char   led_flg;
unsigned char   led_inv;
unsigned int    timer_count;
unsigned char   timer_flg;

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;
unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;
unsigned char	sw4_key;
unsigned char	sw4_rep;
unsigned char	sw4_cnt;

unsigned char   time0;
unsigned char   time1;
unsigned char   time2;
unsigned char   time3;

unsigned char   time_sec;
unsigned char   time_min;

unsigned char	sw1p;
unsigned char	sw2p;
unsigned char	sw3p;
unsigned char	sw4p;

unsigned char   suji[15]={0xFC,0x60,0xDA,0xF2,0x66,0xB6,0xBE,0xE4,0xFE,0xF6,0x00,0x00,0x00,0x00,0x00};


// Timer1 interrupt
void interrupt InterTimer( void )
{
    if (TMR1IF == 1) {
        timer_count++;
        if (timer_count >= 20) {
            timer_count = 0 ;
            timer_flg = 1;
        }
        TMR1L=TIMER1L_INIT;
        TMR1H=TIMER1H_INIT;
        TMR1IF=0;

     }
}

// Timer1 init
void    timer1_init(void)
{
    T1CON=0x00;
    TMR1L=TIMER1L_INIT;
    TMR1H=TIMER1H_INIT;
    TMR1IF=0;
    TMR1IE=1;
    PEIE=1;
    GIE=1;
    TMR1ON=1;
}


// MAIN
void	main(void)
{
	port_init();
    
    on_init_count=0;
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    }
    __delay_ms(1000);
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    }
    __delay_ms(1000);
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    }
    __delay_ms(1000);    
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    }
    __delay_ms(1000);    
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    }
    __delay_ms(1000);    
    sw1p=RC0;NOP();
    if(sw1p==0){
        on_init_count++;
    } 
       
	pwm_data=PWM_DATA_MIN;
    power_flg=0;
    led_flg=0;
    led_inv=0;
    
    timer_count=0;
    timer_flg=0;
    
    if(on_init_count==6){
        eeprom_init();
    }
    else{
        eeprom_check();
    }
    
    time0=0;
    time_sec=0;

    
 	start_pwm1();
	set_pwm1(pwm_data);
    
    timer1_init();
 
	__delay_ms(200);
    
	sw1_key=0;sw1_rep=0;sw1_cnt=0;
	sw2_key=0;sw2_rep=0;sw2_cnt=0;
 	sw3_key=0;sw3_rep=0;sw3_cnt=0;
	sw4_key=0;sw4_rep=0;sw4_cnt=0;    
	    
    COM0=0;
    COM1=0;
    COM2=0;
    COM3=0;

    __delay_ms(1000);
    
	while(1){
        
		sw1p=RC0;NOP();
        sw2p=RA0;NOP();
        sw3p=RA1;NOP();
        sw4p=RA2;NOP();
        
        // key scan 1
		if (sw1p==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
        
		if (sw2p==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}

		if (sw3p==0){
				sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}

		if (sw4p==0){
				sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
        
		//********************

		//********************
        
		wait_time(800);

		sw1p=RC0;NOP();
        sw2p=RA0;NOP();
        sw3p=RA1;NOP();
        sw4p=RA2;NOP();
        
        // key scan 2
		if ((sw1p==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}

		if ((sw2p==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}

		if ((sw3p==0)&&(sw3_key==0)){
			sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}

 		if ((sw4p==0)&&(sw4_key==0)){
			sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
        
		//*******************

		//*******************

        // key action
	
		if((sw1_key==0)&&(sw1_rep==0)){
			sw1_rep=1;
            switch(power_flg){
                case 0: led_flg=1;
                        power_flg=1;
                        pwm_data=PWM_DATA_MAX;
                        set_pwm1(pwm_data);
                        eeprom_write_direct();                        
                        break;
                case 1: led_flg=0;
                        power_flg=0;
                        pwm_data=PWM_DATA_MIN;
                        set_pwm1(pwm_data);
                        eeprom_write_direct();
                        break;
              
            }

		}
		/*------------------*/
		if((sw1_key==0)&&(sw1_rep==1)){
			sw1_cnt++;
			if(sw1_cnt>=KEY_LONG_UD){

                
                sw1_cnt=0;
            }

		}
		/*------------------*/
		if((sw2_key==0)&&(sw2_rep==0)){
			sw2_rep=1;
		}
		/*------------------*/
		if((sw2_key==0)&&(sw2_rep==1)){
			if(power_flg==0){
                sw2_cnt++;
                if(sw2_cnt>=KEY_LONG_UD){
                    time1++;
                    if(time1>=10){
                        time1=0;
                    }
                    sw2_cnt=0;
                }
            }
		}
		/*------------------*/
		if((sw3_key==0)&&(sw3_rep==0)){
			sw3_rep=1;
		}
		/*------------------*/
		if((sw3_key==0)&&(sw3_rep==1)){
			if(power_flg==0){
                sw3_cnt++;
                if(sw3_cnt>=KEY_LONG_UD){
                    time2++;
                    if(time2>=10){
                        time2=0;
                    }
                    sw3_cnt=0;
                }
            }
		}        
		/*------------------*/
		if((sw4_key==0)&&(sw4_rep==0)){
			sw4_rep=1;
		}
		/*------------------*/
		if((sw4_key==0)&&(sw4_rep==1)){
			if(power_flg==0){
                sw4_cnt++;
                if(sw4_cnt>=KEY_LONG_UD){
                    time3++;
                    if(time3>=10){
                        time3=0;
                    }
                    sw4_cnt=0;
                }
            }
		}        
        
 		//*******************
        
        // Timer action
        if((power_flg==1) && (timer_flg==1)){
            timer_flg=0;
            if(led_flg==1){
                switch(led_inv){
                    case 0:
                        led_inv=1;
                        pwm_data=PWM_DATA_MAX;
                        set_pwm1(pwm_data);
                        break;
                    case 1:
                        led_inv=0;
                        pwm_data=PWM_DATA_MID;
                        set_pwm1(pwm_data);  
                        break;
                }
            }
            time_sec++;
            if(time_sec>=60){
                time_sec=0;
                time_min++;
                if(time_min>=60){
                    time_min=0;
                    time1++;
                    if(time1>=10){
                        time1=0;
                        time2++;
                        if(time2>=10){
                            time2=0;
                            time3++;
                            if(time3>=10){
                                time3=0;
                            }
                        }
                    }
                }
                eeprom_write_direct();
            }
        }
 
        
		//*******************
        
        // Time Display
        
        PORTB=suji[time3];
        NOP();
        COM3=1;
        wait_time(LED_7SEG_WAIT);
        COM3=0;
        PORTB=suji[time2];
        NOP();
        COM2=1;
        wait_time(LED_7SEG_WAIT);
        COM2=0;
        PORTB=suji[time1] | 0x01;
        NOP();
        COM1=1;
        wait_time(LED_7SEG_WAIT);
        COM1=0;
        time0=time_min/10;
        PORTB=suji[time0];
        NOP();
        COM0=1;
        wait_time(LED_7SEG_WAIT);
        COM0=0;        

	}

}