#include <htc.h>
#include "user_define.h"

extern  unsigned char   time1;
extern  unsigned char   time2;
extern  unsigned char   time3;
extern  unsigned char   time_min;

/*----------EEPROM----------*/
unsigned char E2promRead(unsigned char adr)
{
	EEADR=adr;
	RD=1;
	return(EEDATA);
}

void E2promWrite(unsigned char adr,unsigned char data)
{
	EEADR=adr;
	EEDATA=data;
	
	WREN=1;
	EECON2=0x55;
	EECON2=0xaa;
	
	WR=1;
	while(EEIF==0)
	{
		NOP();
	}
	EEIF=0;
	WREN=0;
}

void    eeprom_init(void)
{
 	E2promWrite(0x00,0xa5);   
    E2promWrite(0x10,0x00);      
    E2promWrite(0x11,0x00);
    E2promWrite(0x12,0x00);    
    E2promWrite(0x13,0x00);
    
    time_min=0;
    time1=0;
    time2=0;
    time3=0;
}

void	eeprom_check(void)
{
	if(E2promRead(0x00)==0xa5){
		time_min=E2promRead(0x10);
        time1=E2promRead(0x11);
        time2=E2promRead(0x12);
        time3=E2promRead(0x13);
	}
	else{
		eeprom_init();
	}
}

void	eeprom_write_direct(void)
{
		E2promWrite(0x10,time_min);
		E2promWrite(0x11,time1);
		E2promWrite(0x12,time2);
		E2promWrite(0x13,time3);
}