/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define     LCD_RST     GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS      GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR      GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC      GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD      GPIO_PIN_RB2      //RB2 //2

#define     SW1         GPIO_PIN_RB15
//#define     SW2         GPIO_PIN_RE4
//#define     SW3         GPIO_PIN_RF1
//#define     SW4         GPIO_PIN_RF0
#define     RSTB         GPIO_PIN_RC14


//#define     I2C_EEPROM  0x50
//#define     I2C_RADIO_ADDR  0x22
#define     I2C_RADIO_ADDR  0x11

#define     SENSOR_LEVEL            500
#define     SENSOR_COUNT_LOOP       20


//#define     KEY_NEXT_COUNT_INIT 10
#define     TIME_DOWN_INIT  150
#define     NEXT_COUNT_INIT 40

#define		FREQ_MIN				7700
#define		FREQ_MAX				9500
#define		MUTE_RSSI				30

#define		VOL_COUNT_SET			10
#define		RQST_RSSI_INIT			500
#define 	FREQ_MANUAL_DIV			6
#define		FREQ_MANUAL_DIV_CNT		80
/*
//==================================================================
// General Commands
//==================================================================
*/

/* STATUS bits - Used by all methods */
#define STCINT  0x01
#define ASQINT  0x02
#define RDSINT  0x04
#define RSQINT  0x08
#define ERR     0x40
#define CTS     0x80

/* POWER_UP*/
#define POWER_UP                      0x01
#define POWER_UP_IN_FUNC_FMRX         0x00
/*
#define POWER_UP_IN_FUNC_AMRX         0x01
#define POWER_UP_IN_FUNC_FMTX         0x02
#define POWER_UP_IN_FUNC_WBRX         0x03
#define POWER_UP_IN_FUNC_QUERY        0x0F
#define POWER_UP_IN_PATCH             0x20
#define POWER_UP_IN_GPO2OEN           0x40
#define POWER_UP_IN_CTSIEN            0x80
*/
#define POWER_UP_IN_OPMODE_RX_ANALOG  0x05
/*
#define POWER_UP_IN_OPMODE_TX_ANALOG  0x50
*/
#define POWER_UP_IN_XOSCEN			  0x10

/* GET_REV */
#define GET_REV 0x10

/* POWER_DOWN */
#define POWER_DOWN 0x11

/* SET_PROPERTY */
#define SET_PROPERTY 0x12

/* GET_PROPERTY */
#define GET_PROPERTY 0x13

/* GET_INT_STATUS */
#define GET_INT_STATUS 0x14

/*
//==================================================================
// FM Receive Commands
//==================================================================
*/
/*// FM_TUNE_FREQ*/
#define FM_TUNE_FREQ 0x20

/*// FM_TUNE_STATUS*/
#define FM_TUNE_STATUS           0x22
#define FM_TUNE_STATUS_IN_INTACK 0x01
#define FM_TUNE_STATUS_IN_CANCEL 0x02
#define FM_TUNE_STATUS_OUT_VALID 0x01
#define FM_TUNE_STATUS_OUT_AFCRL 0x02
#define FM_TUNE_STATUS_OUT_BTLF  0x80

/*// FM_RSQ_STATUS*/
#define FM_RSQ_STATUS              0x23
#define FM_RSQ_STATUS_IN_INTACK    0x01
#define FM_RSQ_STATUS_OUT_RSSILINT 0x01
#define FM_RSQ_STATUS_OUT_RSSIHINT 0x02
#define FM_RSQ_STATUS_OUT_ASNRLINT 0x04
#define FM_RSQ_STATUS_OUT_ASNRHINT 0x08
#define FM_RSQ_STATUS_OUT_BLENDINT 0x80
#define FM_RSQ_STATUS_OUT_VALID    0x01
#define FM_RSQ_STATUS_OUT_AFCRL    0x02
#define FM_RSQ_STATUS_OUT_SMUTE    0x08
#define FM_RSQ_STATUS_OUT_PILOT    0x80
#define FM_RSQ_STATUS_OUT_STBLEND  0x7F

/*
//==================================================================
// FM Receive Properties
//==================================================================
*/
/*// FM_DEEMPHASIS*/
#define FM_DEEMPHASIS      0x1100
#define FM_DEEMPHASIS_MASK 0x0003
#define FM_DEEMPHASIS_SHFT 0

/*// FM_CHANNEL_FILTER*/
#define FM_CHANNEL_FILTER				0x1102
#define FM_CHANNEL_FILTER_WIDE			0x0001
#define FM_CHANNEL_FILTER_NARROW		0x0002
#define FM_CHANNEL_FILTER_NARROWER		0x0003
#define FM_CHANNEL_FILTER_NARROWEST		0x0004

/*// FM_BLEND_STEREO_THRESHOLD*/
//#define FM_BLEND_STEREO_THRESHOLD      0x1105
#define FM_BLEND_STEREO_THRESHOLD      0x1800   //20220418
#define FM_BLEND_STEREO_THRESHOLD_MASK 0x007F
#define FM_BLEND_STEREO_THRESHOLD_SHFT 0

/*// FM_BLEND_MONO_THRESHOLD*/
//#define FM_BLEND_MONO_THRESHOLD      0x1106
#define FM_BLEND_MONO_THRESHOLD      0x1801 //20220418
#define FM_BLEND_MONO_THRESHOLD_MASK 0x007F
#define FM_BLEND_MONO_THRESHOLD_SHFT 0


/*// FM_MAX_TUNE_ERROR*/
#define FM_MAX_TUNE_ERROR      0x1108
#define FM_MAX_TUNE_ERROR_MASK 0x007F
#define FM_MAX_TUNE_ERROR_SHFT 0

/*// FM_RSQ_INT_SOURCE*/
#define FM_RSQ_INT_SOURCE               0x1200
#define FM_RSQ_INT_SOURCE_RSSILIEN_MASK 0x0001
#define FM_RSQ_INT_SOURCE_RSSIHIEN_MASK 0x0002
#define FM_RSQ_INT_SOURCE_ASNRLIEN_MASK 0x0004
#define FM_RSQ_INT_SOURCE_ASNRHIEN_MASK 0x0008
#define FM_RSQ_INT_SOURCE_BLENDIEN_MASK 0x0080
#define FM_RSQ_INT_SOURCE_RSSILIEN_SHFT 0
#define FM_RSQ_INT_SOURCE_RSSIHIEN_SHFT 1
#define FM_RSQ_INT_SOURCE_ASNRLIEN_SHFT 2
#define FM_RSQ_INT_SOURCE_ASNRHIEN_SHFT 3
#define FM_RSQ_INT_SOURCE_BLENDIEN_SHFT 7

/*// FM_RSQ_SNR_HI_THRESHOLD*/
#define FM_RSQ_SNR_HI_THRESHOLD      0x1201
#define FM_RSQ_SNR_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_SNR_LO_THRESHOLD*/
#define FM_RSQ_SNR_LO_THRESHOLD      0x1202
#define FM_RSQ_SNR_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_HI_THRESHOLD*/
#define FM_RSQ_RSSI_HI_THRESHOLD      0x1203
#define FM_RSQ_RSSI_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_LO_THRESHOLD*/
#define FM_RSQ_RSSI_LO_THRESHOLD      0x1204
#define FM_RSQ_RSSI_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_BLEND_THRESHOLD*/
#define FM_RSQ_BLEND_THRESHOLD            0x1207
#define FM_RSQ_BLEND_THRESHOLD_BLEND_MASK 0x007F
#define FM_RSQ_BLEND_THRESHOLD_PILOT_MASK 0x0080
#define FM_RSQ_BLEND_THRESHOLD_BLEND_SHFT 0
#define FM_RSQ_BLEND_THRESHOLD_PILOT_SHFT 7

/*// FM_SOFT_MUTE_RATE*/
#define FM_SOFT_MUTE_RATE      0x1300
#define FM_SOFT_MUTE_RATE_MASK 0x00FF
#define FM_SOFT_MUTE_RATE_SHFT 0

/*// FM_SOFT_MUTE_MAX_ATTENUATION*/
#define FM_SOFT_MUTE_MAX_ATTENUATION      0x1302
#define FM_SOFT_MUTE_MAX_ATTENUATION_MASK 0x001F
#define FM_SOFT_MUTE_MAX_ATTENUATION_SHFT 0

/*// FM_SOFT_MUTE_SNR_THRESHOLD*/
#define FM_SOFT_MUTE_SNR_THRESHOLD      0x1303
#define FM_SOFT_MUTE_SNR_THRESHOLD_MASK 0x000F
#define FM_SOFT_MUTE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_BAND_BOTTOM*/
#define FM_SEEK_BAND_BOTTOM 0x1400

/*// FM_SEEK_BAND_TOP*/
#define FM_SEEK_BAND_TOP 0x1401

/*// FM_SEEK_FREQ_SPACING*/
#define FM_SEEK_FREQ_SPACING      0x1402
#define FM_SEEK_FREQ_SPACING_MASK 0x001F
#define FM_SEEK_FREQ_SPACING_SHFT 0

/*// FM_SEEK_TUNE_SNR_THRESHOLD*/
#define FM_SEEK_TUNE_SNR_THRESHOLD      0x1403
#define FM_SEEK_TUNE_SNR_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_TUNE_RSSI_THRESHOLD*/
#define FM_SEEK_TUNE_RSSI_THRESHOLD      0x1404
#define FM_SEEK_TUNE_RSSI_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_RSSI_THRESHOLD_SHFT 0

/*// FM_RDS_CONFIG*/
#define FM_RDS_CONFIG             0x1502
#define FM_RDS_CONFIG_RDSEN_MASK  0x0001
#define FM_RDS_CONFIG_BLETHD_MASK 0x0300
#define FM_RDS_CONFIG_BLETHC_MASK 0x0C00
#define FM_RDS_CONFIG_BLETHB_MASK 0x3000
#define FM_RDS_CONFIG_BLETHA_MASK 0xC000
#define FM_RDS_CONFIG_RDSEN_SHFT  0
#define FM_RDS_CONFIG_BLETHD_SHFT 8
#define FM_RDS_CONFIG_BLETHC_SHFT 10
#define FM_RDS_CONFIG_BLETHB_SHFT 12
#define FM_RDS_CONFIG_BLETHA_SHFT 14

/*
//==================================================================
// General Receive Properties
//==================================================================
*/
/* RX_VOLUME */
#define RX_VOLUME      0x4000
#define RX_VOLUME_MASK 0x003F
#define RX_VOLUME_SHFT 0

/* RX_HARD_MUTE */
#define RX_HARD_MUTE 0x4001
#define RX_HARD_MUTE_RMUTE_MASK 0x0001
#define RX_HARD_MUTE_LMUTE_MASK 0x0002
#define RX_HARD_MUTE_RMUTE_SHFT 0
#define RX_HARD_MUTE_LMUTE_SHFT 1
/*
//==================================================================
// Bit Definitions for Properties
//==================================================================
*/
/*// FM_DEEMPH*/
#define FM_DEEMPH_75US 0x2
#define FM_DEEMPH_50US 0x1


/*
//-----------------------------------------------------------------------------
// Defines
//-----------------------------------------------------------------------------
*/
#define READ    1
#define WRITE   0

#define POWERUP_TIME 110    /* Powerup delay in milliseconds*/
#define GPO_IEN				 0x0001
#define GPO_IEN_STCIEN_MASK  0x0001


//#define     VGA_FLG         1       //VGA=1,LCD=0

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************

//unsigned char   i2c_data;

struct {
	unsigned int PoweredUp : 1;
}Bit;

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;
unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;
unsigned char	sw4_key;
unsigned char	sw4_rep;
unsigned char	sw4_cnt;

unsigned char   pal_no;



unsigned char   cmd[8];
unsigned char   rsp[15];
unsigned char   RSSI;
unsigned char   STC;
unsigned char   BLTF;
unsigned char   AFCRL;
unsigned char   Valid;
unsigned int    Freq;
unsigned char   ASNR;
unsigned int    AntCap;

unsigned char   partNumber;
char 			fwMajor;
char 			fwMinor;
unsigned int    patchID;
char			cmpMajor;
char			cmpMinor;
char			chipRev;

unsigned int	mhz_no;
unsigned int	mhz_no_m;
unsigned char	mode;

unsigned int	preset[12]={7790,8020,8490,8640,8720,9360,7790,8020,8490,8640,8720,9360};
unsigned int    stereo_mono[12]={0,0,0,0,0,0,1,1,1,1,1,1};
unsigned int    stm;

unsigned int	cnt_no;
unsigned int	cnt_mhz;

unsigned char	tun_flg;

unsigned int	vol_count;


uint32_t        adc_data;
unsigned short	vol_level;
unsigned short	vol_level_m;


unsigned char   vram_r[8192];

unsigned char color_data1_init[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2_init[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char   pal_color[8][16]={
    {0,1,2,3,4,5,6,7,8,9,10,11,1,13,14,15},     //0
    {0,1,2,8,4,5,6,0,8,7,10,1,12,13,14,4},      //1
    {0,1,2,9,4,5,6,8,8,3,10,12,1,13,14,0},      //2
    {0,1,2,8,4,5,6,0,8,4,10,1,12,13,14,6},      //3
    {0,1,2,3,4,5,6,10,8,12,10,9,12,13,14,15},   //4
    {0,1,2,9,4,5,6,4,8,13,10,1,12,13,14,0},     //5
    {0,1,2,3,4,5,6,7,8,9,10,11,1,13,14,15},     //6
    {0,1,2,3,4,5,6,7,8,9,10,11,1,13,14,15},     //7
};
const unsigned char font_suji_dai_0_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,151,153,153,119,119,153,153,119,119,151,153,119,119,119,153,119,119,119,151,119,119,119,119},
{119,119,119,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,151,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,151,153,121,119,151,153,121,119,151,153,153,119,153,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,121,119,119,119,119,119},
{119,119,119,119,119,119,119,119,153,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,121,119,119,153,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_1_data[3][128]={
{119,119,119,119,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,153,119,119,119,153,119,119,119,153,119,119,151,153,119,119,151,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,153,119,119,119,153,119,119,119,153,119,119,119,153,119,119,119,153,119,119,119,153,119,119,151,153,119,119,151,153,119,119,151,153,119,119,151,153,119,119,119,119},
{119,119,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,119,119,119,119},
{119,119,119,119,153,119,119,119,153,119,119,119,153,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_2_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,119,151,153,119,119,153,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,151,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,151,153,153,119,153,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,119,119,119},
{119,119,119,119,119,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,153,153,119,119,153,153,119,119,153,119,119,119,153,119,119,151,153,119,119,153,153,119,151,153,153,119,153,153,153,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,119,119,119},
{119,119,119,119,119,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,119,153,121,119,119,153,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,153,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_3_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,153,119,119,151,153,119,119,151,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,151,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,153,153,153,151,153,153,153,151,153,153,153,119,153,153,153,119,153,153,153,119,151,153,153,119,151,153,153,119,119,153,153,119,119,119,153,119,119,119,119,119,119,119,119},
{119,119,119,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,153,153,121,119,153,153,119,119,153,119,119,119,153,119,119,151,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,119,153,153,119,119,151,153,119,119,151,153,121,119,151,153,121,119,151,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,119,119,119,119},
{119,119,119,119,121,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,119,153,121,119,119,121,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_4_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,119,153,119,119,151,153,119,119,153,153,119,119,153,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,151,153,119,119,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,153,153,153,151,153,153,153,151,153,153,121,151,153,153,121,151,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,151,153,121,119,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,151,153,153,119,119,119,119},
{119,119,119,119,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,153,119,153,153,119,119,153,153,119,119,153,121,119,119,153,121,119,119,153,121,119,119,153,121,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_5_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,151,119,119,119,153,119,119,119,153,119,119,119,153,119,119,119,153,119,119,151,153,119,119,151,153,119,119,151,153,119,119,151,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,121,119,119,153,153,119,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,153,153,153,119,119,153,153,119,119,119,153,119,119,119,119},
{119,119,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,153,153,119,119,153,153,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,151,153,153,119,119,153,153,119,119,151,153,119,119,151,153,119,119,151,153,119,119,153,153,119,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,119,119,119,119},
{119,119,119,119,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,121,119,119,119,153,121,119,119,153,153,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,121,119,119,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_6_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,151,119,119,119,153,119,119,151,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,153,153,153,119,153,153,153,119,151,153,153,119,151,153,153,119,119,151,153,119,119,119,153,119,119,119,119,119,119,119,119},
{119,119,119,119,119,151,153,153,119,153,153,153,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,153,119,153,153,121,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,153,153,121,119,151,153,121,119,151,153,121,119,151,153,121,119,151,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,119,119,119,119},
{119,119,119,119,153,153,153,121,153,153,153,119,153,153,121,119,153,153,119,119,153,121,119,119,153,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,153,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_7_data[3][128]={
{119,119,119,119,119,119,153,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,151,119,119,119,153,119,119,119,153,119,119,151,153,119,119,151,153,119,119,153,153,119,119,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,119,119,119,119},
{119,119,119,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,119,153,153,119,119,153,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,121,119,119,153,119,119,119,119,119,119,119},
{119,119,119,119,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,153,119,119,153,121,119,119,153,121,119,119,153,119,119,119,153,119,119,119,121,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_8_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,119,151,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,153,153,119,119,151,153,119,119,119,153,119,119,151,153,119,151,153,153,119,153,153,153,119,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,151,153,153,153,119,153,153,153,119,151,153,153,119,119,153,153,119,119,151,153,119,119,119,151,119,119,119,119},
{119,119,119,119,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,153,153,121,119,151,153,121,119,151,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,151,153,121,119,151,153,121,119,151,153,121,119,151,153,153,119,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,119,119,119},
{119,119,119,119,121,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,119,119,153,119,119,119,153,121,119,119,153,153,119,119,153,153,121,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,121,119,153,153,119,119,153,121,119,119,153,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_9_data[3][128]={
{119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,119,153,153,119,151,153,153,119,151,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,151,153,153,119,151,153,153,119,119,153,153,119,119,151,153,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,119,119,119,153,119,119,151,153,119,119,153,153,119,151,153,153,119,153,153,153,151,153,153,153,119,119,119,119},
{119,119,119,119,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,119,153,153,119,119,151,153,119,119,151,153,119,119,151,153,121,119,153,153,121,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,119,151,153,153,119,153,153,153,151,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,121,153,153,153,119,153,153,121,119,153,153,119,119,119,119,119,119},
{119,119,119,119,121,119,119,119,153,121,119,119,153,153,119,119,153,153,119,119,153,153,121,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,121,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,121,119,153,153,121,119,153,153,119,119,153,153,119,119,153,121,119,119,153,119,119,119,153,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const unsigned char font_suji_dai_dot_data[2][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,151,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,153,153,153,119,151,153,153,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,121,119,119,119,119,119,119,119,119,119,119,119},
};

const unsigned char font_0_bar_data[64]=
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,23,17,17,113,23,17,17,113,23,17,17,113,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,};    

const unsigned char font_1_f_data[2][64]={
{17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,119,119,119,119,},
{17,17,17,113,17,17,17,113,17,17,17,113,119,119,119,119,119,119,119,119,119,119,119,119,17,17,113,119,17,17,113,119,17,17,113,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_1_m_data[2][64]={
{17,17,119,119,17,17,113,119,17,17,17,119,17,17,17,113,17,17,17,17,17,17,23,17,17,17,119,17,17,17,119,17,17,17,119,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,119,119,119,119,},
{119,23,17,113,119,17,17,113,23,17,17,113,17,17,17,113,17,17,17,113,17,23,17,113,113,23,17,113,113,23,17,113,113,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,119,119,119,},
};
const unsigned char font_1_t_data[2][64]={
{119,17,17,17,119,17,17,17,119,17,17,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,119,},
{17,17,17,119,17,17,17,119,17,17,17,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,17,119,119,119,119,119,119,119,},
};
const unsigned char font_1_u_data[2][64]={
{17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,17,17,17,17,17,17,23,17,17,17,119,119,119,119,},
{119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,17,17,17,113,17,17,17,113,17,17,17,119,119,119,119,119,},    
};
const unsigned char font_1_n_data[2][64]={
{17,17,119,119,17,17,119,119,17,17,113,119,17,17,17,119,17,17,17,113,17,17,17,17,17,17,23,17,17,17,119,17,17,17,119,23,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,119,119,119,119,},
{119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,23,17,113,113,23,17,113,17,23,17,113,17,17,17,113,17,17,17,113,23,17,17,113,119,17,17,113,119,23,17,113,119,23,17,113,119,23,17,113,119,119,119,119,},    
};
const unsigned char font_1_e_data[2][64]={
{17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,17,17,17,17,17,17,17,17,17,17,119,119,119,119,},
{17,17,17,113,17,17,17,113,17,17,17,113,119,119,119,119,119,119,119,119,119,119,119,119,17,17,113,119,17,17,113,119,17,17,113,119,119,119,119,119,119,119,119,119,119,119,119,119,17,17,17,113,17,17,17,113,17,17,17,113,119,119,119,119,},
};
const unsigned char font_1_r_data[2][64]={
{17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,17,17,17,17,17,17,17,17,17,17,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,17,17,119,119,119,119,119,119,},
{17,17,17,119,17,17,17,113,17,17,17,113,119,23,17,113,119,23,17,113,119,23,17,113,17,17,17,113,17,17,17,113,17,17,17,119,17,17,119,119,23,17,113,119,23,17,113,119,119,17,17,119,119,23,17,113,119,23,17,113,119,119,119,119,},
};

const unsigned char font_2_p_data[2][64]={
{51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,119,119,119,119,},
{51,51,51,119,51,51,51,115,51,51,51,115,119,55,51,115,119,55,51,115,119,55,51,115,51,51,51,115,51,51,51,115,51,51,51,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_2_r_data[2][64]={
{51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,51,51,119,119,119,119,119,119,},
{51,51,51,119,51,51,51,115,51,51,51,115,119,55,51,115,119,55,51,115,119,55,51,115,51,51,51,115,51,51,51,115,51,51,51,119,51,51,119,119,55,51,115,119,55,51,115,119,119,51,51,119,119,55,51,115,119,55,51,115,119,119,119,119,},
};
const unsigned char font_2_e_data[2][64]={
{51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,51,51,51,51,51,51,51,51,51,51,119,119,119,119,},
{51,51,51,115,51,51,51,115,51,51,51,115,119,119,119,119,119,119,119,119,119,119,119,119,51,51,115,119,51,51,115,119,51,51,115,119,119,119,119,119,119,119,119,119,119,119,119,119,51,51,51,115,51,51,51,115,51,51,51,115,119,119,119,119,},
};
const unsigned char font_2_s_data[2][64]={
{55,51,51,51,51,51,51,51,51,51,51,51,51,51,119,119,51,51,119,119,51,51,119,119,51,51,51,51,51,51,51,51,55,51,51,51,119,119,119,119,119,119,119,119,51,51,119,119,51,51,51,51,51,51,51,51,55,51,51,51,119,119,119,119,},
{51,51,51,119,51,51,51,115,51,51,51,115,119,55,51,115,119,119,119,119,119,119,119,119,51,51,51,119,51,51,51,115,51,51,51,115,119,55,51,115,119,55,51,115,119,55,51,115,51,51,51,115,51,51,51,115,51,51,51,119,119,119,119,119,},
};
const unsigned char font_2_t_data[2][64]={
{119,51,51,51,119,51,51,51,119,51,51,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,119,},
{51,51,51,119,51,51,51,119,51,51,51,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,51,119,119,119,119,119,119,119,},
};

const unsigned char font_3_m_data[2][64]={
{85,85,119,119,85,85,117,119,85,85,85,119,85,85,85,117,85,85,85,85,85,85,87,85,85,85,119,85,85,85,119,85,85,85,119,85,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,119,119,119,119,},
{119,87,85,117,119,85,85,117,87,85,85,117,85,85,85,117,85,85,85,117,85,87,85,117,117,87,85,117,117,87,85,117,117,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,119,119,119,},    
};
const unsigned char font_3_a_data[2][64]={
{87,85,85,85,85,85,85,85,85,85,85,85,85,85,119,119,85,85,119,119,85,85,119,119,85,85,85,85,85,85,85,85,85,85,85,85,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,119,119,119,119,},
{85,85,85,119,85,85,85,117,85,85,85,117,119,87,85,117,119,87,85,117,119,87,85,117,85,85,85,117,85,85,85,117,85,85,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,119,119,119,},
};
const unsigned char font_3_n_data[2][64]={
{85,85,119,119,85,85,119,119,85,85,117,119,85,85,85,119,85,85,85,117,85,85,85,85,85,85,87,85,85,85,119,85,85,85,119,87,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,119,119,119,119,},
{119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,117,87,85,117,85,87,85,117,85,85,85,117,85,85,85,117,87,85,85,117,119,85,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,119,119,119,},    
};
const unsigned char font_3_u_data[2][64]={
{85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,85,85,85,85,85,85,87,85,85,85,119,119,119,119,},
{119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,119,87,85,117,85,85,85,117,85,85,85,117,85,85,85,119,119,119,119,119,},    
};
const unsigned char font_3_l_data[2][64]={
{85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,119,119,85,85,85,85,85,85,85,85,85,85,85,85,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,85,85,85,117,85,85,85,117,85,85,85,117,119,119,119,119,},    
};

const unsigned char font_4_s_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,119,119,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,204,204,204,124,119,199,204,124,119,119,119,119,119,119,119,119,204,204,204,119,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_4_t_data[2][64]={
{119,204,204,204,119,204,204,204,119,204,204,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,119,},
{204,204,204,119,204,204,204,119,204,204,204,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,119,119,119,119,},
};
const unsigned char font_4_e_data[2][64]={
{204,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,204,204,119,119,119,119,},
{204,204,204,124,204,204,204,124,204,204,204,124,119,119,119,119,119,119,119,119,119,119,119,119,204,204,124,119,204,204,124,119,204,204,124,119,119,119,119,119,119,119,119,119,119,119,119,119,204,204,204,124,204,204,204,124,204,204,204,124,119,119,119,119,},
};
const unsigned char font_4_r_data[2][64]={
{204,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,119,119,119,119,},
{204,204,204,119,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,204,204,119,119,199,204,124,119,199,204,124,119,119,204,204,119,119,199,204,124,119,199,204,124,119,119,119,119,},
};
const unsigned char font_4_o_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};

const unsigned char font_5_m_data[2][64]={
{221,221,119,119,221,221,125,119,221,221,221,119,221,221,221,125,221,221,221,221,221,221,215,221,221,221,119,221,221,221,119,221,221,221,119,221,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,119,119,119,119,},
{119,215,221,125,119,221,221,125,215,221,221,125,221,221,221,125,221,221,221,125,221,215,221,125,125,215,221,125,125,215,221,125,125,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,119,119,119,},    
};
const unsigned char font_5_o_data[2][64]={
{215,221,221,221,221,221,221,221,221,221,221,221,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,221,221,221,221,221,221,215,221,221,221,119,119,119,119,},
{221,221,221,119,221,221,221,125,221,221,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,221,221,221,125,221,221,221,125,221,221,221,119,119,119,119,119,},
};
const unsigned char font_5_n_data[2][64]={
{221,221,119,119,221,221,119,119,221,221,125,119,221,221,221,119,221,221,221,125,221,221,221,221,221,221,215,221,221,221,119,221,221,221,119,215,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,221,221,119,119,119,119,119,119,},
{119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,215,221,125,125,215,221,125,221,215,221,125,221,221,221,125,221,221,221,125,215,221,221,125,119,221,221,125,119,215,221,125,119,215,221,125,119,215,221,125,119,119,119,119,},    
};
const unsigned char font_5_sp_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},    
};

const unsigned char font_6_m_data[2][64]={
{255,255,119,119,255,255,127,119,255,255,255,119,255,255,255,127,255,255,255,255,255,255,247,255,255,255,119,255,255,255,119,255,255,255,119,255,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,119,119,119,119,},
{119,247,255,127,119,255,255,127,247,255,255,127,255,255,255,127,255,255,255,127,255,247,255,127,127,247,255,127,127,247,255,127,127,247,255,127,119,247,255,127,119,247,255,127,119,247,255,127,119,247,255,127,119,247,255,127,119,247,255,127,119,119,119,119,},
};
const unsigned char font_7_hz_data[3][64]={
{255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,255,255,255,255,255,255,255,255,255,255,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,119,119,119,119,119,},
{255,255,119,119,255,255,119,119,255,255,119,119,255,255,247,255,255,255,247,255,255,255,247,255,255,255,119,119,255,255,119,119,255,255,119,119,255,255,119,247,255,255,119,255,255,255,247,255,255,255,247,255,255,255,247,255,255,255,247,255,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,255,255,255,127,255,255,255,127,255,255,255,127,119,255,255,119,247,255,127,119,255,255,119,119,255,127,119,119,255,119,119,119,127,119,119,119,255,255,255,127,255,255,255,127,255,255,255,127,119,119,119,119,},
};

const unsigned char font_8_s_data[2][64]={
{183,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,187,187,119,119,187,187,119,119,187,187,187,187,187,187,187,187,183,187,187,187,119,119,119,119,119,119,119,119,187,187,119,119,187,187,187,187,187,187,187,187,183,187,187,187,119,119,119,119,},
{187,187,187,119,187,187,187,123,187,187,187,123,119,183,187,123,119,119,119,119,119,119,119,119,187,187,187,119,187,187,187,123,187,187,187,123,119,183,187,123,119,183,187,123,119,183,187,123,187,187,187,123,187,187,187,123,187,187,187,119,119,119,119,119,},
};
const unsigned char font_8_br_0_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_1_data[2][64]={
{187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_2_data[2][64]={
{187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_3_data[2][64]={
{187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_4_data[2][64]={
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_5_data[2][64]={
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
{187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,187,119,119,119,119,119,119,119,},
};
const unsigned char font_8_br_6_data[2][64]={
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
{187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,187,187,119,119,119,119,119,119,},
};
const unsigned char font_8_br_7_data[2][64]={
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
{187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,187,187,187,119,119,119,119,119,},
};
const unsigned char font_8_br_8_data[2][64]={
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
{187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,119,119,119,119,},
};


// delay
#define CCLK			(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_ms(10);
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);

    send_cmd(0xc8);
    send_data(0xff);
    send_data(0x93);
    send_data(0x42);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x01,0x00,0x80);       //send_data_4(0x00,0x03,0x00,0x82);
    
    send_cmd(0x2b);
    send_data_4(0x00,0x02,0x00,0x81); 

    send_cmd(0x36);
    send_data(0x68);    //a8
    
    send_cmd(0xc0);
    send_data(0x0e);
    send_data(0x0e);

    send_cmd(0xc1);
    send_data(0x10);

    send_cmd(0xc5);
    send_data(0xfa);

    send_cmd(0x3a);
    send_data(0x55);

    send_cmd(0xb1);
    send_data(0x00);
    send_data(0x18);

    send_cmd(0xe0);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x21);
    send_data(0x02);
    send_data(0x11);
    send_data(0x07);
    send_data(0x3d);
    send_data(0x79);
    send_data(0x4b);
    send_data(0x07);
    send_data(0x0f);
    send_data(0x0c);
    send_data(0x1b);
    send_data(0x1f);
    send_data(0x0f);

    send_cmd(0xe1);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x20);
    send_data(0x04);
    send_data(0x0f);
    send_data(0x04);
    send_data(0x33);
    send_data(0x45);
    send_data(0x42);
    send_data(0x04);
    send_data(0x0c);
    send_data(0x0a);
    send_data(0x22);
    send_data(0x29);
    send_data(0x0f);

    send_cmd(0x11);
    delay_ms(130);

    send_cmd(0x29);
    delay_ms(100);
    
    GPIO_PinWrite(LCD_CS,1);
}


void    disp_main2(void)
{
    unsigned int    i;
    unsigned char   data1,data2;


            GPIO_PinWrite(LCD_CS,0);
            
            send_cmd(0x2a);
            send_data_4(0x00,0x01,0x00,0x80);       //send_data_4(0x00,0x03,0x00,0x82);
            send_cmd(0x2b);
            send_data_4(0x00,0x02,0x00,0x81);   
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
    
            for (i=0;i<8192;i++){
                data2=vram_r[i] >> 4;
                data1=vram_r[i] & 0x0f;
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
            }

            GPIO_PinWrite(LCD_CS,1);

}

void    vram_clear(unsigned char color)
{
    unsigned int i;
    unsigned char data;
    
    data=(color << 4) | color;
    
    for(i=0;i<8192;i++){
        vram_r[i]=data;
    }
}

void    vram_set_fm_tuner(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;
    
    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_f_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_m_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }   
    offset=offset+8;
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_0_bar_data[j*4+i];
                vram_r[xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    offset=offset+4;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_t_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_u_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_n_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_e_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_1_r_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
};

void    vram_set_preset(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_p_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_r_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_e_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_s_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }   
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_e_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }   
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_2_t_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }       
};

void    vram_set_manual(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_m_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_a_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_n_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_u_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_a_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_3_l_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }     
};

void    vram_set_stereo(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_s_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_t_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_e_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_r_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_e_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_4_o_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }     
};

void    vram_set_mono(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_m_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_o_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_n_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_o_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_sp_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    } 
    offset=offset+8;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_5_sp_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }     
};

void    vram_set_mhz(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_6_m_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }
    offset=offset+8;
    for(k=0;k<3;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_7_hz_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }    
};
void    vram_set_s_bar(unsigned int xx,unsigned int yy,unsigned int no)
{
    unsigned char   data;
    unsigned long    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_0_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_1_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }  
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_2_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }    
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_3_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }   
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_4_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }   
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_5_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            } 
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_6_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            } 
            break;
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_7_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }   
            break;
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_8_br_8_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }  
            break;
    }
}
void    vram_set_s_meter(unsigned int xx,unsigned int yy,unsigned int ss)
{
    unsigned char   data;
    unsigned long    i,j,k;
    unsigned int    offset;
    unsigned int    n,n1,n2;

    offset=0;
    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=font_8_s_data[k][j*4+i];
                vram_r[k*4+xx+offset+i+(yy*2+j)*64]=data;
            }
        }
    }

    offset=offset+10;
    
    n=ss;
    n=n/2;
    if(n>=49){
        n=48;
    }
    n1=n%8;
    n2=n/8;
    switch(n2){
        case 0:
            vram_set_s_bar(xx+offset,yy,0);
            vram_set_s_bar(xx+offset+8,yy,0);
            vram_set_s_bar(xx+offset+16,yy,0);
            vram_set_s_bar(xx+offset+24,yy,0);
            vram_set_s_bar(xx+offset+32,yy,0);
            vram_set_s_bar(xx+offset+40,yy,0);
            break;
        case 1:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,0);
            vram_set_s_bar(xx+offset+16,yy,0);
            vram_set_s_bar(xx+offset+24,yy,0);
            vram_set_s_bar(xx+offset+32,yy,0);
            vram_set_s_bar(xx+offset+40,yy,0); 
            offset=offset+8;
            break;
        case 2:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,8);
            vram_set_s_bar(xx+offset+16,yy,0);
            vram_set_s_bar(xx+offset+24,yy,0);
            vram_set_s_bar(xx+offset+32,yy,0);
            vram_set_s_bar(xx+offset+40,yy,0); 
            offset=offset+16;            
            break;
        case 3:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,8);
            vram_set_s_bar(xx+offset+16,yy,8);
            vram_set_s_bar(xx+offset+24,yy,0);
            vram_set_s_bar(xx+offset+32,yy,0);
            vram_set_s_bar(xx+offset+40,yy,0);
            offset=offset+24;            
            break;
        case 4:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,8);
            vram_set_s_bar(xx+offset+16,yy,8);
            vram_set_s_bar(xx+offset+24,yy,8);
            vram_set_s_bar(xx+offset+32,yy,0);
            vram_set_s_bar(xx+offset+40,yy,0);
            offset=offset+32;            
            break;
        case 5:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,8);
            vram_set_s_bar(xx+offset+16,yy,8);
            vram_set_s_bar(xx+offset+24,yy,8);
            vram_set_s_bar(xx+offset+32,yy,8);
            vram_set_s_bar(xx+offset+40,yy,0);
            offset=offset+40;            
            break;
        case 6:
            vram_set_s_bar(xx+offset,yy,8);
            vram_set_s_bar(xx+offset+8,yy,8);
            vram_set_s_bar(xx+offset+16,yy,8);
            vram_set_s_bar(xx+offset+24,yy,8);
            vram_set_s_bar(xx+offset+32,yy,8);
            vram_set_s_bar(xx+offset+40,yy,8);            
            break;
    }
    if(n2<6){
        vram_set_s_bar(xx+offset,yy,n1);
    }
    
};

void    vram_set_suji_dai(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_0_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_1_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_2_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_3_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_4_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_5_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_6_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_7_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_8_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_dai_9_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
    }        
}

void	vram_set_suji_mhz(unsigned int xx,unsigned int yy,unsigned int hz)
{
    unsigned char n0,n1,n2,n3;
    unsigned int count;
    unsigned long    i,j,k;
    unsigned char   data;
    
    count=hz;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);count=(count-n1)/10;
	n2=(unsigned char)(count%10);count=(count-n2)/10;
	n3=(unsigned char)(count%10);
	
    vram_set_suji_dai(xx,yy,n3);
    vram_set_suji_dai(xx+12,yy,n2);
    
    for(k=0;k<2;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=font_suji_dai_dot_data[k][j*4+i];
                vram_r[k*4+xx+24+i+(yy*2+j)*64]=data;
            }
        }
    }

    vram_set_suji_dai(xx+30,yy,n1);
}


///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}

unsigned int	vol_yomi(void)
{
unsigned short	sa;

	vol_level=adc_read_an13();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=5){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}
	vol_level=vol_level/FREQ_MANUAL_DIV;
	vol_level=vol_level*10+FREQ_MIN;

	return vol_level;
}
unsigned int	vol_yomi_cnt(void)
{
unsigned short	sa;

	vol_level=adc_read_an13();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=5){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}
	vol_level=vol_level/FREQ_MANUAL_DIV_CNT;
	
	return vol_level;
}


// *****************************************************************************
void    pal_color_set(void)
{
    unsigned int i;
    
    for (i=0;i<16;i++){
        color_data1[i]=color_data1_init[pal_color[pal_no][i]];
        color_data2[i]=color_data2_init[pal_color[pal_no][i]];
    }
}



//***************************************************************
//I2C
//***************************************************************
/*
void    eeprom_set_palet(void)
{
    unsigned char   wdata[5];
    
    wdata[0]=0x00;
    wdata[1]=0x50;
    wdata[2]=pal_no;
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);
}
*/

void	i2c_radio_write(unsigned char number_bytes,unsigned char *data)
{
    //unsigned char	i;

	//I2CStart();
	//I2CSend(i2c_radio_addr);
	//for(i=0;i<number_bytes;i++){
	//	I2CSend(*data);
	//	data++;
	//}
	//I2CStop();
    
    I2C1_Write(I2C_RADIO_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);  
}

void	i2c_radio_read(unsigned char number_bytes,unsigned char *data)
{
    //unsigned char	i;

	//I2CStart();
	//I2CSend(i2c_radio_addr | 0x01);
	//for(i=number_bytes;i>0;i--){
	//	*data=I2CRead();
	//	data++;
	//	if(i-1) I2CAck();else I2CNak();
	//}
	//I2CStop();
    
    I2C1_Read(I2C_RADIO_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);
}


//***************************************************************
//Si47xx
//***************************************************************
unsigned char si47xx_readStatus()
{
    unsigned char status;
   
 	i2c_radio_read(1,&status);
	delay_us(500);
    return status;
}

void si47xx_waitForCTS()
{
    unsigned int i=1000;

    while (--i && !(si47xx_readStatus() & CTS))
    {
		delay_us(500);
    }
}

void si47xx_command(unsigned char cmd_size, unsigned char *cmd, unsigned char reply_size, unsigned char *reply)
{
    si47xx_waitForCTS();
    i2c_radio_write(cmd_size, cmd);
	delay_us(500);
    si47xx_waitForCTS();
    if(reply_size)
    {
		i2c_radio_read(reply_size, reply);
		delay_us(500);
    }
}

unsigned char getIntStatus(void)
{
    unsigned char  cmd[1] = {0};
    unsigned char  rsp[1] = {0};

    cmd[0] = GET_INT_STATUS;
	si47xx_command(1, cmd, 1, rsp);
	return rsp[0];
}

void si47xx_set_property(unsigned int propNumber, unsigned int propValue)
{
    cmd[0] = SET_PROPERTY;
    cmd[1] = 0;
    cmd[2] = (unsigned char)(propNumber >> 8);
	cmd[3] = (unsigned char)(propNumber & 0x00FF);
    cmd[4] = (unsigned char)(propValue >> 8);
    cmd[5] = (unsigned char)(propValue & 0x00FF);
	si47xx_command(6, cmd, 0,  0);
}

void si47xx_getPartInformation(void)
{

	cmd[0] = GET_REV;

	si47xx_command(1, cmd, 9, rsp);

	partNumber = rsp[1];
	fwMajor  = (char)rsp[2];
	fwMinor  = (char)rsp[3];
	patchID  = (unsigned int)(rsp[4] << 8) | (unsigned int)rsp[5];
	cmpMajor = (char)rsp[6];
	cmpMinor = (char)rsp[7];
	chipRev  = (char)rsp[8]; 
	
}

void si47xxFMRX_initialize(void)
{
	Bit.PoweredUp = 0;
    //RSTB = 0;
    GPIO_PinWrite(RSTB,0);
	delay_us(100);
    //RSTB = 1;
    GPIO_PinWrite(RSTB,1);
	delay_us(30);
    if (Bit.PoweredUp) {
    } else {
		cmd[0] = POWER_UP;
        cmd[1] = (POWER_UP_IN_FUNC_FMRX | 0x10) ;
        cmd[2] = POWER_UP_IN_OPMODE_RX_ANALOG;
		si47xx_command(3, cmd, 8, rsp);
		delay_ms(POWERUP_TIME);
		Bit.PoweredUp = 1;
    }
   	si47xx_set_property(GPO_IEN, GPO_IEN_STCIEN_MASK);/* chack */
	si47xx_set_property(FM_RDS_CONFIG, 0);              
	si47xx_set_property(FM_DEEMPHASIS, FM_DEEMPH_50US);
}

static void fmTuneFreq(unsigned int frequency)
{
    cmd[0] = FM_TUNE_FREQ;
    cmd[1] = 0;
    cmd[2] = (unsigned char)(frequency >> 8);
	cmd[3] = (unsigned char)(frequency & 0x00FF);
    cmd[4] = (unsigned char)0;
	si47xx_command(5, cmd, 1, rsp);
}

static void fmTuneStatus(unsigned char cancel, unsigned char intack)
{
    cmd[0] = FM_TUNE_STATUS;

	cmd[1] = 0;
    if(cancel) cmd[1] |= FM_TUNE_STATUS_IN_CANCEL;
	if(intack) cmd[1] |= FM_TUNE_STATUS_IN_INTACK;

	si47xx_command(2, cmd, 8, rsp);

    STC    = !!(rsp[0] & STCINT);
    BLTF   = !!(rsp[1] & FM_TUNE_STATUS_OUT_BTLF);
    AFCRL  = !!(rsp[1] & FM_TUNE_STATUS_OUT_AFCRL);
    Valid  = !!(rsp[1] & FM_TUNE_STATUS_OUT_VALID);
    Freq   = ((unsigned int)rsp[2] << 8) | (unsigned int)rsp[3];
    RSSI   = rsp[4];
    ASNR   = rsp[5];
    AntCap = rsp[7];   
}

static void fmRsqStatus(void)
{
    cmd[0] = FM_RSQ_STATUS;

	cmd[1] = 0;

	si47xx_command(2, cmd, 8, rsp);

    RSSI   = rsp[4];
    ASNR   = rsp[5];
}

void	tune_sub(unsigned int fm_mhz)
{
    fmTuneFreq(fm_mhz);
    while (!(getIntStatus() & STCINT));
    fmTuneStatus(0, 1);
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
	}
}

void    tune_status(void)
{
    fmRsqStatus();
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
	}    
}

void    st_mono_sub(unsigned int data)
{
    switch(data){
        case 0:
            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x0031);
            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x001e);
            break;
        case 1:
            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x007f);
            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x007f);            
            break;
    }
}

//////////////////////////////////////////////////////////////


// *****************************************************************************
int main ( void )
{
    
    /* Initialize all modules */
    SYS_Initialize ( NULL );

    GPIO_PinWrite(LCD_CS,1);
 
    set_up();
    
    vram_clear(0);

    disp_main2();


    delay_ms(1000);


    pal_no=3;
    
    adc_data=0;
    
    mode=1;
	mhz_no=FREQ_MIN;
	cnt_mhz=FREQ_MIN;
	vol_count=0;
	cnt_no=0;
	mhz_no_m=FREQ_MAX;    
    
    
    pal_color_set();
    
    
    vram_clear(7);

    
    si47xxFMRX_initialize();
    si47xx_getPartInformation();
    si47xx_set_property(RX_HARD_MUTE, 0);
  	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);   
    
    delay_ms(1000);
    
    vram_set_fm_tuner(2,2);             //TEST
    vram_set_suji_mhz(2,14,mhz_no);     //TEST
    vram_set_mhz(44,22);                //TEST
    
    if (GPIO_PinRead(SW1)==0){
        mode=1;
        vram_set_manual(14,34); 
    }
    else{
        mode=0;
        vram_set_preset(14,34);
    }
          
            
    disp_main2();


	mhz_no=vol_yomi();
	if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}
	
    stm=0;    
    
    
    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        //SYS_Tasks ( );
        /* key scan 1 */
		if (GPIO_PinRead(SW1)==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
      


        vram_set_suji_mhz(2,14,mhz_no);
        disp_main2();


        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
        
        
        /* key action */  
		if((sw1_key==0)&&(sw1_rep==0)){
			mode=1;
            vram_set_manual(14,34); 
		}
		else{
			mode=0;
            vram_set_preset(14,34);
    	}
        /*------------------*/
        
		//**************************
		if(mode==1){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				mhz_no=vol_yomi();
				if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}				

				if(mhz_no_m!=mhz_no){
                    stm=0;
                    vram_set_stereo(14,44);

                    st_mono_sub(stm);
					vram_set_suji_mhz(2,14,mhz_no);
                    
					tune_sub(mhz_no);
					mhz_no_m=mhz_no;
                    //vram_set_s_meter(2,54,RSSI);
				}
                tune_status();
                vram_set_s_meter(2,54,RSSI); 
				vol_count=VOL_COUNT_SET;
			}
		}
		/*------------------ */
		if(mode==0){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				cnt_no=vol_yomi_cnt();
				if(cnt_no>11){cnt_no=11;}
				cnt_mhz=preset[cnt_no];
				if(cnt_mhz!=0){mhz_no=cnt_mhz;}
				if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}				
				if(mhz_no_m!=mhz_no){
                    stm=stereo_mono[cnt_no];
                    if(stm==0){
                        vram_set_stereo(14,44);
                    }
                    else{
                        vram_set_mono(14,44);
                    }                    
                    //stm=1;
					vram_set_suji_mhz(2,14,mhz_no);
                    st_mono_sub(stm);                    
					tune_sub(mhz_no);
					mhz_no_m=mhz_no;
                    //vram_set_s_meter(2,54,RSSI);                    
				}
                tune_status();
                vram_set_s_meter(2,54,RSSI); 
				vol_count=VOL_COUNT_SET;
			}
        }
        
        /* Execution should not come here during normal operation */
    }
    //return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

