/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define     LCD_RST         GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS          GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR          GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC          GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD          GPIO_PIN_RB2      //RB2 //2

#define     MSGEQ7_STROBE   GPIO_PIN_RB10
#define     MSGEQ7_RESET    GPIO_PIN_RB11

#define     SW3             GPIO_PIN_RB12
#define     TEST            GPIO_PIN_RB15

#define     I2C_EEPROM      0x50

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
uint32_t        adc_data[14];
unsigned char   suji[4];
unsigned char   level_data[14];
unsigned char   font_no;

unsigned char   lcdmode;
unsigned char   vram1[84480];


unsigned char   color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,3};
unsigned char   color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;


const unsigned char font_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,17,0,0,1,17,16,0,1,17,16,0,1,17,16,1,0,17,0,1,0,17,0,1,0,0,0,1,0,0,0,9,0,0,0,153,0,0,153,153,0,9,153,153,0,9,153,153,0,153,153,153,0,153,153,153,9,153,153,153,9,153,153,153,9,153,151,119,9,153,119,119,7,119,119,119,7,119,119,119},
{0,0,0,0,0,1,16,0,0,17,17,0,1,17,17,16,17,17,17,17,17,25,145,17,17,25,145,17,17,153,153,17,17,148,73,17,25,148,73,145,25,148,73,145,153,148,73,153,153,148,73,153,153,148,73,153,153,148,73,153,153,153,153,153,153,153,153,153,153,153,153,153,151,119,119,121,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,17,0,0,1,17,16,0,1,17,16,16,1,17,16,16,0,17,0,16,0,17,0,16,0,0,0,144,0,0,0,153,0,0,0,153,153,0,0,153,153,144,0,153,153,144,0,153,153,153,0,153,153,153,0,153,153,153,144,153,153,153,144,119,121,153,144,119,119,153,144,119,119,119,112,119,119,119,112}
};
const unsigned char font_02_data[3][96]={
{0,0,0,0,0,0,0,8,0,0,0,136,0,0,136,136,0,8,136,136,0,8,136,136,0,136,136,136,8,136,136,68,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,78,8,136,132,78,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,68,8,136,132,78,8,136,132,78,8,136,132,68,8,136,68,68},
{0,0,0,0,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,132,68,68,65,68,68,68,17,68,68,65,17,68,68,65,17,68,68,65,17,68,68,65,17,238,68,65,102,102,228,65,102,99,228,65,17,238,68,65,17,68,68,65,17,68,68,65,17,68,68,65,102,68,68,65,102,238,68,65,17,102,228,65,17,99,228,72,17,238,68,72,129,68,68,68,136},
{0,0,0,0,136,128,0,0,136,136,0,0,136,136,128,0,136,136,128,0,17,17,16,0,17,17,17,0,22,49,17,16,19,49,17,16,22,97,17,16,22,97,17,16,22,97,17,16,22,97,17,16,22,49,17,16,19,49,17,16,22,97,17,16,22,97,17,16,22,97,17,16,22,97,17,16,22,49,17,16,19,49,17,16,17,17,17,128,17,17,24,128,136,136,136,64}    
};
const unsigned char font_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,17,0,0,0,17,0,0,1,17,0,0,1,27,0,0,17,27,0,0,17,187,0,0,17,187,0,0,17,191,0,1,17,187,0,1,27,187,0,17,27,187,0,17,187,187,0,17,187,191,1,17,187,187,1,27,191,187,1,187,187,187,11,187,187,187},
{0,0,0,0,255,255,255,255,255,255,255,255,244,68,68,79,68,79,244,68,68,79,244,68,255,68,68,255,255,255,255,255,17,255,255,17,17,17,17,17,177,17,17,27,187,187,187,187,187,191,187,187,187,187,187,191,187,187,191,187,191,187,187,187,187,187,187,187,251,191,187,187,187,187,187,251,187,187,187,187,187,251,187,187,187,187,187,191,251,187,251,187,187,187,187,187},
{0,0,0,0,0,0,0,0,240,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,17,0,0,0,17,0,0,0,17,16,0,0,177,16,0,0,177,17,0,0,187,17,0,0,187,17,0,0,187,17,0,0,187,17,16,0,251,177,16,0,187,177,17,0,187,187,17,0,191,187,17,0,187,187,17,16,187,187,177,16,187,251,187,16,187,187,187,176}    
};
const unsigned char font_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,221,0,0,13,221,0,0,13,210,0,0,221,210,0,0,221,34,0,0,221,34,0,0,221,34,0,0,221,34,0,0,221,34,0,0,221,34,0,0,221,34,0,0,221,34,0,221,221,34,13,221,210,34,13,210,34,34,13,210,46,226,13,210,236,206,13,210,236,206,13,210,46,226,13,210,34,34,13,210,34,34},
{0,0,0,0,221,221,221,221,221,221,221,221,210,34,34,45,34,45,221,34,34,34,45,210,34,34,34,221,34,46,226,34,34,228,78,34,34,228,78,34,34,46,226,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,46,226,34,34,228,78,34,34,228,78,34,34,46,226,34,34,34,34,34,34,34,34,34},
{0,0,0,0,0,0,0,0,208,0,0,0,221,0,0,0,221,208,0,0,45,208,0,0,45,221,0,0,34,221,0,0,210,221,0,0,210,221,0,0,34,221,0,0,34,221,0,0,34,221,0,0,34,221,0,0,34,221,0,0,34,221,221,0,34,45,221,208,34,34,45,208,46,226,45,208,236,206,45,208,236,206,45,208,46,226,45,208,34,34,45,208,34,34,45,208}    
};
const unsigned char font_05_data[3][96]={
{0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,119,126,231,0,119,238,238,7,126,231,126,7,119,119,119,7,119,119,119,7,119,115,55,3,55,51,51,3,51,51,51,3,51,51,51,8,136,136,51,8,136,136,131,8,136,136,136,8,136,136,136,8,24,136,136,15,248,136,136,15,255,136,136,8,136,136,129,8,136,136,255,8,136,143,255,8,136,136,136},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,126,231,119,119,238,238,119,238,231,126,238,238,119,119,238,119,119,119,119,119,115,55,119,119,51,51,119,51,51,51,51,51,51,51,51,51,136,136,51,56,136,136,131,136,136,136,136,136,136,136,136,136,136,136,136,136,136,24,136,136,143,248,136,136,255,255,136,136,136,136,136,248,136,136,143,136,136,136,136},
{0,0,0,0,119,119,0,0,119,119,112,0,119,119,112,0,126,231,119,0,238,238,119,0,231,126,231,112,119,119,119,112,119,119,119,112,115,55,119,112,51,51,115,48,51,51,51,48,51,51,51,48,51,136,136,128,56,136,136,128,136,136,136,128,136,136,136,128,136,136,136,16,136,136,143,240,136,136,255,240,129,136,136,128,255,136,136,128,255,248,136,128,136,136,136,128}
};
const unsigned char font_06_data[3][96]={
{0,0,0,0,0,0,0,221,0,13,221,221,0,221,221,221,0,221,221,221,13,221,212,68,13,221,68,65,13,212,68,29,13,212,65,221,13,212,65,221,13,212,68,19,13,212,68,65,13,212,68,68,13,221,212,68,0,221,221,212,0,221,221,221,0,13,221,221,0,0,13,221,0,0,13,221,0,0,13,221,0,0,13,221,0,0,13,221,0,0,13,221,0,0,13,221},
{0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,68,68,68,68,68,68,68,68,20,68,68,65,209,68,68,29,211,20,65,221,51,20,65,221,49,68,68,19,20,68,68,65,68,68,68,68,68,68,187,68,68,75,180,68,68,187,68,68,212,68,68,67,212,68,68,67,212,68,187,67,212,75,180,67,212,187,68,67,212,68,68,67,212,68,68,67,212,68,187,67},
{0,0,0,0,221,0,0,0,221,221,208,0,221,221,221,0,51,51,61,0,68,67,51,208,20,68,51,48,209,68,67,48,211,20,67,48,51,20,67,48,49,68,67,48,20,68,67,48,68,68,67,48,68,67,51,48,67,51,51,0,51,61,221,0,51,221,208,0,61,208,0,0,61,208,0,0,61,208,0,0,61,208,0,0,61,208,0,0,61,208,0,0,61,208,0,0}    
};
const unsigned char font_07_data[3][96]={
{0,0,0,0,0,136,0,0,8,136,128,0,8,136,128,0,0,136,0,0,0,0,0,1,15,0,0,17,15,240,1,17,15,240,1,17,15,255,17,17,15,47,17,17,15,47,17,17,0,255,17,17,0,15,17,17,0,0,17,17,0,0,1,17,0,0,1,17,0,0,0,17,0,0,0,1,0,136,0,0,8,136,128,0,8,136,128,15,0,136,0,255,0,0,0,0},
{0,0,0,0,0,0,255,255,0,15,34,255,0,255,255,240,1,17,17,16,17,17,17,17,17,21,85,17,17,85,85,81,17,119,119,85,23,119,119,117,119,127,243,119,119,255,51,119,119,243,51,119,119,51,55,119,23,119,119,117,17,119,119,85,17,85,85,81,17,21,85,17,17,17,17,17,1,17,17,16,15,255,255,0,255,34,240,0,255,255,0,0,0,0,0,0},
{0,0,0,0,255,0,136,0,240,8,136,128,0,8,136,128,0,0,136,0,16,0,0,0,17,0,0,0,17,16,0,0,17,16,0,0,81,17,0,0,85,17,240,0,85,17,255,0,85,17,242,240,85,17,242,240,81,17,255,240,17,16,15,240,17,16,15,240,17,0,0,240,16,0,0,0,0,0,136,0,0,8,136,128,0,8,136,128,0,0,136,0,0,0,0,0}
};
const unsigned char font_08_data[3][96]={
{0,0,0,0,0,1,16,0,0,22,97,0,1,102,99,16,1,102,51,16,0,19,49,51,0,1,19,51,0,0,51,51,0,19,51,51,1,19,51,51,1,19,51,68,1,51,68,68,1,51,68,68,1,19,51,68,1,19,51,51,0,19,51,51,0,0,51,51,0,1,19,51,0,22,97,51,1,102,99,16,1,102,51,16,0,19,49,0,0,1,16,0,0,0,0,0},
{0,0,0,0,1,17,17,16,1,19,49,16,17,51,51,17,51,51,51,51,51,52,67,51,51,68,68,51,51,68,68,51,52,68,68,67,68,65,20,68,68,22,97,68,65,102,99,20,65,102,51,20,68,19,49,68,68,65,20,68,52,68,68,67,51,68,68,51,51,68,67,51,51,52,67,51,51,51,51,51,17,51,51,17,1,19,49,16,1,17,17,16,0,0,0,0},
{0,0,0,0,0,1,16,0,0,22,97,0,1,102,99,16,1,102,51,16,51,19,49,0,51,49,16,0,51,51,0,0,51,51,49,0,51,51,49,16,68,51,49,16,68,68,51,16,68,68,51,16,68,51,49,16,51,51,49,16,51,51,49,0,51,51,0,0,51,49,16,0,51,22,97,0,1,102,99,16,1,102,51,16,0,19,49,0,0,1,16,0,0,0,0,0}
};
const unsigned char font_09_data[3][96]={
{0,0,0,0,4,64,0,0,4,68,0,0,4,68,68,0,4,68,68,0,4,68,0,13,4,64,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,221,0,0,13,221,0,0,13,221},
{0,0,0,0,0,13,208,0,0,221,221,0,13,221,221,208,221,221,221,221,221,214,109,221,221,68,68,221,221,68,68,221,221,214,109,221,13,221,221,208,13,221,221,208,221,221,221,221,221,221,221,221,221,102,102,221,221,102,102,221,221,221,221,221,221,221,221,221,221,102,102,221,221,102,102,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,64,0,0,68,64,208,68,68,64,208,68,68,64,208,0,68,64,0,0,4,64,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,208,0,0,0,221,0,0,0,221,208,0,0,221,208,0,0}    
};
const unsigned char font_10_data[3][96]={
{0,0,0,0,0,0,0,6,0,0,6,102,0,0,102,102,0,0,102,204,0,6,102,204,0,6,108,204,0,6,108,204,0,6,108,204,0,6,108,204,0,6,102,238,0,6,102,238,15,255,102,102,15,255,255,102,7,127,255,255,7,119,127,255,7,119,119,127,3,119,119,119,3,119,51,119,7,119,51,119,7,119,119,119,15,255,119,119,15,255,255,255,0,15,255,255},
{0,0,0,0,102,102,102,102,102,102,102,102,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,238,204,204,238,238,238,238,238,102,238,238,102,102,102,102,102,255,102,102,255,255,255,255,255,127,255,255,247,119,119,119,119,51,119,119,51,51,119,119,51,119,119,119,119,119,119,119,119,247,119,119,127},
{0,0,0,0,96,0,0,0,102,96,0,0,102,102,0,0,204,102,0,0,204,102,96,0,204,198,96,0,204,198,96,0,204,198,96,0,204,198,96,0,238,102,96,0,238,102,96,0,102,102,255,240,102,255,255,240,255,255,247,112,255,247,119,112,247,119,119,112,119,119,119,48,119,51,119,48,119,51,119,112,119,119,119,112,119,119,255,240,255,255,255,240,255,255,240,0}
};
const unsigned char font_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,8,128,0,0,143,248,0,8,143,248,128,8,255,255,128,8,255,79,136,8,244,255,136,8,255,255,136,8,255,79,136,8,244,255,136,8,255,255,136,8,143,248,136,0,143,248,136,0,143,255,255,0,136,255,255,0,8,136,136,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8},
{0,0,0,0,0,136,136,128,8,255,255,248,8,255,255,248,143,255,255,255,143,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255,255,255,244,255,255,244,255,255,255,255,255,255},
{0,0,0,0,0,0,16,0,0,1,17,0,0,17,97,16,128,1,17,0,128,0,16,0,248,0,0,0,248,8,128,0,248,143,248,0,248,143,248,128,248,255,255,128,248,255,79,128,248,244,255,128,248,255,255,128,248,255,79,128,248,244,255,128,248,255,255,128,248,143,248,128,248,143,248,0,255,255,248,0,255,255,136,0,248,136,128,0,248,0,0,0,248,0,0,0}    
};
const unsigned char font_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,5,80,0,0,5,85,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,5,80,17,0,85,80,17,0,85,80,17,0,5,80,17,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,85,0,0,5,85,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,5,80,0,0,85,85,0,0,85,85,0,0,0,0,0,0,17,17,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,17,17,0,0,0,0,0,0,85,85,0,0,85,85,0,0,5,80,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,5,80,0,0,85,80,0,0,85,0,0,0,0,0,0,0,0,0,0,16,0,0,0,16,0,0,0,17,5,80,0,17,5,85,0,17,5,85,0,17,5,80,0,16,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,85,80,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,0}    
};
const unsigned char font_13_data[3][96]={
{0,0,0,0,0,0,0,13,0,0,0,221,0,0,13,215,0,0,221,119,0,13,221,221,0,13,221,221,0,13,215,119,0,13,215,119,0,13,215,118,0,13,215,118,0,13,215,118,0,13,215,118,0,13,215,119,0,13,215,119,0,13,215,119,0,13,215,118,0,13,215,118,0,13,215,118,0,13,215,118,0,13,215,119,0,13,215,119,0,13,221,221,0,13,221,221},
{0,0,0,0,221,221,221,221,221,221,221,221,119,119,119,119,119,119,119,125,221,221,221,221,221,221,221,221,119,119,119,221,119,119,119,221,102,99,119,221,102,99,119,221,102,51,119,221,51,51,119,221,119,119,119,221,119,119,119,221,119,119,119,221,102,99,119,221,102,99,119,221,102,51,119,221,51,51,119,221,119,119,119,221,119,119,119,221,221,221,221,221,221,221,221,221},
{0,0,0,0,221,208,0,0,221,221,0,0,221,221,0,0,215,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,221,0,0,119,208,0,0,125,208,0,0,221,0,0,0,208,0,0,0}    
};
const unsigned char font_14_data[3][96]={
{0,0,0,0,4,64,0,51,4,64,3,51,0,0,51,62,0,3,51,238,0,51,62,224,3,51,238,0,3,62,224,1,3,62,0,17,3,62,1,19,3,62,1,19,3,62,0,17,3,62,0,17,3,62,1,19,3,62,1,19,3,62,0,17,3,62,224,1,3,51,238,0,0,51,62,224,0,3,51,238,0,0,51,62,4,64,3,51,4,64,0,51,0,0,0,0},
{0,0,0,0,51,51,51,51,51,51,51,51,238,238,238,238,0,0,0,0,1,16,1,16,17,17,17,17,19,49,19,49,51,51,51,51,51,52,67,51,51,68,68,51,52,64,4,67,52,64,4,67,51,68,68,51,51,52,67,51,51,51,51,51,19,49,19,49,17,17,17,17,1,16,1,16,0,0,0,0,238,238,238,238,51,51,51,51,51,51,51,51,0,0,0,0},
{0,0,0,0,51,0,4,64,51,48,4,64,227,51,0,0,238,51,48,0,14,227,51,0,0,238,51,48,16,14,227,48,17,0,227,48,49,16,227,48,49,16,227,48,17,0,227,48,17,0,227,48,49,16,227,48,49,16,227,48,17,0,227,48,16,14,227,48,0,238,51,48,14,227,51,0,238,51,48,0,227,51,0,0,51,48,4,64,51,0,4,64,0,0,0,0}    
};
const unsigned char font_15_data[3][96]={
{0,0,0,0,0,6,102,255,0,6,102,255,0,102,96,15,6,96,0,15,6,96,0,255,6,0,0,255,15,0,255,251,15,255,255,187,15,255,251,187,15,251,187,179,15,187,187,51,15,187,187,51,15,251,187,179,15,255,251,187,15,255,255,187,15,0,255,251,6,0,0,255,6,96,0,255,6,96,0,15,0,102,96,15,0,6,102,255,0,6,102,255,0,0,0,0},
{0,0,0,0,255,255,255,255,255,255,255,255,255,187,187,255,251,187,187,191,251,187,187,191,187,179,59,187,187,51,51,187,187,51,51,187,179,51,51,59,51,51,51,51,51,59,179,51,51,59,179,51,51,51,51,51,179,51,51,59,187,51,51,187,187,51,51,187,187,179,59,187,251,187,187,191,251,187,187,191,255,187,187,255,255,255,255,255,255,255,255,255,0,0,0,0},
{0,0,0,0,255,102,96,0,255,102,96,0,240,6,102,0,240,0,6,96,255,0,6,96,255,0,0,96,191,255,0,240,187,255,255,240,187,191,255,240,59,187,191,240,51,187,187,240,51,187,187,240,59,187,191,240,187,191,255,240,187,255,255,240,191,255,0,240,255,0,0,96,255,0,6,96,240,0,6,96,240,6,102,0,255,102,96,0,255,102,96,0,0,0,0,0}    
};
const unsigned char font_16_data[3][96]={
{0,0,0,0,0,17,16,0,1,16,0,0,1,0,0,0,0,0,0,187,0,0,11,187,0,0,187,176,0,0,187,0,0,11,176,8,0,187,176,136,1,27,184,136,1,17,24,132,1,17,24,132,1,27,184,136,0,187,176,136,0,11,176,8,0,0,187,0,0,0,187,176,0,0,11,187,0,0,0,187,1,0,0,11,1,16,0,0,0,17,0,0,0,0,0,0},
{0,0,0,0,0,17,17,0,11,17,17,176,187,177,27,187,187,177,27,187,0,136,136,0,8,136,136,128,136,132,72,136,136,68,68,136,136,68,68,136,68,68,68,68,68,72,132,68,68,72,132,68,68,68,68,68,136,68,68,136,136,68,68,136,136,132,72,136,8,136,136,128,0,136,136,0,187,177,27,187,187,177,27,187,11,17,17,176,0,17,17,0,0,0,0,0},
{0,0,0,0,0,0,17,0,0,0,1,16,0,0,0,16,187,0,0,0,187,176,0,0,11,187,0,0,0,187,0,0,128,11,176,0,136,11,187,0,136,139,177,16,72,129,17,16,72,129,17,16,136,139,177,16,136,11,187,0,128,11,176,0,0,187,0,0,11,187,0,0,187,176,0,0,187,0,0,0,176,0,0,16,0,0,1,16,0,1,17,0,0,0,0,0}    
};
const unsigned char font_17_data[3][96]={
{0,0,0,0,0,0,1,17,0,1,17,17,0,17,17,119,0,17,23,119,1,17,119,102,1,23,119,102,1,23,119,118,1,23,119,119,1,23,119,119,1,17,119,119,1,17,23,51,1,17,23,51,1,17,119,119,1,23,119,119,1,23,119,119,1,23,119,118,1,23,119,102,1,17,119,102,0,17,23,119,0,17,17,119,0,1,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,119,17,17,119,119,113,23,119,119,119,119,119,103,115,55,118,102,115,55,102,102,115,55,102,119,115,55,119,119,51,51,119,51,51,51,51,51,51,51,51,119,51,51,119,119,115,55,119,102,115,55,102,102,115,55,102,103,115,55,118,119,119,119,119,119,113,23,119,119,17,17,119,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,16,0,119,17,17,0,119,113,17,0,102,119,17,16,102,119,113,16,103,119,113,16,119,119,113,16,119,119,113,16,119,119,17,16,51,113,17,16,51,113,17,16,119,119,17,16,119,119,113,16,119,119,113,16,103,119,113,16,102,119,113,16,102,119,17,16,119,113,17,0,119,17,17,0,17,17,16,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_18_data[3][96]={
{0,0,0,0,0,1,17,17,0,1,221,221,1,17,221,221,1,221,221,0,1,221,208,0,1,221,0,0,1,221,0,0,1,221,0,0,1,221,0,0,1,221,208,0,1,221,208,1,1,221,208,1,1,221,208,1,1,221,0,0,1,221,0,0,1,221,0,0,1,221,0,0,1,221,208,0,1,221,221,0,1,17,221,221,0,1,221,221,0,1,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,221,221,221,221,221,221,221,221,0,0,16,0,0,1,16,0,0,17,17,0,0,17,17,0,1,17,17,16,1,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,20,65,17,17,75,180,17,17,75,180,17,1,75,180,17,1,75,180,16,0,27,177,0,0,13,208,0,221,221,221,221,221,221,221,221,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,16,0,221,221,16,0,221,221,17,16,0,221,221,16,0,13,221,16,0,0,221,16,0,0,221,16,0,0,221,16,0,0,221,16,0,13,221,16,0,13,221,16,16,13,221,16,16,13,221,16,16,0,221,16,0,0,221,16,0,0,221,16,0,0,221,16,0,13,221,16,0,221,221,16,221,221,17,16,221,221,16,0,17,17,16,0,0,0,0,0}    
};
const unsigned char font_19_data[3][96]={
{0,0,0,0,0,0,0,0,0,17,0,1,1,17,16,1,5,85,17,0,5,85,81,16,5,81,81,17,1,85,85,17,5,85,85,136,1,21,85,136,1,17,88,129,0,17,88,129,0,17,88,129,1,17,88,129,1,21,85,136,5,85,85,136,1,85,85,17,5,81,81,17,5,85,81,16,5,85,17,0,1,17,16,1,0,17,0,1,0,0,0,0,0,0,0,0},
{0,0,0,0,21,21,85,81,21,85,85,81,21,81,85,81,17,85,85,17,17,85,85,17,24,136,136,129,136,17,17,136,129,17,17,24,17,68,68,17,20,68,68,177,20,79,244,177,20,79,244,177,20,68,75,177,17,187,187,17,129,17,17,24,136,17,17,136,24,136,136,129,17,85,85,17,17,85,85,17,21,81,85,81,21,85,85,81,21,21,85,81,0,0,0,0},
{0,0,0,0,0,0,0,0,16,0,17,0,16,1,17,16,0,17,85,80,1,21,85,80,17,21,21,80,17,85,85,16,136,85,85,80,136,85,81,16,24,133,17,16,24,133,17,0,24,133,17,0,24,133,17,16,136,85,81,16,136,85,85,80,17,85,85,16,17,21,21,80,1,21,85,80,0,17,85,80,16,1,17,16,16,0,17,0,0,0,0,0,0,0,0,0}    
};
const unsigned char font_20_data[3][96]={
{0,0,0,0,0,0,85,119,0,5,85,119,0,85,87,119,5,85,119,113,5,87,119,113,7,119,119,17,7,119,17,17,7,113,17,17,7,113,17,20,7,119,17,20,0,119,17,68,0,119,17,68,7,119,17,20,7,113,17,20,7,113,17,17,7,119,17,17,7,119,119,17,5,87,119,113,5,85,119,113,0,85,87,119,0,5,85,119,0,0,85,119,0,0,0,0},
{0,0,0,0,119,112,7,119,119,119,119,119,17,119,119,17,17,17,17,17,17,17,17,17,17,20,65,16,20,68,68,64,255,68,68,255,252,196,76,207,76,204,204,196,68,204,204,68,68,204,204,68,76,204,204,196,252,196,76,207,255,68,68,255,20,68,68,65,17,20,65,17,17,17,17,17,17,17,17,17,17,119,119,17,119,119,119,119,119,112,7,119,0,0,0,0},
{0,0,0,0,119,85,0,0,119,85,80,0,119,117,85,0,23,119,85,80,23,119,117,80,17,119,119,112,17,17,119,112,17,17,23,112,65,17,23,112,65,17,119,112,68,17,119,0,68,17,119,0,65,17,119,112,65,17,23,112,17,17,23,112,17,17,119,112,17,119,119,112,23,119,117,80,23,119,85,80,119,117,85,0,119,85,80,0,119,85,0,0,0,0,0,0}    
};
const unsigned char font_00_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,224,0,0,14,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   w_hz_font_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,7,119,0,0,7,119,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,0,0,7,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,7,119,119,112,119,119,119,112,119,119,7,112,119,0,7,112,119,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,119,119,112,0,119,119,112,0,119,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,0,7,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,112,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,7,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,112,0,119,119,119,7,119,119,119,7,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,119,119,7,119,119,119,7,119,119,112,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,7,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,112,0,119,119,119,7,119,119,119,7,119,0,119,7,112,0,119,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,112,7,112,119,119,7,112,119,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,119,119,7,119,119,119,7,119,119,112,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,112,7,119,119,112,7,119,119,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,0,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,7,119,112,0,7,119,112,0,7,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,0,7,112,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,0,7,112,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,112,7,119,119,112,7,119,119,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,0,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,0,0,7,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,7,119,112,0,7,119,112,0,7,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};
const   unsigned char   w_hz_font_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}    
};

const   unsigned char   y_hz_font_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,68,0,0,4,68,0,0,4,68,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,0,0,4,68,0,0,0,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,4,68,68,64,68,68,68,64,68,68,4,64,68,0,4,64,68,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,0,68,68,64,0,68,68,64,0,68,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,68,0,4,64,68,0,68,64,68,68,68,64,68,68,68,0,4,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,64,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,64,4,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,4,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,64,0,68,68,68,4,68,68,68,4,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,68,68,4,68,68,68,4,68,68,64,0,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,64,0,0,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,68,64,0,0,68,64,0,0,68,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,64,4,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,4,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,64,0,68,68,68,4,68,68,68,4,68,0,68,4,64,0,68,4,64,0,0,4,64,0,0,4,64,0,0,4,64,68,64,4,64,68,68,4,64,68,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,4,64,68,68,4,68,68,68,4,68,68,64,0,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,64,0,0,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,68,64,0,0,68,64,0,0,68,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,4,68,68,0,68,68,68,0,68,68,64,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,68,0,68,68,68,0,4,68,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,64,4,68,68,64,4,68,68,64,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,0,4,68,68,64,0,68,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,4,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,68,68,0,68,68,68,0,4,68,64,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,68,68,0,68,68,68,0,4,68,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,4,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,68,68,0,68,68,68,0,4,68,64,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,68,68,0,68,68,68,0,4,68,64,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,4,68,64,0,4,68,64,0,4,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,4,68,64,0,68,68,68,0,68,68,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,68,68,0,68,68,68,0,4,68,64,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,68,0,4,64,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,68,0,4,64,68,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,68,68,64,4,68,68,64,4,68,68,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,64,4,68,68,68,0,68,68,4,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,64,4,68,68,64,4,68,68,64,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,0,4,68,68,64,0,68,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,4,64,4,64,4,64,4,64,4,68,68,64,68,68,68,64,64,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,68,0,0,4,4,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,68,68,68,64,64,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,68,0,68,68,4,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,4,68,64,0,4,68,64,0,4,68,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,4,64,4,64,4,64,4,64,4,68,68,64,68,68,68,64,64,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   y_hz_font_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,0,0,4,64,0,0,4,64,0,0,4,68,68,0,4,68,68,64,4,68,68,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,68,68,64,4,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,68,0,68,0,68,0,68,0,68,0,68,4,64,0,68,4,64,0,68,4,64,0,68,68,0,0,68,68,64,0,68,4,64,0,68,4,64,0,68,4,64,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,0,0,0,0,0,0,0,0}
};

const   unsigned char   g_hz_font_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,34,0,0,2,34,0,0,2,34,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,0,0,2,34,0,0,2,34,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,0,0,2,34,0,0,0,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,2,34,34,32,34,34,34,32,34,34,2,32,34,0,2,32,34,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,34,34,32,0,34,34,32,0,34,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,34,0,2,32,34,0,34,32,34,34,34,32,34,34,34,0,2,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,32,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,32,2,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,2,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,32,0,34,34,34,2,34,34,34,2,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,34,34,2,34,34,34,2,34,34,32,0,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,32,0,0,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,34,32,0,0,34,32,0,0,34,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,32,2,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,2,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,32,0,34,34,34,2,34,34,34,2,34,0,34,2,32,0,34,2,32,0,0,2,32,0,0,2,32,0,0,2,32,34,32,2,32,34,34,2,32,34,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,2,32,34,34,2,34,34,34,2,34,34,32,0,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,32,0,0,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,34,32,0,0,34,32,0,0,34,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,2,34,34,0,34,34,34,0,34,34,32,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,34,34,0,34,34,34,0,2,34,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,32,2,34,34,32,2,34,34,32,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,0,2,34,34,32,0,34,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,2,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,34,34,0,34,34,34,0,2,34,32,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,34,34,0,34,34,34,0,2,34,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,2,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,34,34,0,34,34,34,0,2,34,32,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,34,0,0,0,34,0,0,0,34,0,0,0,34,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,34,34,0,34,34,34,0,2,34,32,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,2,34,32,0,2,34,32,0,2,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,2,34,32,0,34,34,34,0,34,34,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,34,34,0,34,34,34,0,2,34,32,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,34,0,2,32,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,34,0,2,32,34,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,34,34,32,2,34,34,32,2,34,34,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,32,2,34,34,34,0,34,34,2,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,32,2,34,34,32,2,34,34,32,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,0,2,34,34,32,0,34,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,2,32,2,32,2,32,2,32,2,34,34,32,34,34,34,32,32,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,34,0,0,2,2,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,34,34,34,32,32,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,34,0,34,34,2,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,2,34,32,0,2,34,32,0,2,34,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,2,32,2,32,2,32,2,32,2,34,34,32,34,34,34,32,32,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   g_hz_font_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,2,32,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,0,0,2,32,0,0,2,32,0,0,2,34,34,0,2,34,34,32,2,34,34,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,34,34,32,2,34,34,32,0,34,34,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,0,0,34,0,34,0,34,0,34,0,34,0,34,0,34,2,32,0,34,2,32,0,34,2,32,0,34,34,0,0,34,34,32,0,34,2,32,0,34,2,32,0,34,2,32,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,34,0,0,0,0,0,0,0,0,0}
};

const   unsigned char   b_hz_font_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,102,0,0,6,102,0,0,6,102,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,0,0,6,102,0,0,0,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,6,102,102,96,102,102,102,96,102,102,6,96,102,0,6,96,102,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,102,102,96,0,102,102,96,0,102,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,102,0,6,96,102,0,102,96,102,102,102,96,102,102,102,0,6,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,96,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,96,6,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,6,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,96,0,102,102,102,6,102,102,102,6,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,102,102,6,102,102,102,6,102,102,96,0,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,96,0,0,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,102,96,0,0,102,96,0,0,102,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,96,6,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,102,0,6,96,6,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,96,0,102,102,102,6,102,102,102,6,102,0,102,6,96,0,102,6,96,0,0,6,96,0,0,6,96,0,0,6,96,102,96,6,96,102,102,6,96,102,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,6,96,102,102,6,102,102,102,6,102,102,96,0,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,96,0,0,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,102,96,0,0,102,96,0,0,102,0,0,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,6,102,102,0,102,102,102,0,102,102,96,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,102,102,0,102,102,102,0,6,102,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,96,6,102,102,96,6,102,102,96,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,0,6,102,102,96,0,102,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,6,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,102,102,0,102,102,102,0,6,102,96,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,6,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,102,102,0,102,102,102,0,6,102,96,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,102,0,0,0,102,0,0,0,102,0,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,102,102,0,102,102,102,0,6,102,96,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,6,102,96,0,6,102,96,0,6,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,6,102,96,0,102,102,102,0,102,102,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,102,102,0,102,102,102,0,6,102,96,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,102,0,6,96,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,102,0,6,96,102,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,102,102,96,6,102,102,96,6,102,102,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,96,6,102,102,102,0,102,102,6,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,96,6,102,102,96,6,102,102,96,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,0,6,102,102,96,0,102,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,6,96,6,96,6,96,6,96,6,102,102,96,102,102,102,96,96,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,102,0,0,6,6,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,102,102,102,96,96,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,102,0,102,102,6,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,6,102,96,0,6,102,96,0,6,102,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,6,96,6,96,6,96,6,96,6,102,102,96,102,102,102,96,96,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};
const   unsigned char   b_hz_font_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,6,96,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,0,0,6,96,0,0,6,96,0,0,6,102,102,0,6,102,102,96,6,102,102,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,102,102,96,6,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,102,0,102,0,102,0,102,0,102,0,102,6,96,0,102,6,96,0,102,6,96,0,102,102,0,0,102,102,96,0,102,6,96,0,102,6,96,0,102,6,96,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,102,0,0,0,0,0,0,0,0,0}
};

const   unsigned char   title_font_01_data[3][96]={
{0,0,0,0,0,1,17,17,0,17,17,17,1,17,17,17,1,17,17,17,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,0,0,0,0},
{0,0,0,0,17,17,16,0,17,17,17,0,17,17,17,16,17,17,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,17,17,17,16,17,17,17,16,17,17,17,16,17,17,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,0,0,0},
{0,0,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,17,17,17,17,17,17,1,17,17,17,0,17,17,17,0,0,0,0}
};
const   unsigned char   title_font_02_data[3][96]={
{0,0,0,0,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,0,17,17,1,17,17,17,1,17,17,17,1,17,17,16,1,17,17,0,1,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,17,17,17,0,17,17,17,16,17,17,17,16,17,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,17,17,16,17,17,17,16,17,17,17,0,17,17,16,0,17,0,0,0,0}
};
const   unsigned char   title_font_03_data[3][96]={
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,0,1,17,17,0,17,17,17,1,17,17,17,1,17,17,17,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,17,17,1,17,17,17,0,17,17,17,0,1,17,17,0,0,0,0},
{0,0,0,0,17,17,16,0,17,17,17,0,17,17,17,16,17,17,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,0,1,17,16,17,17,17,16,17,17,17,16,17,17,17,0,17,17,16,0,0,0,0,0}

};
const   unsigned char   title_font_04_data[3][96]={
{0,0,0,0,0,0,4,68,0,0,68,68,0,4,68,68,0,4,68,68,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,68,0,4,68,68,0,0,68,68,0,0,4,68,0,0,0,0,0,0,0,0,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,68,0,4,68,68,0,0,68,68,0,0,4,68,0,0,0,0},
{0,0,0,0,68,68,68,64,68,68,68,68,68,68,68,68,68,68,68,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,0,0,0,0,0,0,68,68,68,64,68,68,68,68,68,68,68,68,68,68,68,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,64,0,0,0,0},
{0,0,0,0,0,68,68,68,0,68,68,68,64,68,68,68,64,68,68,68,64,68,68,0,64,68,68,0,64,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,0,68,68,68,64,68,68,68,64,68,68,68,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0}
};
const   unsigned char   title_font_05_data[3][96]={
{0,0,0,0,68,68,68,0,68,68,68,64,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,64,68,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,4,68,68,68,4,68,68,68,4,68,68,68,4,68,68,68,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,68,68,4,68,68,68,4,68,68,68,4,68,68,68,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,68,68,4,68,68,68,4,68,68,68,4,68,68,68,0,0,0,0},
{0,0,0,0,68,68,64,0,68,68,64,4,68,68,64,68,68,68,64,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,68,64,68,68,68,64,68,68,68,64,68,68,68,64,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,68,64,68,68,68,64,68,68,68,64,4,68,68,64,0,0,0,0,0}
};
const   unsigned char   title_font_06_data[3][96]={
{0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0},
{0,0,0,0,68,0,4,68,68,64,4,68,68,68,4,68,68,68,4,68,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,64,0,0,68,0,0,0,0,0,0,0},
{0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0}
};
const   unsigned char   title_font_07_data[3][96]={
{0,0,0,0,68,64,68,68,68,64,68,68,68,64,68,68,68,64,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0},
{0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,4,68,64,0,4,68,64,0,0,68,68,0,0,68,68,0,0,4,68,0,0,4,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,0},
{0,0,0,0,0,4,68,64,64,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,68,4,68,64,64,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,0,4,68,64,64,4,68,64,64,4,68,68,68,4,68,68,68,0,68,68,68,0,4,68,0,0,0,0}
};
const   unsigned char   title_font_08_data[3][96]={
{0,0,0,0,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,0,0,4,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,64,0,0,0,0},
{0,0,0,0,64,68,68,0,64,68,68,64,64,68,68,68,64,68,68,68,64,68,68,68,64,68,68,68,64,68,68,4,64,68,68,4,64,68,68,4,64,68,68,4,64,68,68,4,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,64,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0},
{0,0,0,0,0,0,68,68,0,4,68,68,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,64,68,68,68,64,68,68,68,64,68,68,68,64,68,68,68,64,68,68,68,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0}
};
const   unsigned char   title_font_09_data[3][96]={
{0,0,0,0,0,0,0,102,0,0,6,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,0},
{0,0,0,0,0,6,102,96,96,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,102,6,102,96,0,0,0,0}
};
const   unsigned char   title_font_10_data[3][96]={
{0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,96,0,6,102,102,0,6,102,102,96,6,102,102,102,6,102,102,102,102,102,102,102,102,102,6,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0},
{0,0,0,0,96,0,102,102,96,6,102,102,96,102,102,102,96,102,102,102,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,102,96,102,102,102,96,102,102,102,96,102,102,102,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,96,102,102,0,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,96,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,0,0}
};
const   unsigned char   title_font_11_data[3][96]={
{0,0,0,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,96,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,96,0,102,102,96,0,102,102,96,0,102,102,96,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,102,0,0,0,102,96,0,6,102,102,0,102,102,102,102,102,102,102,102,102,6,102,102,102,0,102,102,102,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,0,0,0}
};
const   unsigned char   title_font_12_data[3][96]={
{0,0,0,0,0,6,6,102,0,102,6,102,6,102,6,102,102,102,6,102,102,102,0,0,102,102,0,0,102,96,0,0,102,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,102,0,0,0,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,6,102,102,0,6,102,102,0,102,102,96,0,102,102,96,6,102,102,0,6,102,102,0,102,102,96,0,102,102,96,0,102,102,0,0,102,102,0,0,102,96,0,0,102,96,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,96,6,102,96,96,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,102,0,6,102,102,0,6,102,102,0,6,102,102,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,0,6,102,96,102,6,102,102,102,6,102,102,102,6,102,102,102,6,102,102,0,0,0,0}
};
const   unsigned char   title_font_13_data[3][96]={
{0,0,0,0,102,102,102,96,102,102,102,96,102,102,102,96,102,102,102,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,96,102,102,102,96,102,102,102,96,102,102,102,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,96,102,102,102,96,102,102,102,96,102,102,102,96,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,6,102,102,0,6,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,0,0,0,0},
{0,0,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,102,96,0,0,102,102,0,0,102,102,0,0,6,102,96,0,6,102,96,0,0,102,102,0,0,102,102,0,0,102,102,0,0,0,0,0}
};


///////////////////////////////////////////////

///////////////////////////////////////////////

// delay
#define CCLK			(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_ms(10);
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);

    send_cmd(0xc8);
    send_data(0xff);
    send_data(0x93);
    send_data(0x42);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x00,0x01,0x3f);
    
    send_cmd(0x2b);
    send_data_4(0xff,0xfe,0x00,0xf1);        //send_data_4(0x00,0x00,0x00,0x5f);

    send_cmd(0x36);
    if(lcdmode==1){
        send_data(0x28);          
    }
    else{
        send_data(0x48);
    }
    
    send_cmd(0xc0);
    send_data(0x0e);
    send_data(0x0e);

    send_cmd(0xc1);
    send_data(0x10);

    send_cmd(0xc5);
    send_data(0xfa);

    send_cmd(0x3a);
    send_data(0x55);

    send_cmd(0xb1);
    send_data(0x00);
    send_data(0x18);

    send_cmd(0xe0);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x21);
    send_data(0x02);
    send_data(0x11);
    send_data(0x07);
    send_data(0x3d);
    send_data(0x79);
    send_data(0x4b);
    send_data(0x07);
    send_data(0x0f);
    send_data(0x0c);
    send_data(0x1b);
    send_data(0x1f);
    send_data(0x0f);

    send_cmd(0xe1);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x20);
    send_data(0x04);
    send_data(0x0f);
    send_data(0x04);
    send_data(0x33);
    send_data(0x45);
    send_data(0x42);
    send_data(0x04);
    send_data(0x0c);
    send_data(0x0a);
    send_data(0x22);
    send_data(0x29);
    send_data(0x0f);

    send_cmd(0x11);
    delay_ms(130);

    send_cmd(0x29);
    delay_ms(100);
}


void    disp_main2(void)
{
    unsigned int    i,j;
    unsigned char   data1,data2;

            GPIO_PinWrite(TEST,1);
            send_cmd(0x2a);
            send_data_4(0x00,0x00,0x01,0x3f);
            send_cmd(0x2b);
            send_data_4(0x00,0x00,0x00,0xef);    //send_data_4(0x00,0x00,0x00,0x5f);    
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
            for(j=0;j<240;j++){
                for(i=0;i<160;i++){
                    data1=vram1[i+j*240] >> 4;
                    data2=vram1[i+j*240] & 0x0f;
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                }
            } 

            GPIO_PinWrite(TEST,0);                
}
void    vram_clear(void)
{
    unsigned int    i,j;
    
    for(j=0;j<240;j++){
        for(i=0;i<160;i++){
            vram1[i+j*240]=0;
        }
    }
}

////////////////////////////////////////////////////
void    vram_set_font_clear(unsigned int xx,unsigned int yy)
{
        unsigned char   data;
    unsigned long    i,j,k;

    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_00_data[k][j*4+i];
                vram1[k*4+xx+i+(yy*2+j)*240]=data;
            }
        }
    }     
}
void    vram_set_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 13:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_14_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 14:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_15_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 15:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_16_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 16:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_17_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 17:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_18_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 18:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_19_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 19:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_20_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}
void    vram_set_w_hz_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=w_hz_font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}

void    vram_set_y_hz_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=y_hz_font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}

void    vram_set_g_hz_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=g_hz_font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}

void    vram_set_b_hz_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=b_hz_font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}

void    vram_set_title_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=title_font_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*240]=data;
                    }
                }
            }            
            break;
    }        
}

//////////////////////////////////////////
void    vram_set_hz_font_main(unsigned char no)
{
    unsigned int    i;
    
    for(i=0;i<13;i++){
        switch(no){
            case 0:
                vram_set_w_hz_font(i*12+4,27*4,i);
                break;
            case 1:
                vram_set_y_hz_font(i*12+4,27*4,i);                
                break;
            case 2:
                vram_set_g_hz_font(i*12+4,27*4,i);
                break;
            case 3:
                vram_set_b_hz_font(i*12+4,27*4,i);
                break;
        }

    }
}
void    vram_set_title_font_main(void)
{
    unsigned int    i;
    
    for(i=0;i<13;i++){
        vram_set_title_font(i*12+4,0,i);
    }
}
//////////////////////////////////////////
void    test_lcd_set(void)
{
    unsigned int     i,j;
    
    for(i=0;i<13;i++){
        for(j=0;j<9;j++){
            vram_set_font(i*12+4,j*12,0);
        }
    }
}
void    vram_set_level_font(unsigned int xx,unsigned char data)
{
    switch(data){
        case 0:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font_clear(xx+4,12*4);
            vram_set_font_clear(xx+4,15*4);
            vram_set_font_clear(xx+4,18*4);
            vram_set_font_clear(xx+4,21*4);
            vram_set_font_clear(xx+4,24*4);            
            break;
        case 1:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font_clear(xx+4,12*4);
            vram_set_font_clear(xx+4,15*4);
            vram_set_font_clear(xx+4,18*4);
            vram_set_font_clear(xx+4,21*4);
            vram_set_font(xx+4,24*4,font_no);             
            break;
        case 2:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font_clear(xx+4,12*4);
            vram_set_font_clear(xx+4,15*4);
            vram_set_font_clear(xx+4,18*4);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);              
            break;
        case 3:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font_clear(xx+4,12*4);
            vram_set_font_clear(xx+4,15*4);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);                
            break;
        case 4:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font_clear(xx+4,12*4);
            vram_set_font(xx+4,15*4,font_no);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);              
            break;
        case 5:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font_clear(xx+4,9*4);
            vram_set_font(xx+4,12*4,font_no);
            vram_set_font(xx+4,15*4,font_no);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);               
            break;
        case 6:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font_clear(xx+4,6*4);
            vram_set_font(xx+4,9*4,font_no);
            vram_set_font(xx+4,12*4,font_no);
            vram_set_font(xx+4,15*4,font_no);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);               
            break;
        case 7:
            vram_set_font_clear(xx+4,3*4);
            vram_set_font(xx+4,6*4,font_no);
            vram_set_font(xx+4,9*4,font_no);
            vram_set_font(xx+4,12*4,font_no);
            vram_set_font(xx+4,15*4,font_no);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);               
            break;
        case 8:
            vram_set_font(xx+4,3*4,font_no);
            vram_set_font(xx+4,6*4,font_no);
            vram_set_font(xx+4,9*4,font_no);
            vram_set_font(xx+4,12*4,font_no);
            vram_set_font(xx+4,15*4,font_no);
            vram_set_font(xx+4,18*4,font_no);
            vram_set_font(xx+4,21*4,font_no);
            vram_set_font(xx+4,24*4,font_no);          
            break;
    }
}
void    vram_set_level_main(void)
{
    unsigned int    i;
    
    for(i=0;i<13;i++){
        vram_set_level_font(i*12,level_data[i]);
    }
}
///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}
uint32_t    adc_read_an14(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN14, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}
///////////////////////////////////////////////////////////////
void    msgeq7_scan(void)
{
    uint16_t    i;

    GPIO_PinWrite(MSGEQ7_RESET,0);        
    GPIO_PinWrite(MSGEQ7_STROBE,0);
    delay_us(100);    // 
    GPIO_PinWrite(MSGEQ7_RESET,1);
    delay_us(100);    //
    GPIO_PinWrite(MSGEQ7_RESET,0);
    GPIO_PinWrite(MSGEQ7_STROBE,1);
    delay_us(100);    //
    
    for(i=0;i<7;i++){
        GPIO_PinWrite(MSGEQ7_STROBE,0);
        delay_us(100);
        adc_data[i*2]=adc_read_an14();
        adc_data[i*2+1]=adc_read_an13();
        GPIO_PinWrite(MSGEQ7_STROBE,1);
        delay_us(100);
    }
}
void    adc_data_clear(void)
{
    uint16_t    i;
    
    for(i=0;i<14;i++){
        adc_data[i]=0;
    }
}
void    level_data_clear(void)
{
    uint16_t    i;
    
    for(i=0;i<14;i++){
        level_data[i]=0;
    }
}
void    level_henkan(void)
{
    uint16_t    i;
    
    for(i=0;i<13;i++){
        if(adc_data[i]>=962){
            level_data[i]=8;
        }
        if((adc_data[i]>=760)&&(adc_data[i]<962)){
            level_data[i]=7;
        }
        if((adc_data[i]>=605)&&(adc_data[i]<760)){
            level_data[i]=6;
        }
        if((adc_data[i]>=512)&&(adc_data[i]<605)){
            level_data[i]=5;
        }
        if((adc_data[i]>=434)&&(adc_data[i]<512)){
            level_data[i]=4;
        }
        if((adc_data[i]>=388)&&(adc_data[i]<434)){
            level_data[i]=3;
        }
        if((adc_data[i]>=341)&&(adc_data[i]<388)){
            level_data[i]=2;
        }
        if((adc_data[i]>=310)&&(adc_data[i]<341)){
            level_data[i]=1;
        }
        if(adc_data[i]<310){
            level_data[i]=0;
        }
    }
}
//***************************************************************
//I2C
//***************************************************************
void    i2c_set_font_no(void)
{
    unsigned char   wdata[5];
    
    wdata[0]=0x00;
    wdata[1]=0x70;
    wdata[2]=font_no;
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);
}
void i2c_set(void)
{
    unsigned char   wdata[5],rdata[5];

    wdata[0]=0x00;
    wdata[1]=0x14;
    I2C1_Write(I2C_EEPROM,wdata,2);
    while(I2C1_IsBusy()==true);
    I2C1_Read(I2C_EEPROM,rdata,1);
    while(I2C1_IsBusy()==true);
    if(rdata[0]==0xaa){
        
        wdata[1]=0x70;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        font_no=rdata[0];

    }
    else{
        wdata[0]=0x00;
        wdata[1]=0x14;
        wdata[2]=0xaa;
        I2C1_Write(I2C_EEPROM,wdata,3);                 //i2c_data1_write(I2C_EEPROM,0x10,i2c_data);
        while(I2C1_IsBusy()==true);
        delay_us(5000);

        font_no=0;
        i2c_set_font_no();
        delay_us(5000);
    }
}


////////////////////////////////////////////////////
int main ( void )
{
    //unsigned int    testx,testy;
    
    /* Initialize all modules */
    SYS_Initialize ( NULL );

    lcdmode=0;
    
    set_up();
  
    vram_clear();
    disp_main2();
    
    delay_ms(1000);

    i2c_set();    
    
    vram_set_hz_font_main(0);
    vram_set_title_font_main();
    
    disp_main2();
    
    TMR2_Start();
    TMR3_Start();
    
    OCMP3_CompareSecondaryValueSet(80);      // 160kHz
    OCMP4_CompareSecondaryValueSet(80);      // 250kHz
    
    OCMP3_Enable();
    OCMP4_Enable();    

    adc_data_clear();
    level_data_clear();
    //font_no=0;
    
    while ( true )
    {
        /* key scan 1 */
		if (GPIO_PinRead(SW3)==0){
				sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/       
        msgeq7_scan();
        level_henkan();
        vram_set_level_main();
        
        disp_main2();
        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW3)==0)&&(sw3_key==0)){
			sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/ 
        
        /* key action */  
        if((sw3_key==0)&&(sw3_rep==0)){
            sw3_rep=1;
            font_no++;
            if(font_no>19){
                font_no=0;
            }
            i2c_set_font_no();
        }          
    }

    /* Execution should not come here during normal operation */

    return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

