/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define     LCD_RST     GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS      GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR      GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC      GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD      GPIO_PIN_RB2      //RB2 //2

#define     SW1         GPIO_PIN_RB15
#define     SW2         GPIO_PIN_RE4
#define     SW3         GPIO_PIN_RF1
#define     SW4         GPIO_PIN_RF0


#define     I2C_EEPROM  0x50

#define     SENSOR_LEVEL            500
#define     SENSOR_COUNT_LOOP       20


//#define     KEY_NEXT_COUNT_INIT 10
#define     TIME_DOWN_INIT  150
#define     NEXT_COUNT_INIT 40

//#define     VGA_FLG         1       //VGA=1,LCD=0

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************

//unsigned char   i2c_data;


unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;
unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;
unsigned char	sw4_key;
unsigned char	sw4_rep;
unsigned char	sw4_cnt;

unsigned char   pal_no;

unsigned int    time[7];
unsigned int    timer_flg;
unsigned int    timer_msec;
unsigned int    playing_flg;
unsigned char   play_pict_mode;
unsigned char   play_pict_count;

unsigned int    mode;
unsigned int    time_set_step;
unsigned int    time_set_count;

unsigned int    sensor_h_count;
unsigned int    sensor_l_count;

uint32_t        adc_data;


unsigned char   vram_r[8192];

unsigned char color_data1_init[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2_init[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char   pal_color[8][16]={
    {0,1,15,3,4,5,6,7,8,9,10,11,1,13,14,15},  
    {0,4,0,9,11,1,6,7,8,9,10,14,1,13,3,15}, 
    {0,9,15,12,13,11,6,7,8,9,10,14,3,13,1,15}, 
    {0,14,0,3,2,1,6,7,8,9,10,11,1,13,12,15}, 
    {0,12,15,13,1,12,6,7,8,9,10,14,3,13,4,15}, 
    {0,1,0,5,14,4,6,7,8,9,10,11,3,13,15,15}, 
    {0,12,3,14,5,12,6,7,8,9,10,14,1,13,11,15}, 
    {0,3,15,4,9,1,6,7,8,9,10,11,3,13,8,15},
};

const unsigned char font_suji_0_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_1_data[2][64]={
{119,119,204,204,119,119,204,204,119,204,204,204,119,204,204,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,204,204,204,119,204,204,204,119,204,204,204,119,119,119,119,},
{204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,119,119,119,204,204,204,119,204,204,204,119,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_2_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,119,119,119,119,119,119,119,119,199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,204,204,204,124,204,204,204,124,204,204,204,124,119,119,119,119,},
};
const unsigned char font_suji_3_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,119,119,119,119,119,119,119,119,119,119,119,204,119,119,119,204,119,119,119,119,119,119,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_4_data[2][64]={
{204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,199,204,204,204,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,119,119,119,},
};
const unsigned char font_suji_5_data[2][64]={
{204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,199,204,204,204,119,119,119,119,119,119,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,124,204,204,204,124,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_6_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,119,119,119,119,119,119,119,204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_7_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,119,119,119,},
};
const unsigned char font_suji_8_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_9_data[2][64]={
{199,204,204,204,204,204,204,204,204,204,119,119,204,204,119,119,204,204,119,119,204,204,119,119,204,204,204,204,199,204,204,204,119,119,119,119,119,119,119,119,204,204,119,119,204,204,119,119,204,204,204,204,204,204,204,204,199,204,204,204,119,119,119,119,},
{204,204,204,119,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,119,199,204,124,119,199,204,124,119,199,204,124,119,199,204,124,204,204,204,124,204,204,204,124,204,204,204,119,119,119,119,119,},
};
const unsigned char font_suji_clear_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};

const unsigned char font_c2_data[64]={119,119,119,119,119,119,119,119,119,199,124,119,119,204,204,119,119,204,204,119,119,199,124,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,199,124,119,119,204,204,119,119,204,204,119,119,199,124,119,119,119,119,119,119,119,119,119,};
const unsigned char font_c1_data[64]={119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,199,124,119,119,204,204,119,119,204,204,119,119,199,124,119,119,119,119,119,};

const unsigned char data_font_p1[8192]={
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,51,51,51,51,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,52,51,51,51,51,3,0,51,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,51,51,51,51,51,0,0,48,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,51,51,51,51,3,112,119,0,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,52,51,51,51,51,3,112,119,7,0,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,231,238,238,238,238,14,0,0,68,68,68,68,68,68,52,51,51,51,51,0,119,119,119,0,48,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,238,238,238,238,14,0,64,68,68,68,68,68,52,51,51,51,51,0,119,119,119,7,48,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,238,238,238,238,14,0,68,68,68,68,68,51,51,51,51,3,112,119,119,119,0,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,119,238,238,238,238,0,64,68,68,68,68,51,51,51,51,0,119,119,119,119,0,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,119,231,238,238,238,14,0,68,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,231,238,238,238,0,64,68,68,68,51,51,51,3,112,119,119,119,0,51,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,238,238,238,14,0,68,68,68,51,51,51,0,119,119,119,119,0,51,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,238,238,238,0,64,68,68,52,51,51,0,119,119,119,7,48,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,231,238,238,14,0,68,68,52,51,3,112,119,119,119,7,48,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,238,238,238,0,64,68,52,51,3,112,119,119,119,0,51,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,231,238,238,238,238,238,119,119,119,119,231,238,238,14,0,68,68,51,51,0,112,119,119,0,51,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,238,238,238,238,126,119,119,119,119,238,238,238,0,68,68,51,51,0,0,119,7,48,51,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,238,238,238,238,126,119,119,119,238,238,238,0,64,68,52,3,112,7,0,0,48,51,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,238,238,238,238,119,119,119,231,238,238,14,64,68,68,0,119,119,0,0,51,51,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,231,238,238,238,126,119,119,119,238,238,14,0,68,68,0,119,119,48,51,51,51,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,231,238,238,238,119,119,119,231,238,238,0,64,4,112,119,7,48,51,51,51,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,238,238,238,126,119,119,119,238,238,14,64,4,112,119,7,51,51,51,51,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,231,238,238,238,119,119,119,231,238,238,0,0,119,119,0,52,51,51,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,238,238,238,119,119,119,231,238,238,0,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,231,238,238,126,119,231,238,238,238,14,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,238,238,126,231,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,238,238,238,238,238,126,119,119,119,231,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,238,119,119,119,119,238,238,238,238,238,238,238,0,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,126,119,119,119,238,238,238,238,238,238,238,0,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,119,119,238,238,238,238,238,238,238,14,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,231,238,238,238,238,238,238,238,14,112,119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,0,119,119,0,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,0,119,119,0,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,224,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,224,238,238,238,238,238,238,238,238,238,119,231,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,14,224,14,0,119,119,7,224,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,119,119,231,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,0,0,0,0,112,119,119,0,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,126,119,119,119,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,238,0,0,0,176,0,112,119,119,7,224,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,0,238,238,238,238,238,238,238,238,119,119,119,231,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,14,0,0,0,187,187,0,119,119,119,0,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,126,119,119,119,238,238,238,238,238,30,17,17,17,17,238,238,238,238,14,0,0,187,187,187,187,11,112,119,7,224,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,119,238,238,238,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,187,187,187,187,187,11,112,7,0,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,224,238,238,238,119,119,238,238,238,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,187,187,187,187,187,11,0,0,224,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,126,119,119,231,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,14,176,187,187,187,187,187,187,0,224,238,238,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,0,238,238,126,119,119,119,238,238,238,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,14,176,187,187,187,187,187,0,224,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,238,119,119,119,231,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,14,176,187,187,187,11,0,0,224,238,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,119,119,119,119,238,238,238,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,0,187,187,0,0,0,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,126,119,119,119,238,238,238,238,119,119,119,119,119,119,231,238,238,238,238,238,238,238,238,0,11,0,0,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,238,119,119,119,231,238,238,238,126,119,119,119,119,119,231,238,238,238,238,238,238,238,238,0,0,176,11,238,238,238,238,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,119,119,119,119,231,238,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,14,0,176,11,224,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,126,119,119,119,119,238,238,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,14,176,11,224,238,238,238,238,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,119,119,119,119,231,238,238,238,238,126,119,119,231,238,238,238,238,238,238,238,238,238,238,0,187,0,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,0,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,224,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,126,119,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,119,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,126,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,126,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,34,34,66,68,68,68,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,64,68,68,68,68,68,68,68,68,36,34,34,34,68,68,68,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,126,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,68,68,68,68,68,68,68,68,68,34,34,34,34,66,68,68,36,34,85,37,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,82,85,85,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,82,85,85,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,34,34,66,68,68,36,34,85,37,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,68,68,68,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,66,68,68,68,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
};
const unsigned char data_font_p2[8192]={
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,51,51,51,51,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,52,51,51,51,51,3,0,51,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,51,51,51,51,51,0,0,48,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,51,51,51,51,3,112,119,0,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,52,51,51,51,51,3,112,119,7,0,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,68,68,68,68,68,68,52,51,51,51,51,0,119,119,119,0,48,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,64,68,68,68,68,68,52,51,51,51,51,0,119,119,119,7,48,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,51,51,51,51,3,112,119,119,119,0,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,51,51,51,51,0,119,119,119,119,0,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,51,51,51,3,112,119,119,119,0,51,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,126,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,51,51,51,0,119,119,119,119,0,51,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,126,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,52,51,51,0,119,119,119,7,48,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,52,51,3,112,119,119,119,7,48,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,52,51,3,112,119,119,119,0,51,51,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,51,51,0,112,119,119,0,51,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,126,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,51,51,0,0,119,7,48,51,51,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,52,3,112,7,0,0,48,51,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,0,119,119,0,0,51,51,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,119,119,119,119,238,238,238,238,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,0,119,119,48,51,51,51,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,119,119,119,231,238,238,238,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,4,112,119,7,48,51,51,51,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,126,119,119,119,238,238,238,126,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,4,112,119,7,51,51,51,51,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,119,119,119,231,238,238,238,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,119,119,0,52,51,51,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,119,119,119,231,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,126,119,119,119,238,238,238,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,126,119,119,231,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,119,119,119,231,238,238,119,119,119,119,238,238,238,238,238,30,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,119,119,119,238,238,238,119,119,119,231,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,126,119,119,119,238,238,126,119,119,119,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,126,119,119,231,238,238,126,119,119,231,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,14,112,119,7,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,224,238,126,119,119,231,238,238,119,119,119,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,119,119,119,238,238,126,119,119,119,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,119,119,119,238,238,126,119,119,231,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,119,119,119,238,238,126,119,119,231,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,14,112,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,126,119,119,231,238,238,119,119,119,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,0,238,126,119,119,231,238,238,119,119,119,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,126,119,119,231,238,238,119,119,119,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,126,119,119,231,238,238,119,119,231,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,126,119,119,231,238,238,119,119,231,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,119,119,231,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,0,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,7,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,14,112,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,119,119,231,238,238,238,14,112,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,119,119,231,238,238,119,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,119,231,238,238,119,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,126,119,119,231,238,238,119,0,119,119,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,126,119,119,231,238,238,7,112,119,7,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,119,119,119,238,238,238,7,112,119,7,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,119,119,238,238,126,0,119,119,0,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,119,119,238,238,126,0,119,119,0,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,126,119,119,231,238,238,14,112,119,7,224,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,119,119,7,224,14,0,119,119,7,224,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,119,119,0,0,0,0,112,119,119,0,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,126,0,0,0,176,0,112,119,119,7,224,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,14,0,0,0,187,187,0,119,119,119,0,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,238,238,238,238,14,0,0,187,187,187,187,11,112,119,7,224,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,187,187,187,187,187,11,112,7,0,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,187,187,187,187,187,11,0,0,224,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,7,176,187,187,187,187,187,187,0,112,231,238,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,7,176,187,187,187,187,187,0,112,119,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,7,176,187,187,187,11,0,0,112,119,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,0,187,187,0,0,0,119,119,231,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,0,11,0,0,126,119,119,119,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,176,11,119,119,119,231,238,238,14,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,176,11,112,119,119,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,176,11,112,119,119,238,238,238,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,187,0,119,231,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,0,187,0,119,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,7,0,0,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,0,224,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,231,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,34,34,66,68,68,68,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,64,68,68,68,68,68,68,68,68,36,34,34,34,68,68,68,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,68,68,68,68,68,68,68,68,68,34,34,34,34,66,68,68,36,34,85,37,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,82,85,85,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,85,85,85,37,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,82,85,85,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,34,34,66,68,68,36,34,85,37,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,68,68,68,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,66,68,68,68,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
};
const unsigned char data_font_off[8192]={
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,52,51,51,51,51,51,51,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,51,51,51,51,51,51,51,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,52,51,51,3,0,0,0,0,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,51,51,51,0,0,0,0,0,48,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,51,51,51,0,119,119,119,7,48,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,231,238,238,238,238,14,0,0,68,68,68,68,68,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,238,238,238,238,14,0,64,68,68,68,68,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,238,238,238,238,14,0,68,68,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,119,238,238,238,238,0,64,68,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,119,231,238,238,238,14,0,68,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,119,231,238,238,238,0,64,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,238,238,238,14,0,68,68,68,51,51,51,51,0,119,119,119,7,48,51,51,51,67,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,119,238,238,238,0,64,68,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,231,238,238,14,0,68,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,238,238,238,0,64,68,52,51,51,51,0,119,119,119,7,48,51,51,51,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,231,238,238,238,238,238,119,119,119,119,231,238,238,14,0,68,68,51,51,51,0,119,119,119,7,48,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,238,238,238,238,126,119,119,119,119,238,238,238,0,68,68,51,51,51,0,0,0,0,0,48,51,51,67,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,238,238,238,238,126,119,119,119,238,238,238,0,64,68,52,51,51,3,0,0,0,0,51,51,51,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,238,238,238,238,119,119,119,231,238,238,14,64,68,68,51,51,51,0,119,7,48,51,51,67,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,119,231,238,238,238,126,119,119,119,238,238,14,0,68,68,52,51,51,0,119,7,48,51,51,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,231,238,238,238,119,119,119,231,238,238,0,64,68,68,51,51,0,119,7,48,51,67,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,119,238,238,238,126,119,119,119,238,238,14,64,68,68,68,51,0,119,7,48,67,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,231,238,238,238,119,119,119,231,238,238,0,68,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,119,238,238,238,119,119,119,231,238,238,0,68,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,126,119,119,119,231,238,238,126,119,231,238,238,238,14,64,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,119,119,119,119,238,238,126,231,238,238,238,238,14,64,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,238,238,238,238,238,126,119,119,119,231,238,238,238,238,238,238,238,14,64,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,238,119,119,119,119,238,238,238,238,238,238,238,238,0,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,126,119,119,119,238,238,238,238,238,238,238,238,0,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,119,119,238,238,238,238,238,238,238,238,238,0,68,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,119,231,238,238,238,238,238,238,238,238,238,0,64,68,68,0,119,7,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,4,112,119,0,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,4,112,119,0,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,4,112,119,0,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,0,119,7,64,68,68,68,68,68,68,68,0,119,
119,0,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,0,119,7,64,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,0,119,7,64,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,4,112,119,0,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,4,112,119,0,68,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,0,119,7,64,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,0,119,7,64,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,0,119,7,64,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,4,112,119,0,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,4,112,119,0,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,1,0,0,0,0,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,4,112,119,0,68,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,0,0,0,16,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,0,119,7,64,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,1,0,0,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,0,119,7,64,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,4,224,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,4,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,17,17,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,68,0,119,7,64,68,68,68,68,0,119,
119,0,68,68,0,238,238,238,238,238,238,238,238,238,238,238,238,238,238,30,17,17,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,68,0,119,7,64,68,68,68,68,0,119,
119,0,68,68,0,224,238,238,238,238,238,238,238,238,238,119,231,238,238,238,17,17,17,17,17,17,17,17,17,17,17,225,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,0,119,7,64,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,238,119,119,231,238,238,238,30,17,17,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,4,224,238,238,238,238,238,238,238,126,119,119,119,238,238,238,238,30,17,17,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,4,0,238,238,238,238,238,238,238,238,119,119,119,231,238,238,238,238,30,17,17,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,238,238,238,126,119,119,119,238,238,238,238,238,30,17,17,17,17,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,68,0,238,238,238,238,238,119,238,238,238,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,68,68,4,112,119,0,68,68,68,68,68,0,119,
119,0,68,68,68,0,224,238,238,238,119,119,238,238,238,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,64,0,112,7,64,68,68,68,68,68,0,119,
119,0,68,68,68,4,224,238,238,126,119,119,231,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,68,4,0,0,119,7,64,68,68,68,68,68,0,119,
119,0,68,68,68,4,0,238,238,126,119,119,119,238,238,238,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,0,11,112,119,0,64,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,238,238,238,119,119,119,231,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,4,176,187,0,7,0,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,0,224,238,238,119,119,119,119,238,238,238,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,0,187,187,11,0,64,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,4,0,238,238,126,119,119,119,238,238,238,238,119,119,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,4,176,187,187,187,0,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,238,238,238,119,119,119,231,238,238,238,126,119,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,64,68,68,68,68,0,187,187,187,187,11,64,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,0,224,238,238,119,119,119,119,231,238,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,4,176,187,187,187,187,11,64,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,224,238,238,126,119,119,119,119,238,238,238,238,126,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,68,68,68,68,0,187,187,187,187,187,0,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,4,0,238,238,238,119,119,119,119,231,238,238,238,238,126,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,4,176,187,187,187,187,11,64,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,0,224,238,238,126,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,0,187,187,187,187,187,0,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,4,0,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,0,187,187,187,187,11,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,0,224,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,4,176,187,187,187,0,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,4,0,238,238,238,126,119,119,119,119,119,231,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,0,187,187,11,64,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,0,224,238,238,238,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,4,176,187,0,0,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,4,0,238,238,238,238,119,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,0,11,176,11,64,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,0,224,238,238,238,126,119,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,64,68,68,68,68,68,68,68,68,4,0,176,187,0,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,4,0,238,238,238,238,126,119,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,34,0,0,187,11,64,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,0,0,238,238,238,238,238,119,119,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,64,68,68,68,68,68,68,68,68,36,34,34,2,176,11,64,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,4,0,0,238,238,238,238,238,126,119,119,119,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,68,68,68,68,68,68,68,68,68,34,34,34,34,0,0,68,36,34,34,34,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,68,68,68,68,68,68,68,68,68,36,34,34,34,34,2,64,68,34,34,34,34,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,4,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,34,34,34,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,224,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,0,0,64,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,34,34,34,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,238,238,238,238,238,238,238,238,238,238,238,238,238,14,0,0,64,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,34,34,34,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,224,238,238,238,238,238,238,238,238,238,238,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,34,34,68,68,34,34,34,34,34,66,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,238,238,238,238,238,14,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,34,34,66,68,68,36,34,34,34,34,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,36,34,34,34,68,68,68,68,34,34,34,66,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,0,0,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,34,34,66,68,68,68,68,36,34,34,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,119,
119,0,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,4,0,119,
119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,
119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
};




// delay
#define CCLK			(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_ms(10);
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);

    send_cmd(0xc8);
    send_data(0xff);
    send_data(0x93);
    send_data(0x42);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x01,0x00,0x80);       //send_data_4(0x00,0x03,0x00,0x82);
    
    send_cmd(0x2b);
    send_data_4(0x00,0x02,0x00,0x81); 

    send_cmd(0x36);
    send_data(0x68);    //a8
    
    send_cmd(0xc0);
    send_data(0x0e);
    send_data(0x0e);

    send_cmd(0xc1);
    send_data(0x10);

    send_cmd(0xc5);
    send_data(0xfa);

    send_cmd(0x3a);
    send_data(0x55);

    send_cmd(0xb1);
    send_data(0x00);
    send_data(0x18);

    send_cmd(0xe0);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x21);
    send_data(0x02);
    send_data(0x11);
    send_data(0x07);
    send_data(0x3d);
    send_data(0x79);
    send_data(0x4b);
    send_data(0x07);
    send_data(0x0f);
    send_data(0x0c);
    send_data(0x1b);
    send_data(0x1f);
    send_data(0x0f);

    send_cmd(0xe1);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x20);
    send_data(0x04);
    send_data(0x0f);
    send_data(0x04);
    send_data(0x33);
    send_data(0x45);
    send_data(0x42);
    send_data(0x04);
    send_data(0x0c);
    send_data(0x0a);
    send_data(0x22);
    send_data(0x29);
    send_data(0x0f);

    send_cmd(0x11);
    delay_ms(130);

    send_cmd(0x29);
    delay_ms(100);
    
    GPIO_PinWrite(LCD_CS,1);
}


void    disp_main2(void)
{
    unsigned int    i;
    unsigned char   data1,data2;


            GPIO_PinWrite(LCD_CS,0);
            
            send_cmd(0x2a);
            send_data_4(0x00,0x01,0x00,0x80);       //send_data_4(0x00,0x03,0x00,0x82);
            send_cmd(0x2b);
            send_data_4(0x00,0x02,0x00,0x81);   
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
    
            for (i=0;i<8192;i++){
                data2=vram_r[i] >> 4;
                data1=vram_r[i] & 0x0f;
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
            }

            GPIO_PinWrite(LCD_CS,1);

}

void    vram_clear(unsigned char color)
{
    unsigned int i;
    unsigned char data;
    
    data=(color << 4) | color;
    
    for(i=0;i<8192;i++){
        vram_r[i]=data;
    }
}

void    vram_set_p1(void){
    unsigned int    i;
    
    for(i=0;i<8192;i++){
        vram_r[i]=data_font_p1[i];
    }
}
void    vram_set_p2(void){
    unsigned int    i;
    
    for(i=0;i<8192;i++){
        vram_r[i]=data_font_p2[i];
    }
}
void    vram_set_off(void){
    unsigned int    i;
    
    for(i=0;i<8192;i++){
        vram_r[i]=data_font_off[i];
    }
}
void    vram_set_c2(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j;

    for(j=0;j<16;j++){
        for(i=0;i<4;i++){
            data=font_c2_data[j*4+i];
            vram_r[xx+i+(yy*2+j)*64]=data;
        }
    }
}
void    vram_set_c1(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned long    i,j;

    for(j=0;j<16;j++){
        for(i=0;i<4;i++){
            data=font_c1_data[j*4+i];
            vram_r[xx+i+(yy*2+j)*64]=data;
        }
    }
}
void    vram_set_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_clear_data[k][j*4+i];
                        vram_r[k*4+xx+i+(yy*2+j)*64]=data;
                    }
                }
            }            
            break;            
    }        
}


void    disp_ram_set_time(void)
{
    vram_set_suji(0,1,time[0]);
    vram_set_suji(8,1,time[1]);
    vram_set_suji(16,1,time[2]);
    vram_set_c2(24,1);
    vram_set_suji(28,1,time[3]);
    vram_set_suji(36,1,time[4]);
    vram_set_c1(44,1);
    vram_set_suji(48,1,time[5]);
    vram_set_suji(56,1,time[6]);
}
void    disp_ram_set_time_s(unsigned int no){
    switch(no){
        case 0:
            vram_set_suji(0,1,10);
            break;
        case 1:
            vram_set_suji(8,1,10);
            break;;
        case 2:
            vram_set_suji(16,1,10);
            break;
        case 3:
            vram_set_suji(28,1,10);
            break;
        case 4:
            vram_set_suji(36,1,10);
            break;
        case 5:
            vram_set_suji(48,1,10);
            break;
        case 6:
            vram_set_suji(56,1,10);
            break;
    }
}
void    clear_time(void)
{
    unsigned int    i;
    
    for(i=0;i<7;i++){
        time[i]=0;
    }
    timer_flg=0;
    timer_msec=0;
}
void    time_count_up(void)
{
    time[6]++;
    if(time[6]>=10){
        time[6]=0;
        time[5]++;
        if(time[5]>=6){
            time[5]=0;
            time[4]++;
            if(time[4]>=10){
                time[4]=0;
                time[3]++;
                if(time[3]>=6){
                    time[3]=0;
                    time[2]++;
                    if(time[2]>=10){
                        time[2]=0;
                        time[1]++;
                        if(time[1]>=10){
                            time[1]=0;
                            time[0]++;
                            if(time[0]>=10){
                                time[0]=0;
                            }
                        }
                    }
                }
            }
        }
    }
}

void timer_int(uint32_t status,uintptr_t context)
{
    timer_flg=1;
}


///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}

// *****************************************************************************
void    pal_color_set(void)
{
    unsigned int i;
    
    for (i=0;i<16;i++){
        color_data1[i]=color_data1_init[pal_color[pal_no][i]];
        color_data2[i]=color_data2_init[pal_color[pal_no][i]];
    }
}



//***************************************************************
//I2C
//***************************************************************
void    eeprom_set_palet(void)
{
    unsigned char   wdata[5];
    
    wdata[0]=0x00;
    wdata[1]=0x50;
    wdata[2]=pal_no;
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);
}
void    eeprom_set_time(void)
{
    unsigned char   wdata[5];
    
    wdata[0]=0x00;
    wdata[1]=0x20;
    wdata[2]=time[0];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x21;
    wdata[2]=time[1];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x22;
    wdata[2]=time[2];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x23;
    wdata[2]=time[3];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x24;
    wdata[2]=time[4];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x25;
    wdata[2]=time[5];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);
    wdata[1]=0x26;
    wdata[2]=time[6];
    I2C1_Write(I2C_EEPROM,wdata,3);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);    
}
void eeprom_check(void)
{
    unsigned char   wdata[5],rdata[5];

    wdata[0]=0x00;
    wdata[1]=0x10;
    I2C1_Write(I2C_EEPROM,wdata,2);
    while(I2C1_IsBusy()==true);
    I2C1_Read(I2C_EEPROM,rdata,1);
    while(I2C1_IsBusy()==true);
    if(rdata[0]==0xaa){
        
        wdata[1]=0x50;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        pal_no=rdata[0];
        
        wdata[1]=0x20;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[0]=rdata[0];        
        wdata[1]=0x21;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[1]=rdata[0]; 
        wdata[1]=0x22;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[2]=rdata[0]; 
        wdata[1]=0x23;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[3]=rdata[0]; 
        wdata[1]=0x24;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[4]=rdata[0]; 
        wdata[1]=0x25;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[5]=rdata[0]; 
        wdata[1]=0x26;
        I2C1_Write(I2C_EEPROM,wdata,2);
        while(I2C1_IsBusy()==true);
        I2C1_Read(I2C_EEPROM,rdata,1);
        while(I2C1_IsBusy()==true);
        time[6]=rdata[0];         
    }
    else{
        wdata[0]=0x00;
        wdata[1]=0x10;
        wdata[2]=0xaa;
        I2C1_Write(I2C_EEPROM,wdata,3);                 //i2c_data1_write(I2C_EEPROM,0x10,i2c_data);
        while(I2C1_IsBusy()==true);
        delay_us(5000);

        pal_no=0;
        eeprom_set_palet();
        eeprom_set_time();
        delay_us(5000);
    }
}


// *****************************************************************************
int main ( void )
{
    
    /* Initialize all modules */
    SYS_Initialize ( NULL );

    GPIO_PinWrite(LCD_CS,1);
 
    set_up();
    
    vram_clear(0);

    disp_main2();


    delay_ms(1000);

    TMR3_CallbackRegister( timer_int, 0 );
    TMR3_Start();
    clear_time();
    pal_no=0;
    
    eeprom_check();
    playing_flg=0;  //TEST
    
    if(GPIO_PinRead(SW4)==0){
        mode=1;
    }
    else{
        mode=0;
    }
    time_set_step=0;
    time_set_count=0;
    
    sensor_h_count=0;
    sensor_l_count=0;
    
    play_pict_mode=0;
    play_pict_count=0;
    
    pal_color_set();
    
    
    vram_clear(0);

    vram_set_p1();
    disp_ram_set_time(); 

    disp_main2();

    while(GPIO_PinRead(SW4)==0){}
    
    adc_data=0;
    
    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        //SYS_Tasks ( );
        /* key scan 1 */
		if (GPIO_PinRead(SW1)==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if (GPIO_PinRead(SW2)==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/
		if (GPIO_PinRead(SW3)==0){
				sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/                
		if (GPIO_PinRead(SW4)==0){
				sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
		/*------------------*/                     

        //vram_set_p2();
        

        

        disp_main2();


        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if ((GPIO_PinRead(SW2)==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/ 
		if ((GPIO_PinRead(SW3)==0)&&(sw3_key==0)){
			sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/             
		if ((GPIO_PinRead(SW4)==0)&&(sw4_key==0)){
			sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
		/*------------------*/              


        
        /* key action */  
		if((sw1_key==0)&&(sw1_rep==0)){
			sw1_rep=1;
            switch(mode){
                case 0:
                    pal_no++;
                    if(pal_no>=8){
                        pal_no=0;
                    }
                    pal_color_set();
                    eeprom_set_palet();
                    break;
                case 1:
                    time_set_count=0;
                    if(time_set_step<6){
                        time_set_step++;
                    }
                    else{
                        time_set_step=0;
                    }
                    break;
            }
		}
        /*------------------*/
		if((sw2_key==0)&&(sw2_rep==0)){
			sw2_rep=1;
            switch(mode){
                case 0:
                
                    break;
                case 1:
                    switch(time_set_step){
                        case 0:
                        case 1:
                        case 2:
                        case 4:
                        case 6:
                            time[time_set_step]++;
                            time_set_count=1;
                            if(time[time_set_step]>=10){
                                time[time_set_step]=0;
                            }
                            break;
                        case 3:
                        case 5:
                            time[time_set_step]++;
                            time_set_count=1;
                            if(time[time_set_step]>=6){
                                time[time_set_step]=0;
                            }                            
                            break;
                    }
                    break;
            }
		}
        /*------------------*/
		if((sw3_key==0)&&(sw3_rep==0)){
			sw3_rep=1;
            switch(mode){
                case 0:
                
                    break;
                case 1:
                    switch(time_set_step){
                        case 0:
                        case 1:
                        case 2:
                        case 4:
                        case 6:
                            if(time[time_set_step]>0){
                                time[time_set_step]--;
                            }
                            else{
                                time[time_set_step]=9;
                            }
                            time_set_count=1;
                            break;
                        case 3:
                        case 5:
                            if(time[time_set_step]>0){
                                time[time_set_step]--;
                            }
                            else{
                                time[time_set_step]=5;
                            }
                            time_set_count=1;
                            break;                  
                    }
                    break;
            }
		}
        /*------------------*/
		if((sw4_key==0)&&(sw4_rep==0)){
			sw4_rep=1;
            switch(mode){
                case 0:
                    //TEST
                    switch(playing_flg){
                        case 0:
                            playing_flg=1;
                            break;
                        case 1:
                            playing_flg=0;
                            break;
                    }
                    //TEST
                    break;
                case 1:
                    mode=0;
                    disp_ram_set_time();
                    eeprom_set_time();
                    break;
            }
		}
        /*------------------*/        
        switch(mode){
            case 0:
                switch(playing_flg){
                    case 0:
                        vram_set_off();
                        disp_ram_set_time();
                        break;
                    case 1:
                        if(timer_flg==1){
                            timer_flg=0;
                            
                            play_pict_count++;
                            if(play_pict_count>=3){
                                play_pict_count=0;
                                switch(play_pict_mode){
                                    case 0:
                                        vram_set_p1();
                                        disp_ram_set_time();
                                        play_pict_mode=1;
                                        break;
                                    case 1:
                                        vram_set_p2();
                                        disp_ram_set_time();
                                        play_pict_mode=0;
                                        break;
                                }
                            }                            
                            
                            timer_msec++;
                            if(timer_msec>=10){
                                timer_msec=0;
                                time_count_up();
                                disp_ram_set_time();
                            }

                        }
                        break;
                }
                break;
            case 1:
                if(timer_flg==1){
                    timer_flg=0;
                    time_set_count++;
                    if(time_set_count>=80){
                        time_set_count=0;
                    }
                    disp_ram_set_time();
                    if((time_set_count&4)==4){
                        disp_ram_set_time_s(time_set_step);
                    }
                }
                break;
        }
        
        // Sensor action
        adc_data=adc_read_an13();
        if(adc_data>SENSOR_LEVEL){
            sensor_h_count++;
            sensor_l_count=0;
            if(sensor_h_count>SENSOR_COUNT_LOOP){
                sensor_h_count=0;
                if(playing_flg==0){            
                    playing_flg=1;
                    eeprom_set_time();
                }
            }
        }
        else{
            sensor_l_count++;
            sensor_h_count=0;
            if(sensor_l_count>SENSOR_COUNT_LOOP){
                sensor_l_count=0;
                if(playing_flg==1){
                    playing_flg=0;
                    eeprom_set_time();
                }
            }
        }                
        
        /* Execution should not come here during normal operation */
    }
    //return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

