#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "usart.h"
#include "ad.h"
#include "pwm.h"
#include "cpld_sub.h"
#include "wait_time.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

//unsigned long	hz_no;
unsigned char	pwm_data;
unsigned char	pwm_flg;
unsigned int	pow_data;
unsigned long	freq_no;
unsigned long	freq_no_m;
unsigned int	vol_data;
unsigned char	out_flg;
unsigned char	vol_mode;
unsigned char	step_flg;
unsigned char	hen_d[24];
unsigned int	vol_count;
unsigned int    disp_count;
unsigned char   ms_mode;
unsigned int    ms_count;
unsigned int    ms_level;

unsigned char   sq_duty;
unsigned char   sq_dset;

unsigned char	receive_data;
unsigned int	receive_flg;
unsigned char   tx_data[4];

unsigned char   wave_mode;
unsigned int    level_count;
unsigned int    level_data;
unsigned int    level_st[5];
unsigned int    level_st_count;

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;
unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;
unsigned char	sw4_key;
unsigned char	sw4_rep;
unsigned char	sw4_cnt;
unsigned char	sw5_key;
unsigned char	sw5_rep;
unsigned char	sw5_cnt;

unsigned char	sw1p;
unsigned char	sw2p;
unsigned char	sw3p;
unsigned char	sw4p;
unsigned char   sw5p;

/*--------------------USART INTERRUPT-------------*/
void	interrupt InterReceiver(void)
{
	if(RCIF==1){
		receive_data=RCREG;
		receive_flg=1;
		RCIF =0;
	}
}
/*---------------------TUNE TX--------------------*/
void	data_tx(unsigned char data)
{
unsigned char	no;

	no=(unsigned char)(data);
	putch(no);
}
/*--------------------HENKAN-----------------------*/
void    tx_henkan(unsigned long data)
{
unsigned char n0,n1,n2;
unsigned long count;

    count=data;
	n0=(unsigned char)(count & 0x000000ff);
	n1=(unsigned char)((count & 0x0000ff00) >> 8);
	n2=(unsigned char)((count & 0x00ff0000) >> 16);
	
	tx_data[2]=n2;
    tx_data[1]=n1;
    tx_data[0]=n0;
    
    tx_data[3]=sq_duty;
    //tx_data[2]=tx_data[2] | (wave_mode <<4);
}
/*---------------------FREQ-----------------------*/
void	freq_no_inc(void)
{
	switch(vol_mode){
        case 3: freq_no=freq_no+5;
                break;
        case 4: freq_no=freq_no+1;
                break;
        default:freq_no=freq_no+10;
                break;
    }
    //freq_no=freq_no+10;
	if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
}

void	freq_no_dec(void)
{
	switch(vol_mode){
        case 3: freq_no=freq_no-5;
                break;
        case 4: freq_no=freq_no-1;
                break;
        default:freq_no=freq_no-10;
                break;
    }
	//freq_no=freq_no-10;
	if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
}

void	freq_no_inc_1k(void)
{
unsigned long	step;

	switch(vol_mode){
		case 1:	step=1000;break;
		case 2:	step=100;break;
		case 3: step=50;break;
		case 4:	step=20;break;
        case 5: step=1000;break;
        case 6: step=1000;break;
	}

	freq_no=freq_no/step;
	freq_no=freq_no*step; 
	freq_no=freq_no+step;
	if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
}

void	freq_no_dec_1k(void)
{
unsigned long	step;

	switch(vol_mode){
		case 1:	step=1000;break;
		case 2:	step=100;break;
		case 3: step=50;break;
		case 4:	step=20;break;
        case 5: step=1000;break;
        case 6: step=1000;break;
	}

	if(freq_no>step){
		if((freq_no % step)==0){
			freq_no=freq_no-step;
		}
		else{
			freq_no=freq_no/step;
			freq_no=freq_no*step;
		}
	}
	else{
		freq_no=FREQ_MIN;
	}
}
/*---------------------SQ DUTY-------------------*/
void	sq_duty_inc(void)
{
	sq_duty++;
	if(sq_duty>SQ_DUTY_MAX){sq_duty=SQ_DUTY_MAX;}
}

void	sq_duty_dec(void)
{
	sq_duty--;
	if(sq_duty<SQ_DUTY_MIN){sq_duty=SQ_DUTY_MIN;}
}
void	sq_duty_inc_10(void)
{
	if(sq_duty>SQ_DUTY_MAX2){sq_duty=SQ_DUTY_MAX;}
    else{sq_duty=sq_duty+10;}
}

void	sq_duty_dec_10(void)
{
	if(sq_duty<SQ_DUTY_MIN2){sq_duty=SQ_DUTY_MIN;}
    else{sq_duty=sq_duty-10;}
}
/*---------------------MOJI PRINT----------------*/
void    moji_tx(unsigned char no)
{
    switch(no){
        case 1:
            data_tx(0x79);      /* HELLO*/
            data_tx(0x47);
            data_tx(0xc6);
            data_tx(0x00);
            break;
        case 5:
            data_tx(vol_mode);      /* FS001*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;
        case 4:
            data_tx(vol_mode);      /* FS002*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;
        case 3:
            data_tx(vol_mode);      /* FS003*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;
        case 2:
            data_tx(vol_mode);      /* FS004*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;
        case 6:
            data_tx(vol_mode);      /* FS005*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;
        case 7:
            data_tx(0x98);      /*SG- ON*/
            data_tx(0xbc);
            data_tx(0xad);
            data_tx(0x00);
            break;
        case 8:
            data_tx(0x55);      /*SG-OFF*/
            data_tx(0xb9);
            data_tx(0xad);
            data_tx(0x00);
            break;
        case 9:
            data_tx(0xcc);      /*SGB   */
            data_tx(0x1c);
            data_tx(0xad);
            data_tx(0x00);
            break;
        case 10:
            data_tx(0xcc);      /*SGC   */
            data_tx(0x2c);
            data_tx(0xad);
            data_tx(0x00);
            break;
        case 11:
            data_tx(sq_duty);   /*SGDxxx*/
            data_tx(0xd3);
            data_tx(0xfa);
            data_tx(0x00);
            break;
        case 12:
            data_tx(0xcc);      /*SGA   */
            data_tx(0x0c);
            data_tx(0xad);
            data_tx(0x00);
            break;
        case 13:
            data_tx(sq_duty);   /*SD-xxx*/
            data_tx(0x3b);
            data_tx(0xfa);
            data_tx(0x00);
            break;
        case 14:
            data_tx(0x98);      /*AFS ON*/
            data_tx(0xac);
            data_tx(0x05);
            data_tx(0x00);
            break;
        case 15:
            data_tx(0x55);      /*AFSOFF*/
            data_tx(0xa9);
            data_tx(0x05);
            data_tx(0x00);
            break;
        case 16:
            data_tx(vol_mode);      /* FS006*/
            data_tx(0x5a);
            data_tx(0xfc);
            data_tx(0x00);
            break;            
    }
    
}
/*--------------------HZ PRINT------------------*/
void    hz_tx(unsigned long data)
{
        tx_henkan(data);
        data_tx(tx_data[0]);
        data_tx(tx_data[1]);
        data_tx(tx_data[2]);
        data_tx(tx_data[3]);
}
/*--------------------ROM SELECT----------------*/
void    rom_select(unsigned char data)
{
    switch(data){
        case 0: 
            CPLD_ROM_SEL0=0;
            CPLD_ROM_SEL1=0;
            
            break;
        case 1:
            CPLD_ROM_SEL0=1;
            CPLD_ROM_SEL1=0;
            
            break;
        case 2:
            CPLD_ROM_SEL0=0;
            CPLD_ROM_SEL1=1;
            
            break;
        case 3:
            CPLD_ROM_SEL0=1;
            CPLD_ROM_SEL1=1;
            
            break;
    }
}
/*---------------------AUTO FREQ INC--------------*/
void    freq_next(void)
{
    if((freq_no>=20) && (freq_no<100)){freq_no=freq_no+2;}
    else{
        if((freq_no>=100) && (freq_no<1000)){freq_no=freq_no+10;}
        else{
            if((freq_no>=1000) && (freq_no<10000)){freq_no=freq_no+100;}
            else{
                if((freq_no>=10000) && (freq_no<100000)){freq_no=freq_no+1000;}
                else{
                    if((freq_no>=100000) && (freq_no<740000)){freq_no=freq_no+5000;}
                }
            }
        }
    }
}    
/*---------------------AUTO LEVEL OUT-------------*/
void    level_out(unsigned long freq,unsigned int level)
{
unsigned char   i;

    LEVEL_CLK=0;
    LEVEL_DATA=0;
    
    for(i=0;i<16;i++){
        if((level & 0x01)==0x01){
            LEVEL_DATA=1;
        }
        else{
            LEVEL_DATA=0;
        }
        wait_time(5);
        LEVEL_CLK=1;
        wait_time(5);
        LEVEL_CLK=0;
        wait_time(5);
        level=level >> 1;
    }
     for(i=0;i<24;i++){
        if((freq & 0x01)==0x01){
            LEVEL_DATA=1;
        }
        else{
            LEVEL_DATA=0;
        }
        wait_time(5);
        LEVEL_CLK=1;
        wait_time(5);
        LEVEL_CLK=0;
        wait_time(5);
        freq=freq >> 1;
    }
    LEVEL_CLK=0;
    LEVEL_DATA=0;

}
/*---------------------MAIN-----------------------*/
void	main(void)
{
unsigned char   flg;

	port_init();
	cpld_init();
	cpld_reset_out();

	out_flg=0;
	vol_mode=2;
	vol_count=0;
    level_count=0;
    level_st_count=0;
    disp_count=0;
    ms_mode=0;
    ms_count=0;
    ms_level=0;
	pwm_data=PWM_DATA_INIT;;
	pwm_flg=0;
	step_flg=0;
    receive_flg=0;
	init_usart();	
 	start_pwm1();
	set_pwm1(pwm_data);
	__delay_ms(200);
	while(pwm_flg==0){
		pow_data=pow_yomi();
		if((pow_data>=POW_DATA_MIN)&&(pow_data<=POW_DATA_MAX)){
			pwm_flg=1;
		}
		if(pow_data<POW_DATA_MIN){
			pwm_data=pwm_data-2;
		}
		if(pow_data>POW_DATA_MAX){
			pwm_data=pwm_data+2;
		}
		set_pwm1(pwm_data);
		__delay_ms(200);
	}
  
	__delay_ms(500);
    
	sw1_key=0;sw1_rep=0;sw1_cnt=0;
	sw2_key=0;sw2_rep=0;sw2_cnt=0;
	sw3_key=0;sw3_rep=0;sw3_cnt=0;
	sw4_key=0;sw4_rep=0;sw4_cnt=0;
	sw5_key=0;sw5_rep=0;sw5_cnt=0;
	    
	__delay_ms(100);

    wave_mode=0;
    rom_select(wave_mode);
    sq_duty=128;
    sq_dset=0;
    
    flg=0;

    moji_tx(1);
    __delay_ms(1000);
    
    freq_no=FREQ_MIN;
    hz_tx(freq_no);
    
	while(1){
		sw1p=RC0;NOP();
		sw2p=RC1;NOP();
		sw3p=RC3;NOP();
		sw4p=RC4;NOP();
        sw5p=RB4;NOP();
        
        /* key scan 1 */
		if (sw1p==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if (sw2p==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/
		if (sw3p==0){
				sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/
		if (sw4p==0){
				sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
		/*------------------*/
		if (sw5p==0){
				sw5_key=0;
		}
		else{
			sw5_key=1;
			sw5_rep=0;
			sw5_cnt=0;
		}
		/*------------------*/
        
		wait_time(1000);

		sw1p=RC0;NOP();
		sw2p=RC1;NOP();
		sw3p=RC3;NOP();
		sw4p=RC4;NOP();
        sw5p=RB4;NOP();
        
        /* key scan 2 */
		if ((sw1p==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if ((sw2p==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/
		if ((sw3p==0)&&(sw3_key==0)){
			sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/
		if ((sw4p==0)&&(sw4_key==0)){
			sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
		}
		/*------------------*/
		if ((sw5p==0)&&(sw5_key==0)){
			sw5_key=0;
		}
		else{
			sw5_key=1;
			sw5_rep=0;
			sw5_cnt=0;
		}
		/*------------------*/

        /* key action */
	
		if((sw1_key==0)&&(sw1_rep==0)){
			sw1_rep=1;
            if(sq_dset==0){
				freq_no_inc();
				hz_tx(freq_no);
				if(out_flg==1){cpld_data_out(freq_no);}	
				//lcd_vol_mode(vol_mode);
				//lcd_vol_step();	
				step_flg=1;	
            }
            else{
                sq_duty_inc();
                cpld_sq_latch(freq_no,sq_duty);
                moji_tx(13);
                disp_count=DISP_LOOP_LONG;                
            }
		}
		/*------------------*/
		if((sw1_key==0)&&(sw1_rep==1)){
			sw1_cnt++;
			if(sw1_cnt>=KEY_LONG_UD){
                if(sq_dset==0){
					sw1_cnt=0;
					freq_no_inc_1k();
					hz_tx(freq_no);
					if(out_flg==1){cpld_data_out(freq_no);}
					//lcd_vol_mode(vol_mode);
					//lcd_vol_step();
					step_flg=1;
                }
                else{
                    sw1_cnt=0;
                    sq_duty_inc_10();
                    cpld_sq_latch(freq_no,sq_duty);
                    moji_tx(13);
                    disp_count=DISP_LOOP_LONG;                    
                }
                                    
			}
		}
		/*------------------*/
		if((sw2_key==0)&&(sw2_rep==0)){
			sw2_rep=1;
            if(sq_dset==0){
				freq_no_dec();
				hz_tx(freq_no);
				if(out_flg==1){cpld_data_out(freq_no);}
				//lcd_vol_mode(vol_mode);
				//lcd_vol_step();
				step_flg=1;
            }
            else{
                sq_duty_dec();
                cpld_sq_latch(freq_no,sq_duty);
                moji_tx(13);
                disp_count=DISP_LOOP_LONG;                
            }
		}
		/*------------------*/
		if((sw2_key==0)&&(sw2_rep==1)){
			sw2_cnt++;
			if(sw2_cnt>=KEY_LONG_UD){
                if(sq_dset==0){
					sw2_cnt=0;
					freq_no_dec_1k();
					hz_tx(freq_no);
					if(out_flg==1){cpld_data_out(freq_no);}
					//lcd_vol_mode(vol_mode);
					//lcd_vol_step();
					step_flg=1;
                }
                else{
                    sw2_cnt=0;
                    sq_duty_dec_10();
                    cpld_sq_latch(freq_no,sq_duty);
                    moji_tx(13);
                    disp_count=DISP_LOOP_LONG;                    
                }
			}
		}

		/*--------------------*/

		if((sw3_key==0)&&(sw3_rep==0)){
						sw3_rep=1;
                        sq_dset=0;
						switch(step_flg){
							case 0:
									switch(vol_mode){
										case 1:	vol_mode=2;
												vol_count=0;
												freq_no_m=0;
												moji_tx(3);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 2:	vol_mode=3;
												vol_count=0;
												freq_no_m=0;
												moji_tx(4);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 3:	vol_mode=4;
												vol_count=0;
												freq_no_m=0;
												moji_tx(5);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 4:	vol_mode=5;
												vol_count=0;
												freq_no_m=0;
												moji_tx(6);
                                                disp_count=DISP_LOOP_SET;
												break;
                                        case 5: vol_mode=6;
                                                vol_count=0;
                                                freq_no_m=0;
                                                moji_tx(16);
                                                disp_count=DISP_LOOP_SET;
                                                break;
                                        case 6: vol_mode=1;
                                                vol_count=0;
                                                freq_no_m=0;
                                                moji_tx(2);
                                                disp_count=DISP_LOOP_SET;
                                                break;
									}
									break;
							case 1:	
									step_flg=0;
									switch(vol_mode){
										case 1:	vol_mode=1;
												vol_count=0;
												freq_no_m=0;
												moji_tx(2);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 2:	vol_mode=2;
												vol_count=0;
												freq_no_m=0;
												moji_tx(3);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 3:	vol_mode=3;
												vol_count=0;
												freq_no_m=0;
												moji_tx(4);
                                                disp_count=DISP_LOOP_SET;
												break;
										case 4:	vol_mode=4;
												vol_count=0;
												freq_no_m=0;
												moji_tx(5);
                                                disp_count=DISP_LOOP_SET;
												break;
                                        case 5: vol_mode=5;
                                                vol_count=0;
                                                freq_no_m=0;
                                                moji_tx(6);
                                                disp_count=DISP_LOOP_SET;
                                                break;
                                        case 6: vol_mode=6;
                                                vol_count=0;
                                                freq_no_m=0;
                                                moji_tx(16);
                                                disp_count=DISP_LOOP_SET;
                                                break;
									}
									break;									
						}

		}
		/*------------------*/
		if((sw4_key==0)&&(sw4_rep==0)){
						sw4_rep=1;
						sq_dset=0;
                        if(ms_mode==1){
                            ms_mode=0;
                            wave_mode=0;
                            moji_tx(12);
                            disp_count=DISP_LOOP_SET;      
                        }
                        else{
						switch(out_flg){
							case 0:	out_flg=1;
									cpld_data_out(freq_no);
                                    cpld_sq_latch(freq_no,sq_duty);
									moji_tx(7);
                                    disp_count=DISP_LOOP_SET;
									break;
							case 1:	out_flg=0;
									cpld_data_out(0);
									cpld_reset_out();
									moji_tx(8);
                                    disp_count=DISP_LOOP_SET;
									break;
						}
                        }
		}
		/*------------------*/
		if((sw4_key==0)&&(sw4_rep==1)){
			sw4_cnt++;
			if(sw4_cnt>=KEY_LONG_MS){
                switch(ms_mode){
                    case 0: sw4_cnt=0;
                            ms_mode=1;
                            out_flg=1;
                            moji_tx(14);
                            freq_no=20;
                            wave_mode=0;
                            rom_select(wave_mode);                            
                            cpld_data_out(freq_no);
                            disp_count=DISP_LOOP_SET;
                            ms_count=MS_COUNT_LONG;
                            level_st_count=0;
                            level_count=LEVEL_COUNT_SET;                                    
                            break;
                    case 1: 
                            break;
                 }
            }
 
		}        
		/*------------------*/
 		if((sw5_key==0)&&(sw5_rep==0)){
						sw5_rep=1;
                        if(sq_dset==0){
                        /**/
						if(disp_count>0){
                            switch(wave_mode){
                                case 0: wave_mode=1;
                                        moji_tx(9);
                                        disp_count=DISP_LOOP_SET;
                                        rom_select(wave_mode);
                                        break;
                                case 1: wave_mode=2;
                                        moji_tx(10);
                                        disp_count=DISP_LOOP_SET;
                                        rom_select(wave_mode);
                                        break;
                                case 2: wave_mode=3;
                                        moji_tx(11);
                                        disp_count=DISP_LOOP_SET;
                                        rom_select(wave_mode);
                                        break;
                                case 3: wave_mode=0;
                                        moji_tx(12);
                                        disp_count=DISP_LOOP_SET;
                                        rom_select(wave_mode);
                                        break;
                                
                            }
                        }
                        else{
                            switch(wave_mode){
                                case 0: wave_mode=0;
                                        moji_tx(12);
                                        disp_count=DISP_LOOP_SET;
                                    
                                        break;
                                case 1: wave_mode=1;
                                        moji_tx(9);
                                        disp_count=DISP_LOOP_SET;
                                    
                                        break;
                                case 2: wave_mode=2;
                                        moji_tx(10);
                                        disp_count=DISP_LOOP_SET;
                                    
                                        break;
                                case 3: wave_mode=3;
                                        moji_tx(11);
                                        disp_count=DISP_LOOP_SET;
                                    
                                        break;
                            }                        
                            
                        }
                        /**/
                        }
                        else{
                            sq_dset=0;
                            moji_tx(11);
                            disp_count=DISP_LOOP_SET;
                        }
                        
		}
		/*------------------*/       
		if((sw5_key==0)&&(sw5_rep==1)){
			sw5_cnt++;
			if(sw5_cnt>=KEY_LONG_UD){
							sw5_cnt=0;
                            sq_dset=1;
                            moji_tx(13);
                            disp_count=DISP_LOOP_LONG;
			}
		}
		/*------------------*/        
        
        if(ms_mode==0){
		if(step_flg==0){
		/**/
		if(vol_mode==1){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/7;
				freq_no=freq_no*1000;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}

		if(vol_mode==2){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/10;
				freq_no=freq_no*200;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}

		if(vol_mode==3){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/10;
				freq_no=freq_no*100;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}

		if(vol_mode==4){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/10;
				freq_no=freq_no*50;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}
        
		if(vol_mode==5){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/6;
				freq_no=freq_no*2000;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}        
        
 		if(vol_mode==6){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				vol_data=vol_yomi();
				freq_no=(unsigned long)vol_data/6;
				freq_no=freq_no*4000;
				if(freq_no<FREQ_MIN){freq_no=FREQ_MIN;}
				if(freq_no>FREQ_MAX){freq_no=FREQ_MAX;}
				if(freq_no_m!=freq_no){
					if(out_flg==1){cpld_data_out(freq_no);}
					if(disp_count==0){hz_tx(freq_no);}
					freq_no_m=freq_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}        
        
		/**/
		}
        }

        /*-----------------------*/
        if(ms_mode==1){
            if(ms_count>0){ms_count--;}
            if(ms_count==0){
                if(freq_no>=740000){
                    level_out(freq_no,ms_level);
                    ms_mode=0;
                    moji_tx(15);
                    disp_count=DISP_LOOP_SET;
                    freq_no_m=0;
                }           
                else{
                    level_out(freq_no,ms_level);
                    freq_next();
                    cpld_data_out(freq_no);
                    disp_count=DISP_LOOP_MIN;                
                    ms_count=MS_COUNT_SET;
                    level_st_count=0;
                    level_count=LEVEL_COUNT_SET;
                }
            }
        }
        
        /*---------------*/
        if(level_count>0){level_count--;}
        if(level_count==0){
            level_data=level_yomi();
            level_st[level_st_count]=level_data;
            level_st_count++;
            if(level_st_count>4){
                level_st_count=0;
                level_data=(level_st[0]+level_st[1]+level_st[2]+level_st[3]+level_st[4])/5;
                ms_level=level_data;
                level_data_latch((unsigned long)level_data);
                level_count=LEVEL_COUNT_SET;
            }
        }
        /*---------------*/

        if(disp_count>0){
            disp_count--;
            if(disp_count==0){
                hz_tx(freq_no);
                sq_dset=0;
            }
        }
        
        
        

	}

}