#include <htc.h>
#include "user_define.h"
#include "wait_time.h"

extern unsigned char hen_d[24];

void	cpld_init(void)
{
	CPLD_COUNT_SEL1=0;NOP();
	CPLD_COUNT_SEL2=0;NOP();
	CPLD_COUNT_RESET=1;NOP();
	CPLD_S_CLOCK=0;NOP();
	CPLD_S_DATA=0;NOP();
	CPLD_S_LATCH=0;NOP();
	CPLD_S_RESET=1;NOP();
    CPLD_SQ_LATCH=0;NOP();
    CPLD_ROM_SEL0=0;NOP();
    CPLD_ROM_SEL1=0;NOP();
}
void	cpld_reset_out(void)
{
	CPLD_S_RESET=0;NOP();
	wait_time(50);
	CPLD_S_RESET=1;NOP();
	wait_time(50);
	CPLD_S_LATCH=1;NOP();
	wait_time(50);
	CPLD_S_LATCH=0;NOP();
	wait_time(50);
	CPLD_COUNT_RESET=0;NOP();
	wait_time(50);
	CPLD_COUNT_RESET=1;NOP();	
}

void	cpld_data_out(unsigned long freq)
{
unsigned long hen_data,in_data;
unsigned int i;
	
	if(freq<=93000){
		in_data=freq*256;
		CPLD_COUNT_SEL1=1;NOP();
		CPLD_COUNT_SEL2=1;NOP();
	}
	if((freq>=93001)&&(freq<=187000)){
		in_data=freq*128;
		CPLD_COUNT_SEL1=0;NOP();
		CPLD_COUNT_SEL2=1;NOP();
	}
	if((freq>=187001)&&(freq<=374000)){
		in_data=freq*64;
		CPLD_COUNT_SEL1=0;NOP();
		CPLD_COUNT_SEL2=0;NOP();
	}
	if((freq>=374001)&&(freq<=748000)){
		in_data=freq*32;
		CPLD_COUNT_SEL1=1;NOP();
		CPLD_COUNT_SEL2=0;NOP();
	}	

	hen_data=in_data*128+375;
	hen_data=hen_data/375;
	hen_data=hen_data*128;
	hen_data=hen_data/125;

	for (i=0;i<24;i++){
		hen_d[i]=(unsigned char)(hen_data%2);
		hen_data=hen_data >> 1;
	}

	for (i=0;i<24;i++){
		CPLD_S_DATA=(hen_d[23-i] & 0x01);NOP();
		wait_time(5);
		CPLD_S_CLOCK=1;NOP();
		wait_time(5);
		CPLD_S_CLOCK=0;NOP();
	}

	CPLD_S_LATCH=1;NOP();			/* LATCH */
	wait_time(10);
	CPLD_S_LATCH=0;NOP();

	
}

void	cpld_sq_latch(unsigned long freq,unsigned char data)
{
unsigned char in_data;
unsigned int i;
	
	//if(freq<=93000){
		in_data=data;
	//}
	//if((freq>=93001)&&(freq<=187000)){
	//	in_data=data/2;
	//}
	//if((freq>=187001)&&(freq<=374000)){
	//	in_data=data/4;
	//}

	for (i=0;i<8;i++){
		hen_d[i]=(unsigned char)(in_data%2);
		in_data=in_data >> 1;
	}

	for (i=0;i<8;i++){
		CPLD_S_DATA=(hen_d[7-i] & 0x01);NOP();
		wait_time(5);
		CPLD_S_CLOCK=1;NOP();
		wait_time(5);
		CPLD_S_CLOCK=0;NOP();
	}

	CPLD_SQ_LATCH=1;NOP();			/* SQ LATCH */
	wait_time(10);
	CPLD_SQ_LATCH=0;NOP();
	
}

void    level_data_latch(unsigned long data)
{
unsigned long   out_data;
unsigned char   nn;
unsigned char   n[6];
unsigned char   i,j;

    out_data=data*19;
    out_data=out_data*33;
    out_data=out_data*5;
    out_data=out_data/256;
    if(out_data>6800){
        nn=0;
        out_data=out_data-6800;
    }
    else{
        nn=1;
        out_data=6800-out_data;
    }

	n[0]=(unsigned char)(out_data%10);out_data=(out_data-n[0])/10;
	n[1]=(unsigned char)(out_data%10);out_data=(out_data-n[1])/10;
    n[2]=(unsigned char)(out_data%10);out_data=(out_data-n[2])/10;
    n[3]=(unsigned char)(out_data%10);
    if(nn==1){n[4]=10;}else{n[4]=15;}
    n[5]=15;
    n[0]=15;  /*TEST*/
    
    for (j=0;j<6;j++){
        for (i=0;i<4;i++){
            if((n[5-j] & 0x08)==0x08){
                CPLD_S_DATA=1;
            }
            else{
                CPLD_S_DATA=0;
            }
            n[5-j]=n[5-j] << 1;
            wait_time(5);
            CPLD_S_CLOCK=1;NOP();
            wait_time(5);
            CPLD_S_CLOCK=0;NOP();        
        }
    }

	CPLD_L_LATCH=1;NOP();			/* LATCH */
	wait_time(10);
	CPLD_L_LATCH=0;NOP();    
}
