#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "usart.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

unsigned long	hz_no;
unsigned char   suji[6];
unsigned char   sub[3];
unsigned char   moji[26]={0xFC,0x60,0xDA,0xF2,0x66,0xB6,0xBE,0xE4,0xFE,0xF6,
                        0xEE,0x3E,0x1A,0x7A,0x9E,0x8E,0x6E,0x1C,0x2A,0xFC,0xB6,
                        0x02,0x10,0xf6,0x00,0x00};
    
unsigned char	receive_data;
unsigned int	receive_flg;
unsigned char   rx_data[4];
unsigned char   rx_count;
unsigned int    loop_count;
unsigned char   loop_flg;

//unsigned char   wave_mode;
unsigned char   sq_duty;

/*--------------------USART INTERRUPT-------------*/
void	interrupt InterReceiver(void)
{
	if(RCIF==1){
		receive_data=RCREG;
        loop_count=1;
        rx_data[rx_count]=receive_data;
        rx_count++;
            if(rx_count>3){
                rx_count=0;
                receive_flg=1;
            }        
        RCIF =0;
	}
}
/*---------------------TUNE TX--------------------*/
void	data_tx(unsigned int data)
{
unsigned char	no;

	no=(unsigned char)(data);
	putch(no);
}
/*--------------------HENKAN-----------------------*/
void    hz_henkan(unsigned long data)
{
unsigned char n0,n1,n2,n3,n4,n5;
unsigned long count;
unsigned char nn;

	count=data;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);count=(count-n1)/10;
	n2=(unsigned char)(count%10);count=(count-n2)/10;
	n3=(unsigned char)(count%10);count=(count-n3)/10;
    n4=(unsigned char)(count%10);count=(count-n4)/10;
    n5=(unsigned char)(count%10);
	
	suji[0]=n5;nn=n5;if(nn==0){suji[0]=24;}
    suji[1]=n4;nn=nn+n4;if(nn==0){suji[1]=24;}
    suji[2]=n3;nn=nn+n3;if(nn==0){suji[2]=24;}
    suji[3]=n2;nn=nn+n2;if(nn==0){suji[3]=24;}
    suji[4]=n1;nn=nn+n1;if(nn==0){suji[4]=24;}
    suji[5]=n0;
    
}
void    henkan_10(unsigned char data)
{
unsigned char n0,n1,n2;

	n0=(unsigned char)(data%10);data=(data-n0)/10;
	n1=(unsigned char)(data%10);data=(data-n1)/10;
	n2=(unsigned char)(data%10);

    sub[0]=n2;
    sub[1]=n1;
    sub[2]=n0;
    
}

/*---------------------LED DISP--------------------*/
void    led_disp(void)
{
    SEL0=1;SEL1=1;SEL2=1;SEL3=1;SEL4=1;SEL5=1;
    
    PORTB=~moji[suji[0]];
    SEL0=0;
    __delay_ms(1);
    SEL0=1;
    
    PORTB=~moji[suji[1]];
    SEL1=0;
    __delay_ms(1);
    SEL1=1;
    
    PORTB=~moji[suji[2]];
    SEL2=0;
    __delay_ms(1);
    SEL2=1;
    
    PORTB=~moji[suji[3]];
    SEL3=0;
    __delay_ms(1);
    SEL3=1;
    
    PORTB=~moji[suji[4]];
    SEL4=0;
    __delay_ms(1);
    SEL4=1;
    
    PORTB=~moji[suji[5]];
    SEL5=0;
    __delay_ms(1);
    SEL5=1;
   
}
/*---------------------JUSHIN HENKAN SHORI---------------*/
void    rx_henkan(void)
{
    unsigned char   data2;
    
    if(rx_data[3]==0){
        if((rx_data[2] & 0xf0) == 0xf0){
            suji[0]=(rx_data[2] & 0x0f)+10;
            suji[1]=(rx_data[1] >> 4)+10;
            suji[2]=(rx_data[1] & 0x0f)+10;
            henkan_10(rx_data[0]);
            suji[3]=sub[0];
            suji[4]=sub[1];
            suji[5]=sub[2];        
        }
        else{
            suji[0]=(rx_data[2] >> 4)+10;
            suji[1]=(rx_data[2] & 0x0f)+10;
            suji[2]=(rx_data[1] >> 4)+10;
            suji[3]=(rx_data[1] & 0x0f)+10;
            suji[4]=(rx_data[0] >> 4)+10;
            suji[5]=(rx_data[0] & 0x0f)+10;
        }
    }
    else{
        //data2=rx_data[2] & 0x0f;
        //wave_mode=(rx_data[2] & 0xf0) >> 4;
        sq_duty=rx_data[3];
        hz_no=(unsigned long)rx_data[0]+(unsigned long)rx_data[1]*256+(unsigned long)rx_data[2]*256*256;
        hz_henkan(hz_no);
    }


}
/*---------------------MAIN-----------------------*/
void	main(void)
{
unsigned char   flg;

	port_init();

	__delay_ms(500);

	
	receive_flg=0;
    rx_count=0;
	init_usart();	

	loop_count=0;
    loop_flg=0;
 	__delay_ms(500);

	hz_no=0;
    
    //wave_mode=0;
    sq_duty=0;
    flg=0;

	while(1){

        if(receive_flg==1){
            receive_flg=0;
            rx_henkan();
        }
      
        led_disp();

        if(loop_count>0){
            loop_count++;
            RA7=1;
            if(loop_count>5){
                loop_count=0;
                rx_count=0;
                RA7=0;
            }
        }
        
        
        
        
	}

}