-------------------------------------------------------
-- zero check convert
-- 20016/7/23
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity zerocheckconv is
	port(
		in_zero	:in std_logic;
		a			:in std_logic;
		b			:in std_logic;
		c			:in std_logic;
		d			:in std_logic;
		out_a		:out std_logic;
		out_b		:out std_logic;
		out_c		:out std_logic;
		out_d		:out std_logic;
		out_zero	:out std_logic
		);
end zerocheckconv;

architecture rtl of zerocheckconv is
	signal input_table	:std_logic_vector(4 downto 0);
	signal output_table	:std_logic_vector(4 downto 0);
	
begin
	input_table <= in_zero & d & c & b & a;
	with input_table select
		output_table <= 	"00000" when "00000",	-- 0
								"00001" when "00001",	-- 1
								"00010" when "00010",	-- 2
								"00011" when "00011",	-- 3
								"00100" when "00100",	-- 4
								"00101" when "00101",	-- 5
								"00110" when "00110",	-- 6
								"00111" when "00111",	-- 7
								"01000" when "01000",	-- 8
								"01001" when "01001",	-- 9
								"11111" when "10000",	-- zero 0 => F
								"00001" when "10001",	-- zero 1
								"00010" when "10010",	-- zero 2
								"00011" when "10011",	-- zero 3
								"00100" when "10100",	-- zero 4
								"00101" when "10101",	-- zero 5
								"00110" when "10110",	--	zero 6
								"00111" when "10111",	--	zero 7
								"01000" when "11000",	-- zero 8
								"01001" when "11001",	-- zero 9
								"00000" when others;
						
	out_a <= output_table(0);
	out_b <= output_table(1);
	out_c <= output_table(2);
	out_d <= output_table(3);
	out_zero <= output_table(4);

end rtl;	
		