-------------------------------------------------------
-- triangle table 10bit + select
-- 2016/6/11
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity tritable10bitsel is
	port(
		clk		:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		reset	:in std_logic;
		tri0	:out std_logic;
		tri1	:out std_logic;
		tri2	:out std_logic;
		tri3	:out std_logic;
		tri4	:out std_logic;
		tri5	:out std_logic;
		tri6	:out std_logic;
		tri7	:out std_logic;
		tri8	:out std_logic;
		tri9	:out std_logic
	);
end tritable10bitsel;

architecture rtl of tritable10bitsel is
	signal rom_adrs	:std_logic_vector(7 downto 0);
	signal rom_latch:std_logic_vector(9 downto 0);
	
	subtype tri_wave is std_logic_vector(9 downto 0);
	type rom is array (0 to 255) of tri_wave;
	constant tri : rom := (
"1000000000","1000001000","1000010000","1000011000","1000100000","1000101000","1000110000","1000111000",
"1001000000","1001001000","1001010000","1001011000","1001100000","1001101000","1001110000","1001111000",
"1010000000","1010001000","1010010000","1010011000","1010100000","1010101000","1010110000","1010111000",
"1011000000","1011001000","1011010000","1011011000","1011100000","1011101000","1011110000","1011111000",
"1100000000","1100001000","1100010000","1100011000","1100100000","1100101000","1100110000","1100111000",
"1101000000","1101001000","1101010000","1101011000","1101100000","1101101000","1101110000","1101111000",
"1110000000","1110001000","1110010000","1110011000","1110100000","1110101000","1110110000","1110111000",
"1111000000","1111001000","1111010000","1111011000","1111100000","1111101000","1111110000","1111111000",
"1111111111","1111111000","1111110000","1111101000","1111100000","1111011000","1111010000","1111001000",
"1111000000","1110111000","1110110000","1110101000","1110100000","1110011000","1110010000","1110001000",
"1110000000","1101111000","1101110000","1101101000","1101100000","1101011000","1101010000","1101001000",
"1101000000","1100111000","1100110000","1100101000","1100100000","1100011000","1100010000","1100001000",
"1100000000","1011111000","1011110000","1011101000","1011100000","1011011000","1011010000","1011001000",
"1011000000","1010111000","1010110000","1010101000","1010100000","1010011000","1010010000","1010001000",
"1010000000","1001111000","1001110000","1001101000","1001100000","1001011000","1001010000","1001001000",
"1001000000","1000111000","1000110000","1000101000","1000100000","1000011000","1000010000","1000001000",
"1000000000","0111111000","0111110000","0111101000","0111100000","0111011000","0111010000","0111001000",
"0111000000","0110111000","0110110000","0110101000","0110100000","0110011000","0110010000","0110001000",
"0110000000","0101111000","0101110000","0101101000","0101100000","0101011000","0101010000","0101001000",
"0101000000","0100111000","0100110000","0100101000","0100100000","0100011000","0100010000","0100001000",
"0100000000","0011111000","0011110000","0011101000","0011100000","0011011000","0011010000","0011001000",
"0011000000","0010111000","0010110000","0010101000","0010100000","0010011000","0010010000","0010001000",
"0010000000","0001111000","0001110000","0001101000","0001100000","0001011000","0001010000","0001001000",
"0001000000","0000111000","0000110000","0000101000","0000100000","0000011000","0000010000","0000001000",
"0000000000","0000001000","0000010000","0000011000","0000100000","0000101000","0000110000","0000111000",
"0001000000","0001001000","0001010000","0001011000","0001100000","0001101000","0001110000","0001111000",
"0010000000","0010001000","0010010000","0010011000","0010100000","0010101000","0010110000","0010111000",
"0011000000","0011001000","0011010000","0011011000","0011100000","0011101000","0011110000","0011111000",
"0100000000","0100001000","0100010000","0100011000","0100100000","0100101000","0100110000","0100111000",
"0101000000","0101001000","0101010000","0101011000","0101100000","0101101000","0101110000","0101111000",
"0110000000","0110001000","0110010000","0110011000","0110100000","0110101000","0110110000","0110111000",
"0111000000","0111001000","0111010000","0111011000","0111100000","0111101000","0111110000","0111111000");

begin
	process(clk)
	begin
		if(clk' event and clk='1') then
			if(sel1 ='1' and sel2 ='1') then
				rom_adrs <= rom_adrs + 1;
			end if;
			if(sel1 ='0' and sel2 ='1') then
				rom_adrs <= rom_adrs + 2;
			end if;
			if(sel1 ='0' and sel2 ='0') then
				rom_adrs <= rom_adrs + 4; 
			end if;
			if(sel1 ='1' and sel2 ='0') then
				rom_adrs <= rom_adrs + 8; 
			end if;			
		end if;
	end process;

	process(clk,reset)
	begin
		if(reset='0') then
			rom_latch <= (others => '0');
		elsif(clk' event and clk='0') then
			rom_latch <= tri(conv_integer (rom_adrs));
		end if;
		tri0 <= rom_latch(0);
		tri1 <= rom_latch(1);
		tri2 <= rom_latch(2);
		tri3 <= rom_latch(3);
		tri4 <= rom_latch(4);
		tri5 <= rom_latch(5);
		tri6 <= rom_latch(6);
		tri7 <= rom_latch(7);
		tri8 <= rom_latch(8);
		tri9 <= rom_latch(9);
	end process;
end rtl;