-------------------------------------------------------
-- sine table 10bit + select
-- 2006/8/22 2015/10/3 2015/10/20
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sinetable10bitsel is
	port(
		clk		:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		reset	:in std_logic;
		sin0	:out std_logic;
		sin1	:out std_logic;
		sin2	:out std_logic;
		sin3	:out std_logic;
		sin4	:out std_logic;
		sin5	:out std_logic;
		sin6	:out std_logic;
		sin7	:out std_logic;
		sin8	:out std_logic;
		sin9	:out std_logic
	);
end sinetable10bitsel;

architecture rtl of sinetable10bitsel is
	signal rom_adrs	:std_logic_vector(7 downto 0);
	signal rom_latch:std_logic_vector(9 downto 0);
	
	subtype sine_wave is std_logic_vector(9 downto 0);
	type rom is array (0 to 255) of sine_wave;
	constant sine : rom := (
	"1000000000","1000001100","1000011001","1000100101","1000110010","1000111110","1001001011","1001010111",
	"1001100011","1001110000","1001111100","1010001000","1010010100","1010100000","1010101100","1010111000",
	"1011000011","1011001111","1011011010","1011100110","1011110001","1011111100","1100000111","1100010001",
	"1100011100","1100100110","1100110000","1100111010","1101000100","1101001110","1101010111","1101100001",
	"1101101010","1101110010","1101111011","1110000011","1110001011","1110010011","1110011011","1110100010",
	"1110101001","1110110000","1110110111","1110111101","1111000011","1111001001","1111001110","1111010100",
	"1111011001","1111011101","1111100010","1111100110","1111101001","1111101101","1111110000","1111110011",
	"1111110110","1111111000","1111111010","1111111100","1111111101","1111111110","1111111111","1111111111",
	"1111111111","1111111111","1111111111","1111111110","1111111101","1111111100","1111111010","1111111000",
	"1111110110","1111110011","1111110000","1111101101","1111101001","1111100110","1111100010","1111011101",
	"1111011001","1111010100","1111001110","1111001001","1111000011","1110111101","1110110111","1110110000",
	"1110101001","1110100010","1110011011","1110010011","1110001011","1110000011","1101111011","1101110010",
	"1101101010","1101100001","1101010111","1101001110","1101000100","1100111010","1100110000","1100100110",
	"1100011100","1100010001","1100000111","1011111100","1011110001","1011100110","1011011010","1011001111",
	"1011000011","1010111000","1010101100","1010100000","1010010100","1010001000","1001111100","1001110000",
	"1001100011","1001010111","1001001011","1000111110","1000110010","1000100101","1000011001","1000001100",
	"1000000000","0111110011","0111100110","0111011010","0111001101","0111000001","0110110100","0110101000",
	"0110011100","0110001111","0110000011","0101110111","0101101011","0101011111","0101010011","0101000111",
	"0100111100","0100110000","0100100101","0100011001","0100001110","0100000011","0011111000","0011101110",
	"0011100011","0011011001","0011001111","0011000101","0010111011","0010110001","0010101000","0010011110",
	"0010010101","0010001101","0010000100","0001111100","0001110100","0001101100","0001100100","0001011101",
	"0001010110","0001001111","0001001000","0001000010","0000111100","0000110110","0000110001","0000101011",
	"0000100110","0000100010","0000011101","0000011001","0000010110","0000010010","0000001111","0000001100",
	"0000001001","0000000111","0000000101","0000000011","0000000010","0000000001","0000000000","0000000000",
	"0000000000","0000000000","0000000000","0000000001","0000000010","0000000011","0000000101","0000000111",
	"0000001001","0000001100","0000001111","0000010010","0000010110","0000011001","0000011101","0000100010",
	"0000100110","0000101011","0000110001","0000110110","0000111100","0001000010","0001001000","0001001111",
	"0001010110","0001011101","0001100100","0001101100","0001110100","0001111100","0010000100","0010001101",
	"0010010101","0010011110","0010101000","0010110001","0010111011","0011000101","0011001111","0011011001",
	"0011100011","0011101110","0011111000","0100000011","0100001110","0100011001","0100100101","0100110000",
	"0100111100","0101000111","0101010011","0101011111","0101101011","0101110111","0110000011","0110001111",
	"0110011100","0110101000","0110110100","0111000001","0111001101","0111011010","0111100110","0111110011");

begin
	process(clk)
	begin
		if(clk' event and clk='1') then
			if(sel1 ='1' and sel2 ='1') then
				rom_adrs <= rom_adrs + 1;
			end if;
			if(sel1 ='0' and sel2 ='1') then
				rom_adrs <= rom_adrs + 2;
			end if;
			if(sel1 ='0' and sel2 ='0') then
				rom_adrs <= rom_adrs + 4; 
			end if;
			if(sel1 ='1' and sel2 ='0') then
				rom_adrs <= rom_adrs + 8;
			end if;
		end if;
	end process;

	process(clk,reset)
	begin
		if(reset='0') then
			rom_latch <= (others => '0');
		elsif(clk' event and clk='0') then
			rom_latch <= sine(conv_integer (rom_adrs));
		end if;
		sin0 <= rom_latch(0);
		sin1 <= rom_latch(1);
		sin2 <= rom_latch(2);
		sin3 <= rom_latch(3);
		sin4 <= rom_latch(4);
		sin5 <= rom_latch(5);
		sin6 <= rom_latch(6);
		sin7 <= rom_latch(7);
		sin8 <= rom_latch(8);
		sin9 <= rom_latch(9);
	end process;
end rtl;