-------------------------------------------------------
-- 4bit x 5 to 1 select
-- 2006/6/21
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sel5to1 is
	port(
		a0		:in std_logic;
		b0		:in std_logic;
		c0		:in std_logic;
		d0		:in std_logic;
		a1		:in std_logic;
		b1		:in std_logic;
		c1		:in std_logic;
		d1		:in std_logic;
		a2		:in std_logic;
		b2		:in std_logic;
		c2		:in std_logic;
		d2		:in std_logic;
		a3		:in std_logic;
		b3		:in std_logic;
		c3		:in std_logic;
		d3		:in std_logic;
		a4		:in std_logic;
		b4		:in std_logic;
		c4		:in std_logic;
		d4		:in std_logic;
		sel0	:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		sel3	:in std_logic;
		sel4	:in std_logic;
		outa	:out std_logic;
		outb	:out std_logic;
		outc	:out std_logic;
		outd	:out std_logic
		);
end sel5to1;

architecture rtl of sel5to1 is
	signal input_t0		:std_logic_vector(3 downto 0);
	signal input_t1		:std_logic_vector(3 downto 0);
	signal input_t2		:std_logic_vector(3 downto 0);
	signal input_t3		:std_logic_vector(3 downto 0);
	signal input_t4		:std_logic_vector(3 downto 0);
	signal input_sel	:std_logic_vector(4 downto 0);
	signal output_table	:std_logic_vector(3 downto 0);
	
begin
	input_t0 <= d0 & c0 & b0 & a0;
	input_t1 <= d1 & c1 & b1 & a1;
	input_t2 <= d2 & c2 & b2 & a2;
	input_t3 <= d3 & c3 & b3 & a3;
	input_t4 <= d4 & c4 & b4 & a4;
	input_sel <= sel4 & sel3 & sel2 & sel1 & sel0;
	
	with input_sel select
		output_table <= input_t0 when "00001",	-- sel0
						input_t1 when "00010",	-- sel1
						input_t2 when "00100",	-- sel2
						input_t3 when "01000",	-- sel3
						input_t4 when "10000",	-- sel4
						"0000" when others;
						
	outa <= output_table(0);
	outb <= output_table(1);
	outc <= output_table(2);
	outd <= output_table(3);

end rtl;	
		