-------------------------------------------------------
-- 24bit to 8bit select
-- 2011/4/23
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sel24to8 is
	port(
		sel0	:in std_logic;
		sel1	:in std_logic;
		a0		:in std_logic;
		b0		:in std_logic;
		c0		:in std_logic;
		d0		:in std_logic;
		a1		:in std_logic;
		b1		:in std_logic;
		c1		:in std_logic;
		d1		:in std_logic;
		a2		:in std_logic;
		b2		:in std_logic;
		c2		:in std_logic;
		d2		:in std_logic;
		a3		:in std_logic;
		b3		:in std_logic;
		c3		:in std_logic;
		d3		:in std_logic;
		a4		:in std_logic;
		b4		:in std_logic;
		c4		:in std_logic;
		d4		:in std_logic;
		a5		:in std_logic;
		b5		:in std_logic;
		c5		:in std_logic;
		d5		:in std_logic;				
		outa	:out std_logic;
		outb	:out std_logic;
		outc	:out std_logic;
		outd	:out std_logic;
		oute	:out std_logic;
		outf	:out std_logic;
		outg	:out std_logic;
		outh	:out std_logic
		);
end sel24to8;

architecture rtl of sel24to8 is
	signal input_t0		:std_logic_vector(7 downto 0);
	signal input_t1		:std_logic_vector(7 downto 0);
	signal input_t2		:std_logic_vector(7 downto 0);
	signal input_sel	:std_logic_vector(1 downto 0);
	signal output_table	:std_logic_vector(7 downto 0);
	
begin
	input_t0 <= d1 & c1 & b1 & a1 & d0 & c0 & b0 & a0;
	input_t1 <= d3 & c3 & b3 & a3 & d2 & c2 & b2 & a2;
	input_t2 <= d5 & c5 & b5 & a5 & d4 & c4 & b4 & a4;
	input_sel <= sel1 & sel0;
	
	with input_sel select
		output_table <= input_t0 when "01",
						input_t1 when "10",
						input_t2 when "11",
						"00000000" when others;
						
	outa <= output_table(0);
	outb <= output_table(1);
	outc <= output_table(2);
	outd <= output_table(3);
	oute <= output_table(4);
	outf <= output_table(5);
	outg <= output_table(6);
	outh <= output_table(7);

end rtl;	
		