-------------------------------------------------------
-- 24bit x 2 to 1 select
-- 2016/6/18
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sel24bit2to1n is
	port(
		a0		:in std_logic;
		a1		:in std_logic;
		a2		:in std_logic;
		a3		:in std_logic;
		a4		:in std_logic;
		a5		:in std_logic;
		a6		:in std_logic;
		a7		:in std_logic;
		a8		:in std_logic;
		a9		:in std_logic;
		a10		:in std_logic;
		a11		:in std_logic;
		a12		:in std_logic;
		a13		:in std_logic;
		a14		:in std_logic;
		a15		:in std_logic;
		a16		:in std_logic;
		a17		:in std_logic;
		a18		:in std_logic;
		a19		:in std_logic;
		a20		:in std_logic;
		a21		:in std_logic;
		a22		:in std_logic;
		a23		:in std_logic;
		b0		:in std_logic;
		b1		:in std_logic;
		b2		:in std_logic;
		b3		:in std_logic;
		b4		:in std_logic;
		b5		:in std_logic;
		b6		:in std_logic;
		b7		:in std_logic;
		b8		:in std_logic;
		b9		:in std_logic;
		b10		:in std_logic;
		b11		:in std_logic;
		b12		:in std_logic;
		b13		:in std_logic;
		b14		:in std_logic;
		b15		:in std_logic;
		b16		:in std_logic;
		b17		:in std_logic;
		b18		:in std_logic;
		b19		:in std_logic;
		b20		:in std_logic;
		b21		:in std_logic;
		b22		:in std_logic;
		b23		:in std_logic;
		sel0		:in std_logic;
		sel1		:in std_logic;
		out0	:out std_logic;
		out1	:out std_logic;
		out2	:out std_logic;
		out3	:out std_logic;
		out4	:out std_logic;
		out5	:out std_logic;
		out6	:out std_logic;
		out7	:out std_logic;
		out8	:out std_logic;
		out9	:out std_logic;
		out10	:out std_logic;
		out11	:out std_logic;
		out12	:out std_logic;
		out13	:out std_logic;
		out14	:out std_logic;
		out15	:out std_logic;
		out16	:out std_logic;
		out17	:out std_logic;
		out18	:out std_logic;
		out19	:out std_logic;
		out20	:out std_logic;
		out21	:out std_logic;
		out22	:out std_logic;
		out23	:out std_logic
		);
end sel24bit2to1n;

architecture rtl of sel24bit2to1n is
	signal input_a			:std_logic_vector(23 downto 0);
	signal input_b			:std_logic_vector(23 downto 0);
	signal input_sel		:std_logic_vector(1 downto 0);
	signal output_table	:std_logic_vector(23 downto 0);
	
begin
	input_a <= a23 & a22 & a21 & a20 & a19 & a18 & a17 & a16 & a15 & a14 & a13 & a12 & a11 & a10 & a9 & a8 & a7 & a6 & a5 & a4 & a3 & a2 & a1 & a0;
	input_b <= b23 & b22 & b21 & b20 & b19 & b18 & b17 & b16 & b15 & b14 & b13 & b12 & b11 & b10 & b9 & b8 & b7 & b6 & b5 & b4 & b3 & b2 & b1 & b0;
	input_sel <= sel1 & sel0;	
	
	with input_sel select
		output_table <= 	input_a when "00",	-- sel0
								input_b when "01",	-- sel1
						"000000000000000000000000" when others;
						
	out0 <= output_table(0);
	out1 <= output_table(1);
	out2 <= output_table(2);
	out3 <= output_table(3);
	out4 <= output_table(4);
	out5 <= output_table(5);
	out6 <= output_table(6);
	out7 <= output_table(7);
	out8 <= output_table(8);
	out9 <= output_table(9);
	out10 <= output_table(10);
	out11 <= output_table(11);
	out12 <= output_table(12);
	out13 <= output_table(13);
	out14 <= output_table(14);
	out15 <= output_table(15);
	out16 <= output_table(16);
	out17 <= output_table(17);
	out18 <= output_table(18);
	out19 <= output_table(19);
	out20 <= output_table(20);
	out21 <= output_table(21);
	out22 <= output_table(22);
	out23 <= output_table(23);	
	
end rtl;	
		