-------------------------------------------------------
-- 10bit x 8 to 1 select
-- 2016/5/13
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sel10bit8to1 is
	port(
		a0		:in std_logic;
		a1		:in std_logic;
		a2		:in std_logic;
		a3		:in std_logic;
		a4		:in std_logic;
		a5		:in std_logic;
		a6		:in std_logic;
		a7		:in std_logic;
		a8		:in std_logic;
		a9		:in std_logic;
		b0		:in std_logic;
		b1		:in std_logic;
		b2		:in std_logic;
		b3		:in std_logic;
		b4		:in std_logic;
		b5		:in std_logic;
		b6		:in std_logic;
		b7		:in std_logic;
		b8		:in std_logic;
		b9		:in std_logic;
		c0		:in std_logic;
		c1		:in std_logic;
		c2		:in std_logic;
		c3		:in std_logic;
		c4		:in std_logic;
		c5		:in std_logic;
		c6		:in std_logic;
		c7		:in std_logic;
		c8		:in std_logic;
		c9		:in std_logic;
		d0		:in std_logic;
		d1		:in std_logic;
		d2		:in std_logic;
		d3		:in std_logic;
		d4		:in std_logic;
		d5		:in std_logic;
		d6		:in std_logic;
		d7		:in std_logic;
		d8		:in std_logic;
		d9		:in std_logic;
		e0		:in std_logic;
		e1		:in std_logic;
		e2		:in std_logic;
		e3		:in std_logic;
		e4		:in std_logic;
		e5		:in std_logic;
		e6		:in std_logic;
		e7		:in std_logic;
		e8		:in std_logic;
		e9		:in std_logic;
		f0		:in std_logic;
		f1		:in std_logic;
		f2		:in std_logic;
		f3		:in std_logic;
		f4		:in std_logic;
		f5		:in std_logic;
		f6		:in std_logic;
		f7		:in std_logic;
		f8		:in std_logic;
		f9		:in std_logic;		
		g0		:in std_logic;
		g1		:in std_logic;
		g2		:in std_logic;
		g3		:in std_logic;
		g4		:in std_logic;
		g5		:in std_logic;
		g6		:in std_logic;
		g7		:in std_logic;
		g8		:in std_logic;
		g9		:in std_logic;		
		h0		:in std_logic;
		h1		:in std_logic;
		h2		:in std_logic;
		h3		:in std_logic;
		h4		:in std_logic;
		h5		:in std_logic;
		h6		:in std_logic;
		h7		:in std_logic;
		h8		:in std_logic;
		h9		:in std_logic;		
		sel0	:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		sel3	:in std_logic;
		sel4	:in std_logic;
		sel5	:in std_logic;
		sel6	:in std_logic;
		sel7	:in std_logic;
		out0	:out std_logic;
		out1	:out std_logic;
		out2	:out std_logic;
		out3	:out std_logic;
		out4	:out std_logic;
		out5	:out std_logic;
		out6	:out std_logic;
		out7	:out std_logic;
		out8	:out std_logic;
		out9	:out std_logic
		);
end sel10bit8to1;

architecture rtl of sel10bit8to1 is
	signal input_a			:std_logic_vector(9 downto 0);
	signal input_b			:std_logic_vector(9 downto 0);
	signal input_c			:std_logic_vector(9 downto 0);
	signal input_d			:std_logic_vector(9 downto 0);
	signal input_e			:std_logic_vector(9 downto 0);
	signal input_f			:std_logic_vector(9 downto 0);
	signal input_g			:std_logic_vector(9 downto 0);
	signal input_h			:std_logic_vector(9 downto 0);	
	signal input_sel		:std_logic_vector(7 downto 0);
	signal output_table	:std_logic_vector(9 downto 0);
	
begin
	input_a <= a9 & a8 & a7 & a6 & a5 & a4 & a3 & a2 & a1 & a0;
	input_b <= b9 & b8 & b7 & b6 & b5 & b4 & b3 & b2 & b1 & b0;
	input_c <= c9 & c8 & c7 & c6 & c5 & c4 & c3 & c2 & c1 & c0;
	input_d <= d9 & d8 & d7 & d6 & d5 & d4 & d3 & d2 & d1 & d0;
	input_e <= e9 & e8 & e7 & e6 & e5 & e4 & e3 & e2 & e1 & e0;
	input_f <= f9 & f8 & f7 & f6 & f5 & f4 & f3 & f2 & f1 & f0;
	input_g <= g9 & g8 & g7 & g6 & g5 & g4 & g3 & g2 & g1 & g0;
	input_h <= h9 & h8 & h7 & h6 & h5 & h4 & h3 & h2 & h1 & h0;	
	input_sel <= sel7 & sel6 & sel5 & sel4 & sel3 & sel2 & sel1 & sel0;
	
	with input_sel select
		output_table <= 	input_a when "00000001",	-- sel0
								input_b when "00000010",	-- sel1
								input_c when "00000100",	-- sel2
								input_d when "00001000",	-- sel3
								input_e when "00010000",	-- sel4
								input_f when "00100000",	-- sel5
								input_g when "01000000",	-- sel6
								input_h when "10000000",	-- sel7								
						"0000000000" when others;
						
	out0 <= output_table(0);
	out1 <= output_table(1);
	out2 <= output_table(2);
	out3 <= output_table(3);
	out4 <= output_table(4);
	out5 <= output_table(5);
	out6 <= output_table(6);
	out7 <= output_table(7);
	out8 <= output_table(8);
	out9 <= output_table(9);

end rtl;	
		