-------------------------------------------------------
-- 10bit x 3 to 1 select add sq
-- 2016/7/3
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sel10bit3to1naddsq is
	port(
		a0		:in std_logic;
		a1		:in std_logic;
		a2		:in std_logic;
		a3		:in std_logic;
		a4		:in std_logic;
		a5		:in std_logic;
		a6		:in std_logic;
		a7		:in std_logic;
		a8		:in std_logic;
		a9		:in std_logic;
		b0		:in std_logic;
		b1		:in std_logic;
		b2		:in std_logic;
		b3		:in std_logic;
		b4		:in std_logic;
		b5		:in std_logic;
		b6		:in std_logic;
		b7		:in std_logic;
		b8		:in std_logic;
		b9		:in std_logic;
		c0		:in std_logic;
		c1		:in std_logic;
		c2		:in std_logic;
		c3		:in std_logic;
		c4		:in std_logic;
		c5		:in std_logic;
		c6		:in std_logic;
		c7		:in std_logic;
		c8		:in std_logic;
		c9		:in std_logic;
		sel0	:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		selsq	:in std_logic;
		out0	:out std_logic;
		out1	:out std_logic;
		out2	:out std_logic;
		out3	:out std_logic;
		out4	:out std_logic;
		out5	:out std_logic;
		out6	:out std_logic;
		out7	:out std_logic;
		out8	:out std_logic;
		out9	:out std_logic
		);
end sel10bit3to1naddsq;

architecture rtl of sel10bit3to1naddsq is
	signal input_a			:std_logic_vector(9 downto 0);
	signal input_b			:std_logic_vector(9 downto 0);
	signal input_c			:std_logic_vector(9 downto 0);
	signal input_sel		:std_logic_vector(3 downto 0);
	signal output_table	:std_logic_vector(9 downto 0);
	
begin
	input_a <= a9 & a8 & a7 & a6 & a5 & a4 & a3 & a2 & a1 & a0;
	input_b <= b9 & b8 & b7 & b6 & b5 & b4 & b3 & b2 & b1 & b0;
	input_c <= c9 & c8 & c7 & c6 & c5 & c4 & c3 & c2 & c1 & c0;
	input_sel <= selsq & sel2 & sel1 & sel0;
	
	with input_sel select
		output_table <= 	input_a when "0001",	-- sel0
								input_a when "1001", -- sel0
								input_b when "0010",	-- sel1
								input_b when "1010", -- sel1
								input_c when "0100",	-- sel2
								input_c when "1100", -- sel2
								"0000000000" when "0000", -- selsq
								"1111111111" when "1000", -- selsq
								"0000000000" when others;
						
	out0 <= output_table(0);
	out1 <= output_table(1);
	out2 <= output_table(2);
	out3 <= output_table(3);
	out4 <= output_table(4);
	out5 <= output_table(5);
	out6 <= output_table(6);
	out7 <= output_table(7);
	out8 <= output_table(8);
	out9 <= output_table(9);

end rtl;	
		