-------------------------------------------------------
-- saw table 10bit + select
-- 2016/6/12
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity sawtable10bitsel is
	port(
		clk		:in std_logic;
		sel1	:in std_logic;
		sel2	:in std_logic;
		reset	:in std_logic;
		saw0	:out std_logic;
		saw1	:out std_logic;
		saw2	:out std_logic;
		saw3	:out std_logic;
		saw4	:out std_logic;
		saw5	:out std_logic;
		saw6	:out std_logic;
		saw7	:out std_logic;
		saw8	:out std_logic;
		saw9	:out std_logic
	);
end sawtable10bitsel;

architecture rtl of sawtable10bitsel is
	signal rom_adrs	:std_logic_vector(7 downto 0);
	signal rom_latch:std_logic_vector(9 downto 0);
	
	subtype saw_wave is std_logic_vector(9 downto 0);
	type rom is array (0 to 255) of saw_wave;
	constant saw : rom := (
"1000000000","1000000100","1000001000","1000001100","1000010000","1000010100","1000011000","1000011100",
"1000100000","1000100100","1000101000","1000101100","1000110000","1000110100","1000111000","1000111100",
"1001000000","1001000100","1001001000","1001001100","1001010000","1001010100","1001011000","1001011100",
"1001100000","1001100100","1001101000","1001101100","1001110000","1001110100","1001111000","1001111100",
"1010000000","1010000100","1010001000","1010001100","1010010000","1010010100","1010011000","1010011100",
"1010100000","1010100100","1010101000","1010101100","1010110000","1010110100","1010111000","1010111100",
"1011000000","1011000100","1011001000","1011001100","1011010000","1011010100","1011011000","1011011100",
"1011100000","1011100100","1011101000","1011101100","1011110000","1011110100","1011111000","1011111100",
"1100000000","1100000100","1100001000","1100001100","1100010000","1100010100","1100011000","1100011100",
"1100100000","1100100100","1100101000","1100101100","1100110000","1100110100","1100111000","1100111100",
"1101000000","1101000100","1101001000","1101001100","1101010000","1101010100","1101011000","1101011100",
"1101100000","1101100100","1101101000","1101101100","1101110000","1101110100","1101111000","1101111100",
"1110000000","1110000100","1110001000","1110001100","1110010000","1110010100","1110011000","1110011100",
"1110100000","1110100100","1110101000","1110101100","1110110000","1110110100","1110111000","1110111100",
"1111000000","1111000100","1111001000","1111001100","1111010000","1111010100","1111011000","1111011100",
"1111100000","1111100100","1111101000","1111101100","1111110000","1111110100","1111111000","1111111100",
"0000000000","0000000100","0000001000","0000001100","0000010000","0000010100","0000011000","0000011100",
"0000100000","0000100100","0000101000","0000101100","0000110000","0000110100","0000111000","0000111100",
"0001000000","0001000100","0001001000","0001001100","0001010000","0001010100","0001011000","0001011100",
"0001100000","0001100100","0001101000","0001101100","0001110000","0001110100","0001111000","0001111100",
"0010000000","0010000100","0010001000","0010001100","0010010000","0010010100","0010011000","0010011100",
"0010100000","0010100100","0010101000","0010101100","0010110000","0010110100","0010111000","0010111100",
"0011000000","0011000100","0011001000","0011001100","0011010000","0011010100","0011011000","0011011100",
"0011100000","0011100100","0011101000","0011101100","0011110000","0011110100","0011111000","0011111100",
"0100000000","0100000100","0100001000","0100001100","0100010000","0100010100","0100011000","0100011100",
"0100100000","0100100100","0100101000","0100101100","0100110000","0100110100","0100111000","0100111100",
"0101000000","0101000100","0101001000","0101001100","0101010000","0101010100","0101011000","0101011100",
"0101100000","0101100100","0101101000","0101101100","0101110000","0101110100","0101111000","0101111100",
"0110000000","0110000100","0110001000","0110001100","0110010000","0110010100","0110011000","0110011100",
"0110100000","0110100100","0110101000","0110101100","0110110000","0110110100","0110111000","0110111100",
"0111000000","0111000100","0111001000","0111001100","0111010000","0111010100","0111011000","0111011100",
"0111100000","0111100100","0111101000","0111101100","0111110000","0111110100","0111111000","0111111100");

begin
	process(clk)
	begin
		if(clk' event and clk='1') then
			if(sel1 ='1' and sel2 ='1') then
				rom_adrs <= rom_adrs + 1;
			end if;
			if(sel1 ='0' and sel2 ='1') then
				rom_adrs <= rom_adrs + 2;
			end if;
			if(sel1 ='0' and sel2 ='0') then
				rom_adrs <= rom_adrs + 4; 
			end if;
			if(sel1 ='1' and sel2 ='0') then
				rom_adrs <= rom_adrs + 8; 
			end if;			
		end if;
	end process;

	process(clk,reset)
	begin
		if(reset='0') then
			rom_latch <= (others => '0');
		elsif(clk' event and clk='0') then
			rom_latch <= saw(conv_integer (rom_adrs));
		end if;
		saw0 <= rom_latch(0);
		saw1 <= rom_latch(1);
		saw2 <= rom_latch(2);
		saw3 <= rom_latch(3);
		saw4 <= rom_latch(4);
		saw5 <= rom_latch(5);
		saw6 <= rom_latch(6);
		saw7 <= rom_latch(7);
		saw8 <= rom_latch(8);
		saw9 <= rom_latch(9);
	end process;
end rtl;