-------------------------------------------------------
-- 6bit point set 2 hi next
-- 2016/6/18
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity point6bitset2hinext is
	port(
		in0			:in std_logic;
		in1			:in std_logic;
		in2			:in std_logic;
		in3			:in std_logic;
		in4			:in std_logic;
		in5			:in std_logic;
		sel1		:in std_logic;
		sel2		:in std_logic;
		sel3		:in std_logic;
		sel4		:in std_logic;
		sel5		:in std_logic;
		pointout	:out std_logic
	);
end point6bitset2hinext;

architecture rtl of point6bitset2hinext is
	signal output_table	:std_logic_vector(5 downto 0);
	signal input_sel	:std_logic_vector(4 downto 0);
begin

	input_sel <= sel5 & sel4 &sel3 & sel2 & sel1;

	with input_sel select
		output_table <= "100100" when "00100",
						"001001" when "00010",
						"010010" when "00001",
						"001000"	when "01100",
						"001000"	when "01010",
						"001000" when "01001",
						"001000"	when "01000",
						"000000" when others;
	
	pointout <= (in0 and output_table(5)) or 
				(in1 and output_table(4)) or
				(in2 and output_table(3)) or
				(in3 and output_table(2)) or
				(in4 and output_table(1)) or
				(in5 and output_table(0));
end rtl;