-------------------------------------------------------
-- 6bit point set 2 hi
-- 2007/12/8 2015/10/15
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity point6bitset2hi is
	port(
		in0			:in std_logic;
		in1			:in std_logic;
		in2			:in std_logic;
		in3			:in std_logic;
		in4			:in std_logic;
		in5			:in std_logic;
		sel1		:in std_logic;
		sel2		:in std_logic;
		sel3		:in std_logic;
		pointout	:out std_logic
	);
end point6bitset2hi;

architecture rtl of point6bitset2hi is
	signal output_table	:std_logic_vector(5 downto 0);
	signal input_sel	:std_logic_vector(2 downto 0);
begin

	input_sel <= sel3 & sel2 & sel1;

	with input_sel select
		output_table <= "100100" when "100",
						"001001" when "010",
						"010010" when "001",
						"000000" when others;
	
	pointout <= (in0 and output_table(5)) or 
				(in1 and output_table(4)) or
				(in2 and output_table(3)) or
				(in3 and output_table(2)) or
				(in4 and output_table(1)) or
				(in5 and output_table(0));
end rtl;