-------------------------------------------------------
-- 6bit point set
-- 2006/7/25
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity point6bitset is
	port(
		in0			:in std_logic;
		in1			:in std_logic;
		in2			:in std_logic;
		in3			:in std_logic;
		in4			:in std_logic;
		in5			:in std_logic;
		sel			:in std_logic;
		pointout	:out std_logic
	);
end point6bitset;

architecture rtl of point6bitset is
	signal output_table	:std_logic_vector(5 downto 0);

begin

	with sel select
		output_table <= "011011" when '1',
						"110110" when '0',
						"111111" when others;
	
	pointout <= (in0 and output_table(5)) or 
				(in1 and output_table(4)) or
				(in2 and output_table(3)) or
				(in3 and output_table(2)) or
				(in4 and output_table(1)) or
				(in5 and output_table(0));
end rtl;