-------------------------------------------------------
-- 16bit latch
-- 2006/9/10
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity latch16bit is
	port(
		latch		:in std_logic;
		in0			:in std_logic;
		in1			:in std_logic;
		in2			:in std_logic;
		in3			:in std_logic;
		in4			:in std_logic;
		in5			:in std_logic;
		in6			:in std_logic;
		in7			:in std_logic;
		in8			:in std_logic;
		in9			:in std_logic;
		in10		:in std_logic;
		in11		:in std_logic;
		in12		:in std_logic;
		in13		:in std_logic;
		in14		:in std_logic;
		in15		:in std_logic;
		out0		:out std_logic;
		out1		:out std_logic;
		out2		:out std_logic;
		out3		:out std_logic;
		out4		:out std_logic;
		out5		:out std_logic;
		out6		:out std_logic;
		out7		:out std_logic;
		out8		:out std_logic;
		out9		:out std_logic;
		out10		:out std_logic;
		out11		:out std_logic;
		out12		:out std_logic;
		out13		:out std_logic;
		out14		:out std_logic;
		out15		:out std_logic
		);
end latch16bit;

architecture rtl of latch16bit is
	signal output_table	:std_logic_vector(15 downto 0);
	
begin
	process (latch)
	begin
		if (latch' event and latch ='1') then
			output_table(0) <= in0;
			output_table(1) <= in1;
			output_table(2) <= in2;
			output_table(3) <= in3;
			output_table(4) <= in4;
			output_table(5) <= in5;
			output_table(6) <= in6;
			output_table(7) <= in7;
			output_table(8) <= in8;
			output_table(9) <= in9;
			output_table(10) <= in10;
			output_table(11) <= in11;
			output_table(12) <= in12;
			output_table(13) <= in13;
			output_table(14) <= in14;
			output_table(15) <= in15;
		end if;
	end process;

		out0 <= output_table(0);
		out1 <= output_table(1);
		out2 <= output_table(2);
		out3 <= output_table(3);
		out4 <= output_table(4);
		out5 <= output_table(5);
		out6 <= output_table(6);
		out7 <= output_table(7);
		out8 <= output_table(8);
		out9 <= output_table(9);
		out10 <= output_table(10);
		out11 <= output_table(11);
		out12 <= output_table(12);
		out13 <= output_table(13);
		out14 <= output_table(14);
		out15 <= output_table(15);

end rtl;	
		