-------------------------------------------------------
-- 10bit latch
-- 2006/10/5
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity latch10bit is
	port(
		latch		:in std_logic;
		in0			:in std_logic;
		in1			:in std_logic;
		in2			:in std_logic;
		in3			:in std_logic;
		in4			:in std_logic;
		in5			:in std_logic;
		in6			:in std_logic;
		in7			:in std_logic;
		in8			:in std_logic;
		in9			:in std_logic;
		out0		:out std_logic;
		out1		:out std_logic;
		out2		:out std_logic;
		out3		:out std_logic;
		out4		:out std_logic;
		out5		:out std_logic;
		out6		:out std_logic;
		out7		:out std_logic;
		out8		:out std_logic;
		out9		:out std_logic
		);
end latch10bit;

architecture rtl of latch10bit is
	signal output_table	:std_logic_vector(9 downto 0);
	
begin
	process (latch)
	begin
		if (latch' event and latch ='1') then
			output_table(0) <= in0;
			output_table(1) <= in1;
			output_table(2) <= in2;
			output_table(3) <= in3;
			output_table(4) <= in4;
			output_table(5) <= in5;
			output_table(6) <= in6;
			output_table(7) <= in7;
			output_table(8) <= in8;
			output_table(9) <= in9;
		end if;
	end process;

		out0 <= output_table(0);
		out1 <= output_table(1);
		out2 <= output_table(2);
		out3 <= output_table(3);
		out4 <= output_table(4);
		out5 <= output_table(5);
		out6 <= output_table(6);
		out7 <= output_table(7);
		out8 <= output_table(8);
		out9 <= output_table(9);

end rtl;	
		