-------------------------------------------------------
-- dp led select
-- 2006/6/15
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity dpsel is
	port(
		a		:in std_logic;
		b		:in std_logic;
		c		:in std_logic;
		dp_1	:out std_logic;
		dp_2	:out std_logic;
		dp_3	:out std_logic;
		dp_4	:out std_logic;
		dp_5	:out std_logic;
		dp_6	:out std_logic
		);
end dpsel;

architecture rtl of dpsel is
	signal input_table	:std_logic_vector(2 downto 0);
	signal output_table	:std_logic_vector(5 downto 0);
	
begin

	input_table <=  c & b & a;

	with input_table select
		output_table <= "010010" when "001",
						"100100" when "010",
						"001000" when "100",
						"000000" when others;
						
	dp_1 <= output_table(0);
	dp_2 <= output_table(1);
	dp_3 <= output_table(2);
	dp_4 <= output_table(3);
	dp_5 <= output_table(4);
	dp_6 <= output_table(5);

end rtl;	
		