-------------------------------------------------------
-- decode 8 sel 1
-- 2016/5/15
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity decode8sel1 is
	port(
		a		:in std_logic;
		b		:in std_logic;
		c		:in std_logic;
		out_0	:out std_logic;
		out_1	:out std_logic;
		out_2	:out std_logic;
		out_3	:out std_logic;
		out_4	:out std_logic;
		out_5 :out std_logic;
		out_6	:out std_logic;
		out_7	:out std_logic
		);
end decode8sel1;

architecture rtl of decode8sel1 is
	signal input_table	:std_logic_vector(2 downto 0);
	signal output_table	:std_logic_vector(7 downto 0);
	
begin
	input_table <= c & b & a;
	with input_table select
		output_table <= "00000001" when "000",	-- 0
							 "00000010" when "001",	-- 1
							 "00000100" when "010",	-- 2
							 "00001000" when "011",	-- 3
							 "00010000" when "100",	-- 4
							 "00100000" when "101",	-- 5
							 "01000000" when "110",	-- 6
							 "10000000" when "111",	-- 7
							 "00000000" when others;
						
	out_0 <= output_table(0);
	out_1 <= output_table(1);
	out_2 <= output_table(2);
	out_3 <= output_table(3);
	out_4 <= output_table(4);
	out_5 <= output_table(5);
	out_6 <= output_table(6);
	out_7 <= output_table(7);

end rtl;	
		