-------------------------------------------------------
-- decode 7 segment invert f
-- 2006/7/18
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity decode7seginvf is
	port(
		a		:in std_logic;
		b		:in std_logic;
		c		:in std_logic;
		d		:in std_logic;
		led_a	:out std_logic;
		led_b	:out std_logic;
		led_c	:out std_logic;
		led_d	:out std_logic;
		led_e	:out std_logic;
		led_f	:out std_logic;
		led_g	:out std_logic
		);
end decode7seginvf;

architecture rtl of decode7seginvf is
	signal input_table	:std_logic_vector(3 downto 0);
	signal output_table	:std_logic_vector(6 downto 0);
	
begin
	input_table <= d & c & b & a;
	with input_table select
		output_table <= "0111111" when "0000",	-- 0
						"0000110" when "0001",	-- 1
						"1011011" when "0010",	-- 2
						"1001111" when "0011",	-- 3
						"1100110" when "0100",	-- 4
						"1101101" when "0101",	-- 5
						"1111101" when "0110",	-- 6
						"0100111" when "0111",	-- 7
						"1111111" when "1000",	-- 8
						"1101111" when "1001",	-- 9
						"1110111" when "1010",  -- a
						"1111100" when "1011",  -- b
						"0111001" when "1100",  -- c
						"1011110" when "1101",  -- d
						"1111001" when "1110",  -- e
						"1110001" when "1111",  -- f
						"0000000" when others;
						
	led_a <= not output_table(0);
	led_b <= not output_table(1);
	led_c <= not output_table(2);
	led_d <= not output_table(3);
	led_e <= not output_table(4);
	led_f <= not output_table(5);
	led_g <= not output_table(6);

end rtl;	
		