-------------------------------------------------------
-- decode 4 sel 1
-- 2016/6/4
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity decode4sel1 is
	port(
		a		:in std_logic;
		b		:in std_logic;
		out_0	:out std_logic;
		out_1	:out std_logic;
		out_2	:out std_logic;
		out_3	:out std_logic
		);
end decode4sel1;

architecture rtl of decode4sel1 is
	signal input_table	:std_logic_vector(1 downto 0);
	signal output_table	:std_logic_vector(3 downto 0);
	
begin
	input_table <= b & a;
	with input_table select
		output_table <= "0001" when "00",	-- 0
							 "1010" when "01",	-- 1
							 "1100" when "10",	-- 2
							 "1000" when "11",	-- 3
							 "0000" when others;
						
	out_0 <= output_table(0);
	out_1 <= output_table(1);
	out_2 <= output_table(2);
	out_3 <= output_table(3);

end rtl;	
		