-------------------------------------------------------
-- 16bit comparator
-- 2006/10/1
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity comparator16bit is
	port(
		ina12		:in std_logic;
		ina13		:in std_logic;
		ina14		:in std_logic;
		ina15		:in std_logic;
		ina8		:in std_logic;
		ina9		:in std_logic;
		ina10		:in std_logic;
		ina11		:in std_logic;
		ina4		:in std_logic;
		ina5		:in std_logic;
		ina6		:in std_logic;
		ina7		:in std_logic;
		ina0		:in std_logic;
		ina1		:in std_logic;
		ina2		:in std_logic;
		ina3		:in std_logic;
		inb0		:in std_logic;
		inb1		:in std_logic;
		inb2		:in std_logic;
		inb3		:in std_logic;
		inb4		:in std_logic;
		inb5		:in std_logic;
		inb6		:in std_logic;
		inb7		:in std_logic;
		inb8		:in std_logic;
		inb9		:in std_logic;
		inb10		:in std_logic;
		inb11		:in std_logic;
		inb12		:in std_logic;
		inb13		:in std_logic;
		inb14		:in std_logic;
		inb15		:in std_logic;
		outeq		:out std_logic;
		outla		:out std_logic;
		outlb		:out std_logic
		);
end comparator16bit;

architecture rtl of comparator16bit is
	signal inputa_table	:std_logic_vector(15 downto 0);
	signal inputb_table	:std_logic_vector(15 downto 0);
	
begin
	inputa_table <= ina15 & ina14 & ina13 & ina12 & ina11 & ina10 & ina9 & ina8 & 
					ina7 & ina6 & ina5 & ina4 & ina3 & ina2 & ina1 & ina0;
	inputb_table <= inb15 & inb14 & inb13 & inb12 & inb11 & inb10 & inb9 & inb8 &
					inb7 & inb6 & inb5 & inb4 & inb3 & inb2 & inb1 & inb0;	

	process (inputa_table , inputb_table)
	begin
		if (inputa_table > inputb_table) then
			outla <= '1'; outeq <= '0'; outlb <= '0';
		elsif (inputa_table < inputb_table ) then
			outla <= '0'; outeq <= '0'; outlb <= '1';
		else
			outla <= '0'; outeq <= '1'; outlb <= '0';
		end if;
	end process;

end rtl;	
		