-------------------------------------------------------
--bunshu latch 1/5
-- 2006/6/25
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshulatch is
	port(
		latchin		:in std_logic;
		latchout	:out std_logic
	);
end bunshulatch;

architecture rtl of bunshulatch is
	signal incounter	:std_logic_vector(2 downto 0);
	
	constant osc_clock	:std_logic_vector(2 downto 0)
		:= conv_std_logic_vector(5-1,3);

begin

	process(latchin)
	begin
		if(latchin' event and latchin ='1') then
			if(incounter = osc_clock) then
				incounter <= (others => '0');
				latchout <= '1';
			else
				incounter <= incounter + 1;
				latchout <= '0';
			end if;
		end if;
	end process;

end rtl;