-------------------------------------------------------
--bunshu counter 1/10 sel
-- 2006/6/5 2015/10/15
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshu5sel is
	port(
		clkin	:in std_logic;
		sel		:in std_logic;
		clkout	:out std_logic
	);
end bunshu5sel;

architecture rtl of bunshu5sel is
	signal incounter	:std_logic_vector(3 downto 0);
	
	constant osc_clock	:std_logic_vector(3 downto 0)
		:= conv_std_logic_vector(10-1,4);
	signal t_out		:std_logic;

begin

	process(clkin)
	begin
		if(clkin' event and clkin ='1') then
			if(incounter = osc_clock) then
				incounter <= (others => '0');
				t_out <= '1';
			else
				incounter <= incounter + 1;
				t_out <= '0';
			end if;
		end if;
	end process;
	
	clkout <= t_out when sel = '1' else clkin;
end rtl;