-------------------------------------------------------
--bunshu counter 1/2
-- 2016/5/5
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bunshu2 is
	port(
		clkin	:in std_logic;
		clkout	:out std_logic
	);
end bunshu2;

architecture rtl of bunshu2 is
	signal incounter	:std_logic_vector(1 downto 0);
	
	constant osc_clock	:std_logic_vector(1 downto 0)
		:= conv_std_logic_vector(2-1,2);

begin

	process(clkin)
	begin
		if(clkin' event and clkin ='1') then
			if(incounter = osc_clock) then
				incounter <= (others => '0');
				clkout <= '1';
			else
				incounter <= incounter + 1;
				clkout <= '0';
			end if;
		end if;
	end process;
end rtl;