-------------------------------------------------------
-- 3bit ring counter
-- 2016/5/5
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity bit3ring is
	port(
		clk		:in std_logic;
		reset	:in std_logic;
		q0		:out std_logic;
		q1		:out std_logic;
		q2		:out std_logic
	);
end bit3ring;

architecture rtl of bit3ring is
	signal bufq		:std_logic_vector(2 downto 0);

begin
	process(clk,reset)
	begin
		if(reset ='0') then
			bufq <= (others => '0');
			elsif(clk' event and clk='1') then
			bufq <= bufq(1 downto 0) & not (bufq(0) or bufq(1));
		end if;
	end process;
	
	q0 <= bufq(0);
	q1 <= bufq(1);
	q2 <= bufq(2);

end rtl;