-------------------------------------------------------
-- bcd 7 add
-- 2007/2/2
-------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity bcd7add is
	port(
		a0		:in std_logic;
		a1		:in std_logic;
		a2		:in std_logic;
		a3		:in std_logic;
		cy_in	:in std_logic;
		s0		:out std_logic;
		s1		:out std_logic;
		s2		:out std_logic;
		s3		:out std_logic;
		cy_out	:out std_logic
	);
end bcd7add;

architecture rtl of bcd7add is
	signal input_data	:std_logic_vector(4 downto 0);
	signal output_data	:std_logic_vector(4 downto 0);

begin
	input_data <= cy_in & a3 & a2 & a1 & a0;
	with input_data select
		output_data <= 	"01000" when "10000",
						"01001" when "10001",
						"10000" when "10010",
						"10001" when "10011",
						"10010" when "10100",
						"10011" when "10101",
						"10100" when "10110",
						"10101" when "10111",
						"10110" when "11000",
						"10111" when "11001",
						"00111" when "00000",
						"01000" when "00001",
						"01001" when "00010",
						"10000" when "00011",
						"10001" when "00100",
						"10010" when "00101",
						"10011" when "00110",
						"10100" when "00111",
						"10101" when "01000",
						"10110" when "01001",
						"00000" when others;
							
	s0 <= output_data(0);
	s1 <= output_data(1);
	s2 <= output_data(2);
	s3 <= output_data(3);
	cy_out <= output_data(4);

end rtl;