#define u32 unsigned long
#define u16 unsigned int
#define u8  unsigned char
#define i8  char

/*
//==================================================================
// General Commands
//==================================================================
*/

/* STATUS bits - Used by all methods */
#define STCINT  0x01
#define ASQINT  0x02
#define RDSINT  0x04
#define RSQINT  0x08
#define ERR     0x40
#define CTS     0x80

/* POWER_UP*/
#define POWER_UP                      0x01
#define POWER_UP_IN_FUNC_FMRX         0x00
/*
#define POWER_UP_IN_FUNC_AMRX         0x01
#define POWER_UP_IN_FUNC_FMTX         0x02
#define POWER_UP_IN_FUNC_WBRX         0x03
#define POWER_UP_IN_FUNC_QUERY        0x0F
#define POWER_UP_IN_PATCH             0x20
#define POWER_UP_IN_GPO2OEN           0x40
#define POWER_UP_IN_CTSIEN            0x80
*/
#define POWER_UP_IN_OPMODE_RX_ANALOG  0x05
/*
#define POWER_UP_IN_OPMODE_TX_ANALOG  0x50
*/
#define POWER_UP_IN_XOSCEN			  0x10

/* GET_REV */
#define GET_REV 0x10

/* POWER_DOWN */
#define POWER_DOWN 0x11

/* SET_PROPERTY */
#define SET_PROPERTY 0x12

/* GET_PROPERTY */
#define GET_PROPERTY 0x13

/* GET_INT_STATUS */
#define GET_INT_STATUS 0x14

/*
//==================================================================
// FM Receive Commands
//==================================================================
*/
/*// FM_TUNE_FREQ*/
#define FM_TUNE_FREQ 0x20

/*// FM_TUNE_STATUS*/
#define FM_TUNE_STATUS           0x22
#define FM_TUNE_STATUS_IN_INTACK 0x01
#define FM_TUNE_STATUS_IN_CANCEL 0x02
#define FM_TUNE_STATUS_OUT_VALID 0x01
#define FM_TUNE_STATUS_OUT_AFCRL 0x02
#define FM_TUNE_STATUS_OUT_BTLF  0x80

/*// FM_RSQ_STATUS*/
#define FM_RSQ_STATUS              0x23
#define FM_RSQ_STATUS_IN_INTACK    0x01
#define FM_RSQ_STATUS_OUT_RSSILINT 0x01
#define FM_RSQ_STATUS_OUT_RSSIHINT 0x02
#define FM_RSQ_STATUS_OUT_ASNRLINT 0x04
#define FM_RSQ_STATUS_OUT_ASNRHINT 0x08
#define FM_RSQ_STATUS_OUT_BLENDINT 0x80
#define FM_RSQ_STATUS_OUT_VALID    0x01
#define FM_RSQ_STATUS_OUT_AFCRL    0x02
#define FM_RSQ_STATUS_OUT_SMUTE    0x08
#define FM_RSQ_STATUS_OUT_PILOT    0x80
#define FM_RSQ_STATUS_OUT_STBLEND  0x7F

/*
//==================================================================
// FM Receive Properties
//==================================================================
*/
/*// FM_DEEMPHASIS*/
#define FM_DEEMPHASIS      0x1100
#define FM_DEEMPHASIS_MASK 0x0003
#define FM_DEEMPHASIS_SHFT 0

/*// FM_CHANNEL_FILTER*/
#define FM_CHANNEL_FILTER				0x1102
#define FM_CHANNEL_FILTER_WIDE			0x0001
#define FM_CHANNEL_FILTER_NARROW		0x0002
#define FM_CHANNEL_FILTER_NARROWER		0x0003
#define FM_CHANNEL_FILTER_NARROWEST		0x0004

/*// FM_BLEND_STEREO_THRESHOLD*/
#define FM_BLEND_STEREO_THRESHOLD      0x1105
#define FM_BLEND_STEREO_THRESHOLD_MASK 0x007F
#define FM_BLEND_STEREO_THRESHOLD_SHFT 0

/*// FM_BLEND_MONO_THRESHOLD*/
#define FM_BLEND_MONO_THRESHOLD      0x1106
#define FM_BLEND_MONO_THRESHOLD_MASK 0x007F
#define FM_BLEND_MONO_THRESHOLD_SHFT 0


/*// FM_MAX_TUNE_ERROR*/
#define FM_MAX_TUNE_ERROR      0x1108
#define FM_MAX_TUNE_ERROR_MASK 0x007F
#define FM_MAX_TUNE_ERROR_SHFT 0

/*// FM_RSQ_INT_SOURCE*/
#define FM_RSQ_INT_SOURCE               0x1200
#define FM_RSQ_INT_SOURCE_RSSILIEN_MASK 0x0001
#define FM_RSQ_INT_SOURCE_RSSIHIEN_MASK 0x0002
#define FM_RSQ_INT_SOURCE_ASNRLIEN_MASK 0x0004
#define FM_RSQ_INT_SOURCE_ASNRHIEN_MASK 0x0008
#define FM_RSQ_INT_SOURCE_BLENDIEN_MASK 0x0080
#define FM_RSQ_INT_SOURCE_RSSILIEN_SHFT 0
#define FM_RSQ_INT_SOURCE_RSSIHIEN_SHFT 1
#define FM_RSQ_INT_SOURCE_ASNRLIEN_SHFT 2
#define FM_RSQ_INT_SOURCE_ASNRHIEN_SHFT 3
#define FM_RSQ_INT_SOURCE_BLENDIEN_SHFT 7

/*// FM_RSQ_SNR_HI_THRESHOLD*/
#define FM_RSQ_SNR_HI_THRESHOLD      0x1201
#define FM_RSQ_SNR_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_SNR_LO_THRESHOLD*/
#define FM_RSQ_SNR_LO_THRESHOLD      0x1202
#define FM_RSQ_SNR_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_HI_THRESHOLD*/
#define FM_RSQ_RSSI_HI_THRESHOLD      0x1203
#define FM_RSQ_RSSI_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_LO_THRESHOLD*/
#define FM_RSQ_RSSI_LO_THRESHOLD      0x1204
#define FM_RSQ_RSSI_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_BLEND_THRESHOLD*/
#define FM_RSQ_BLEND_THRESHOLD            0x1207
#define FM_RSQ_BLEND_THRESHOLD_BLEND_MASK 0x007F
#define FM_RSQ_BLEND_THRESHOLD_PILOT_MASK 0x0080
#define FM_RSQ_BLEND_THRESHOLD_BLEND_SHFT 0
#define FM_RSQ_BLEND_THRESHOLD_PILOT_SHFT 7

/*// FM_SOFT_MUTE_RATE*/
#define FM_SOFT_MUTE_RATE      0x1300
#define FM_SOFT_MUTE_RATE_MASK 0x00FF
#define FM_SOFT_MUTE_RATE_SHFT 0

/*// FM_SOFT_MUTE_MAX_ATTENUATION*/
#define FM_SOFT_MUTE_MAX_ATTENUATION      0x1302
#define FM_SOFT_MUTE_MAX_ATTENUATION_MASK 0x001F
#define FM_SOFT_MUTE_MAX_ATTENUATION_SHFT 0

/*// FM_SOFT_MUTE_SNR_THRESHOLD*/
#define FM_SOFT_MUTE_SNR_THRESHOLD      0x1303
#define FM_SOFT_MUTE_SNR_THRESHOLD_MASK 0x000F
#define FM_SOFT_MUTE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_BAND_BOTTOM*/
#define FM_SEEK_BAND_BOTTOM 0x1400

/*// FM_SEEK_BAND_TOP*/
#define FM_SEEK_BAND_TOP 0x1401

/*// FM_SEEK_FREQ_SPACING*/
#define FM_SEEK_FREQ_SPACING      0x1402
#define FM_SEEK_FREQ_SPACING_MASK 0x001F
#define FM_SEEK_FREQ_SPACING_SHFT 0

/*// FM_SEEK_TUNE_SNR_THRESHOLD*/
#define FM_SEEK_TUNE_SNR_THRESHOLD      0x1403
#define FM_SEEK_TUNE_SNR_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_TUNE_RSSI_THRESHOLD*/
#define FM_SEEK_TUNE_RSSI_THRESHOLD      0x1404
#define FM_SEEK_TUNE_RSSI_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_RSSI_THRESHOLD_SHFT 0

/*// FM_RDS_CONFIG*/
#define FM_RDS_CONFIG             0x1502
#define FM_RDS_CONFIG_RDSEN_MASK  0x0001
#define FM_RDS_CONFIG_BLETHD_MASK 0x0300
#define FM_RDS_CONFIG_BLETHC_MASK 0x0C00
#define FM_RDS_CONFIG_BLETHB_MASK 0x3000
#define FM_RDS_CONFIG_BLETHA_MASK 0xC000
#define FM_RDS_CONFIG_RDSEN_SHFT  0
#define FM_RDS_CONFIG_BLETHD_SHFT 8
#define FM_RDS_CONFIG_BLETHC_SHFT 10
#define FM_RDS_CONFIG_BLETHB_SHFT 12
#define FM_RDS_CONFIG_BLETHA_SHFT 14

/*
//==================================================================
// General Receive Properties
//==================================================================
*/
/* RX_VOLUME */
#define RX_VOLUME      0x4000
#define RX_VOLUME_MASK 0x003F
#define RX_VOLUME_SHFT 0

/* RX_HARD_MUTE */
#define RX_HARD_MUTE 0x4001
#define RX_HARD_MUTE_RMUTE_MASK 0x0001
#define RX_HARD_MUTE_LMUTE_MASK 0x0002
#define RX_HARD_MUTE_RMUTE_SHFT 0
#define RX_HARD_MUTE_LMUTE_SHFT 1
/*
//==================================================================
// Bit Definitions for Properties
//==================================================================
*/
/*// FM_DEEMPH*/
#define FM_DEEMPH_75US 0x2
#define FM_DEEMPH_50US 0x1


/*
//-----------------------------------------------------------------------------
// Defines
//-----------------------------------------------------------------------------
*/
#define READ    1
#define WRITE   0

#define POWERUP_TIME 110    /* Powerup delay in milliseconds*/
#define GPO_IEN				 0x0001
#define GPO_IEN_STCIEN_MASK  0x0001


/*----------- Si47xx ----------*/
u8 si47xx_readStatus();
void si47xx_waitForCTS();
void si47xx_command(u8 cmd_size, u8 *cmd, u8 reply_size, u8 *reply);
u8 getIntStatus(void);
void si47xx_set_property(u16 propNumber, u16 propValue);
void si47xx_getPartInformation(void);
void si47xxFMRX_initialize(void);
/*void si47xxFMRX_set_volume(u8 volume);*/
/*void si47xxFMRX_mute(u8 mute);*/
static void fmTuneFreq(u16 frequency);
static void fmTuneStatus(u8 cancel, u8 intack);
/*static*/ void fmRsqStatus(void);
void	tune_sub(unsigned int fm_mhz);



