#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "si47xx_fm.h"
#include "hitec_c_i2c.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

u8  			cmd[8];
u8  			rsp[15];
u8  			RSSI;
u8  			STC;
u8  			BLTF;
u8  			AFCRL;
u8  			Valid;
u16 			Freq;
u8  			ASNR;
u16 			AntCap;

u8				partNumber;
char 			fwMajor;
char 			fwMinor;
u16 			patchID;
char			cmpMajor;
char			cmpMinor;
char			chipRev;

unsigned int	mhz_no;

/*---------------------MAIN-----------------------*/
void	main(void)
{

	port_init();

    __delay_ms(150);

	mhz_no=FREQ_INIT;

	I2CInit();	

	__delay_ms(1000);
    
	si47xxFMRX_initialize();
    si47xx_getPartInformation();

    si47xx_set_property(RX_HARD_MUTE, 0);
  	si47xx_set_property(RX_VOLUME, (u16)63 & RX_VOLUME_MASK);
  
	__delay_ms(1000);
   
 	tune_sub(mhz_no);
	
	__delay_ms(1000);

    SLEEP();
    
	while(1){

    }

}