/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.7
        Device            :  PIC16F18326
        Driver Version    :  2.00
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"
#include "mcc_generated_files/examples/i2c1_master_example.h"

#define     NS73M_ADR               0x66    //0xCC

#define     ON_AIR_LED              RA5

/*
                         Main application
 */
//--------------------------------------
void	wait_time(unsigned int time)
{
	while(time!=0){
		time--;
	}
}
//--------------------------------------
void	i2c_ns73m_write(unsigned char add,unsigned char data)
{
    I2C1_Write1ByteRegister(NS73M_ADR, add, data);
}
//-------------------------------------

void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();
    
    i2c_ns73m_write(0x0e,0x05);     // RESET
    wait_time(100);
    i2c_ns73m_write(0x01,0xb4);     //
    wait_time(100);
    i2c_ns73m_write(0x02,0x06);     //
    wait_time(100);
    i2c_ns73m_write(0x03,0xae);     // 89.2MHz
    wait_time(100);
    i2c_ns73m_write(0x04,0x2a);     // 89.2MHz
    wait_time(100);
    i2c_ns73m_write(0x08,0x1b);     //
    wait_time(100);
    i2c_ns73m_write(0x00,0x85);     //
    wait_time(100);
    
    __delay_ms(500);
    
    i2c_ns73m_write(0x0e,0x05);     // RESET
    wait_time(100);
    i2c_ns73m_write(0x06,0x1e);     //
    wait_time(100);
    
    __delay_ms(500);
    
    i2c_ns73m_write(0x00,0x81);     // PowerOn
    wait_time(100);

    ON_AIR_LED=1;
    SLEEP();
    
    while (1)
    {
        // Add your application code
        NOP();
    }
}
/**
 End of File
*/