#include <htc.h>
#include "hitec_c_i2c.h"
#include "user_define.h"
#include "si47xx_fm.h"

#define u32 unsigned long
#define u16 unsigned int
#define u8  unsigned char
#define i8  char


#define	RSTB				RC6

extern u8  			cmd[8];
extern u8  			rsp[15];
extern u8  			RSSI;
extern u8  			STC;
extern u8  			BLTF;
extern u8  			AFCRL;
extern u8  			Valid;
extern u16 			Freq;
extern u8  			ASNR;
extern u16 			AntCap;

extern u8			partNumber;
extern char 		fwMajor;
extern char 		fwMinor;
extern u16 			patchID;
extern char			cmpMajor;
extern char			cmpMinor;
extern char			chipRev;

struct {
	unsigned int PoweredUp : 1;
}Bit;


/*----------- Si47xx ----------*/
u8 si47xx_readStatus()
{
    u8 status;
   
 	i2c_radio_read(1,&status);
	__delay_us(500);
    return status;
}

void si47xx_waitForCTS()
{
    u16 i=1000;

    while (--i && !(si47xx_readStatus() & CTS))
    {
		__delay_us(500);
    }
}

void si47xx_command(u8 cmd_size, u8 *cmd, u8 reply_size, u8 *reply)
{
    si47xx_waitForCTS();
    i2c_radio_write(cmd_size, cmd);
	__delay_us(500);
    si47xx_waitForCTS();
    if(reply_size)
    {
		i2c_radio_read(reply_size, reply);
		__delay_us(500);
    }
}

u8 getIntStatus(void)
{
    u8  cmd[1] = {0};
    u8  rsp[1] = {0};

    cmd[0] = GET_INT_STATUS;
	si47xx_command(1, cmd, 1, rsp);
	return rsp[0];
}

void si47xx_set_property(u16 propNumber, u16 propValue)
{
    cmd[0] = SET_PROPERTY;
    cmd[1] = 0;
    cmd[2] = (u8)(propNumber >> 8);
	cmd[3] = (u8)(propNumber & 0x00FF);
    cmd[4] = (u8)(propValue >> 8);
    cmd[5] = (u8)(propValue & 0x00FF);
	si47xx_command(6, cmd, 0,  0);
}

void si47xx_getPartInformation(void)
{

	cmd[0] = GET_REV;

	si47xx_command(1, cmd, 9, rsp);

	partNumber = rsp[1];
	fwMajor  = (char)rsp[2];
	fwMinor  = (char)rsp[3];
	patchID  = (u16)(rsp[4] << 8) | (u16)rsp[5];
	cmpMajor = (char)rsp[6];
	cmpMinor = (char)rsp[7];
	chipRev  = (char)rsp[8]; 
	
}

void si47xxFMRX_initialize(void)
{
	Bit.PoweredUp = 0;
    RSTB = 0;
	__delay_us(100);
    RSTB = 1;
	__delay_us(30);
    if (Bit.PoweredUp) {
    } else {
		cmd[0] = POWER_UP;
        cmd[1] = (POWER_UP_IN_FUNC_FMRX | 0x10) ;
        cmd[2] = POWER_UP_IN_OPMODE_RX_ANALOG;
		si47xx_command(3, cmd, 8, rsp);
		__delay_ms(POWERUP_TIME);
		Bit.PoweredUp = 1;
    }
   	si47xx_set_property(GPO_IEN, GPO_IEN_STCIEN_MASK);/* chack */
	/*
    si47xx_set_property(FM_SEEK_TUNE_SNR_THRESHOLD, 3);
    si47xx_set_property(FM_SEEK_TUNE_RSSI_THRESHOLD, 20);
	*/
	si47xx_set_property(FM_RDS_CONFIG, 0);              
	si47xx_set_property(FM_DEEMPHASIS, FM_DEEMPH_50US);
	/*
	si47xx_set_property(FM_SEEK_BAND_BOTTOM, 7600);     
	si47xx_set_property(FM_SEEK_BAND_TOP, 10800);        
	si47xx_set_property(FM_SEEK_FREQ_SPACING, 10);
	*/      
}
/*
void si47xxFMRX_set_volume(u8 volume)
{
    si47xx_set_property(RX_HARD_MUTE, 0);
    si47xx_set_property(RX_VOLUME, (u16)volume & RX_VOLUME_MASK);
}
*/
/*
void si47xxFMRX_mute(u8 mute)
{
    if(mute)
    	si47xx_set_property(RX_HARD_MUTE, 
                                RX_HARD_MUTE_RMUTE_MASK | RX_HARD_MUTE_LMUTE_MASK);
    else
    	si47xx_set_property(RX_HARD_MUTE, 0);
}
*/
static void fmTuneFreq(u16 frequency)
{
    cmd[0] = FM_TUNE_FREQ;
    cmd[1] = 0;
    cmd[2] = (u8)(frequency >> 8);
	cmd[3] = (u8)(frequency & 0x00FF);
    cmd[4] = (u8)0;
	si47xx_command(5, cmd, 1, rsp);
}

static void fmTuneStatus(u8 cancel, u8 intack)
{
    cmd[0] = FM_TUNE_STATUS;

	cmd[1] = 0;
    if(cancel) cmd[1] |= FM_TUNE_STATUS_IN_CANCEL;
	if(intack) cmd[1] |= FM_TUNE_STATUS_IN_INTACK;

	si47xx_command(2, cmd, 8, rsp);

    STC    = !!(rsp[0] & STCINT);
    BLTF   = !!(rsp[1] & FM_TUNE_STATUS_OUT_BTLF);
    AFCRL  = !!(rsp[1] & FM_TUNE_STATUS_OUT_AFCRL);
    Valid  = !!(rsp[1] & FM_TUNE_STATUS_OUT_VALID);
    Freq   = ((u16)rsp[2] << 8) | (u16)rsp[3];
    RSSI   = rsp[4];
    ASNR   = rsp[5];
    AntCap = rsp[7];   
}

//*static*/ void fmRsqStatus(void)
//{
//    cmd[0] = FM_RSQ_STATUS;

//	cmd[1] = 0;

//	si47xx_command(2, cmd, 8, rsp);

//    RSSI   = rsp[4];
//    ASNR   = rsp[5];
//}

void	tune_sub(unsigned int fm_mhz)
{
    fmTuneFreq(fm_mhz);
    while (!(getIntStatus() & STCINT));
    fmTuneStatus(0, 1);
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (u16)63 & RX_VOLUME_MASK);
	}
}

void    st_mono_sub(unsigned int data)
{
    switch(data){
        case 0:
            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x0031);
            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x001e);
            break;
        case 1:
            si47xx_set_property(FM_BLEND_STEREO_THRESHOLD, 0x007f);
            si47xx_set_property(FM_BLEND_MONO_THRESHOLD, 0x007f);            
            break;
    }
}